/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategySupplier;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteExperimental;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionStrategy;

@IgniteExperimental
public class ZstdDictionaryCompressionConfiguration
implements EntryCompressionConfiguration,
EntryCompressionStrategySupplier {
    public static final int DEFAULT_COMPRESSION_LEVEL = 2;
    public static final int DEFAULT_DICTIONARY_SIZE = 1024;
    public static final int DEFAULT_SAMPLES_BUFFER_SIZE = 0x400000;
    private int compressionLevel = 2;
    private int dictionarySize = 1024;
    private boolean requireDictionary = true;
    private int samplesBufSz = 0x400000;
    private boolean compressKeys;

    public Map<Class<ZstdDictionaryCompressionConfiguration>, IgniteClosure<ZstdDictionaryCompressionConfiguration, EntryCompressionStrategy>> strategies() {
        return Collections.singletonMap(ZstdDictionaryCompressionConfiguration.class, ZstdDictionaryCompressionStrategy::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZstdDictionaryCompressionConfiguration)) {
            return false;
        }
        ZstdDictionaryCompressionConfiguration that = (ZstdDictionaryCompressionConfiguration)o;
        return this.compressionLevel == that.compressionLevel && this.dictionarySize == that.dictionarySize && this.requireDictionary == that.requireDictionary && this.samplesBufSz == that.samplesBufSz;
    }

    public String toString() {
        return S.toString(ZstdDictionaryCompressionConfiguration.class, (Object)this);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public ZstdDictionaryCompressionConfiguration setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public ZstdDictionaryCompressionConfiguration setDictionarySize(int dictionarySize) {
        this.dictionarySize = dictionarySize;
        return this;
    }

    public boolean isRequireDictionary() {
        return this.requireDictionary;
    }

    public ZstdDictionaryCompressionConfiguration setRequireDictionary(boolean requireDictionary) {
        this.requireDictionary = requireDictionary;
        return this;
    }

    public int getSamplesBufferSize() {
        return this.samplesBufSz;
    }

    public ZstdDictionaryCompressionConfiguration setSamplesBufferSize(int samplesBufferSize) {
        this.samplesBufSz = samplesBufferSize;
        return this;
    }

    public boolean isCompressKeys() {
        return this.compressKeys;
    }

    public ZstdDictionaryCompressionConfiguration setCompressKeys(boolean compressKeys) {
        this.compressKeys = compressKeys;
        return this;
    }
}

