/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.junit.Test;

public class ZstdCompressionIncorrectParametersTest
extends GridCommonAbstractTest {
    protected void beforeTestsStarted() throws Exception {
        super.beforeTest();
        this.startGrids(2);
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testSamplesBufferSizeZero() {
        try {
            this.grid(0).createCache(new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(0).setDictionarySize(512).setRequireDictionary(true)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSamplesBufferSizeNegative() {
        try {
            this.grid(0).createCache(new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(-65536).setDictionarySize(512).setRequireDictionary(false)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDictionarySizeZero() {
        try {
            this.grid(0).createCache(new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setDictionarySize(0)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDictionarySizeNegative() {
        try {
            this.grid(0).createCache(new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setDictionarySize(-1024).setRequireDictionary(false)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testParametersDifferInGroup() {
        IgniteCache c = this.grid(0).createCache(new CacheConfiguration("default").setGroupName("group").setEntryCompressionConfiguration((EntryCompressionConfiguration)this.compressionCfg()));
        try {
            this.grid(0).createCache(new CacheConfiguration("default0").setGroupName("group"));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception ex) {
            ZstdCompressionIncorrectParametersTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression mismatch for caches related to the same group", (Class[])new Class[]{IgniteCheckedException.class}));
        }
        try {
            this.grid(0).createCache(new CacheConfiguration("default1").setGroupName("group").setEntryCompressionConfiguration((EntryCompressionConfiguration)this.compressionCfg().setCompressionLevel(2)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception ex) {
            ZstdCompressionIncorrectParametersTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression mismatch for caches related to the same group", (Class[])new Class[]{IgniteCheckedException.class}));
        }
        try {
            this.grid(0).createCache(new CacheConfiguration("default2").setGroupName("group").setEntryCompressionConfiguration((EntryCompressionConfiguration)this.compressionCfg().setRequireDictionary(true)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception ex) {
            ZstdCompressionIncorrectParametersTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression mismatch for caches related to the same group", (Class[])new Class[]{IgniteCheckedException.class}));
        }
        try {
            this.grid(0).createCache(new CacheConfiguration("default3").setGroupName("group").setEntryCompressionConfiguration((EntryCompressionConfiguration)this.compressionCfg().setSamplesBufferSize(524288)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception ex) {
            ZstdCompressionIncorrectParametersTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression mismatch for caches related to the same group", (Class[])new Class[]{IgniteCheckedException.class}));
        }
        try {
            this.grid(0).createCache(new CacheConfiguration("default4").setGroupName("group").setEntryCompressionConfiguration((EntryCompressionConfiguration)this.compressionCfg().setDictionarySize(512)));
            ZstdCompressionIncorrectParametersTest.fail((String)"Expected exception not thrown");
        }
        catch (Exception ex) {
            ZstdCompressionIncorrectParametersTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression mismatch for caches related to the same group", (Class[])new Class[]{IgniteCheckedException.class}));
        }
        c.destroy();
    }

    private ZstdDictionaryCompressionConfiguration compressionCfg() {
        return new ZstdDictionaryCompressionConfiguration().setCompressionLevel(3).setCompressKeys(true).setSamplesBufferSize(0x100000).setDictionarySize(1024).setRequireDictionary(false);
    }
}

