/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.junit.Test;

public class ZstdCompressionDictionaryCyclingTest
extends GridCommonAbstractTest {
    private static final int CYCLE = 100000;

    private CacheConfiguration cacheConfiguration() {
        return new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(196608));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(2);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testDictionaryFailedToBuild() {
        this.grid(0).createCache(this.cacheConfiguration());
        IgniteCache c = this.grid(1).cache("default");
        for (int i = 0; i < 100000; ++i) {
            c.put((Object)i, (Object)new TestObject(0L, null));
        }
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)0, (int)this.countDictionaries(this.grid(1), c, true));
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)0, (int)this.countDictionaries(this.grid(1), c, false));
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)100000, (int)c.size(new CachePeekMode[0]));
        MetricRegistry mreg = this.grid(0).context().metric().registry("cacheGroups.default.compression");
        double acceptance = ((DoubleMetric)mreg.findMetric("Acceptance")).value();
        ZstdCompressionDictionaryCyclingTest.assertEquals((String)("Acceptance: " + acceptance), (double)0.0, (double)acceptance);
        double ratio = ((DoubleMetric)mreg.findMetric("Ratio")).value();
        ZstdCompressionDictionaryCyclingTest.assertEquals((String)("Ratio: " + ratio), (double)1.0, (double)ratio);
        long totalCompNum = ((LongMetric)mreg.findMetric("RecordsCompressed")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("RecordsCompressed: " + totalCompNum), (0L < totalCompNum ? 1 : 0) != 0);
        long totalCompBytes = ((LongMetric)mreg.findMetric("BytesCompressed")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("BytesCompressed: " + totalCompBytes), (0L < totalCompBytes ? 1 : 0) != 0);
        long totalDecompNum = ((LongMetric)mreg.findMetric("RecordsDecompressed")).value();
        ZstdCompressionDictionaryCyclingTest.assertEquals((String)("RecordsDecompressed: " + totalDecompNum), (long)0L, (long)totalDecompNum);
        long totalDecompBytes = ((LongMetric)mreg.findMetric("BytesDecompressed")).value();
        ZstdCompressionDictionaryCyclingTest.assertEquals((String)("BytesDecompressed: " + totalDecompBytes), (long)0L, (long)totalDecompBytes);
    }

    @Test
    public void testDictionaryCycling() {
        IgniteCache c = this.grid(1).createCache(this.cacheConfiguration());
        for (int i = 0; i < 100000; ++i) {
            c.put((Object)i, (Object)new TestObject(i, "Lorem ipsum dolor sit amet, consectetur adipiscing elit".substring(i % 50)));
        }
        int beforeChange = this.countDictionaries(this.grid(1), c, true);
        ZstdCompressionDictionaryCyclingTest.assertTrue((beforeChange >= 1 && beforeChange <= 3 ? 1 : 0) != 0);
        int trained = this.countDictionaries(this.grid(0), c, false);
        ZstdCompressionDictionaryCyclingTest.assertEquals((String)("TrainedDictionaries: " + trained), (int)3, (int)trained);
        MetricRegistry mreg = this.grid(0).context().metric().registry("cacheGroups.default.compression");
        int samples = ((IntMetric)mreg.findMetric("CollectedSamples")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("CollectedSamples: " + samples), (samples > 1000 && samples < 10000 ? 1 : 0) != 0);
        int bytes = ((IntMetric)mreg.findMetric("CollectedSampleBytes")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("CollectedSampleBytes: " + bytes), (bytes > 192512 && bytes < 204800 ? 1 : 0) != 0);
        log.info("=== Changing data structure ===");
        for (int i = 1; i <= 100000; ++i) {
            c.get((Object)i);
            c.put((Object)(-i), (Object)new TestObject(-i, "Ut enim ad minim veniam, quis nostrud exercitation".substring(i % 50)));
        }
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)(beforeChange + 1), (int)this.countDictionaries(this.grid(1), c, true));
        trained = this.countDictionaries(this.grid(0), c, false);
        ZstdCompressionDictionaryCyclingTest.assertEquals((String)("TrainedDictionaries: " + trained), (int)4, (int)trained);
        samples = ((IntMetric)mreg.findMetric("CollectedSamples")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("CollectedSamples: " + samples), (samples > 1000 && samples < 10000 ? 1 : 0) != 0);
        bytes = ((IntMetric)mreg.findMetric("CollectedSampleBytes")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("CollectedSampleBytes: " + bytes), (bytes > 192512 && bytes < 204800 ? 1 : 0) != 0);
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)200000, (int)c.size(new CachePeekMode[0]));
        this.checkMetrics(true);
    }

    @Test
    public void testDictionaryAdjustmentCap() {
        IgniteCache c = this.grid(1).createCache(this.cacheConfiguration());
        for (int i = 0; i < 600000; ++i) {
            c.put((Object)i, (Object)new TestObject(i, "Excepteur sint occaecat cupidatat non proident, sunt in".substring(i % 50)));
        }
        int active = this.countDictionaries(this.grid(0), c, true);
        ZstdCompressionDictionaryCyclingTest.assertTrue((active >= 1 && active <= 4 ? 1 : 0) != 0);
        int trained = this.countDictionaries(this.grid(0), c, false);
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)6, (int)trained);
        ZstdCompressionDictionaryCyclingTest.assertEquals((int)600000, (int)c.size(new CachePeekMode[0]));
        this.checkMetrics(false);
    }

    private int countDictionaries(IgniteEx grid, IgniteCache c, boolean active) {
        MetricRegistry mreg = grid.context().metric().registry("cacheGroups." + c.getName() + ".compression");
        return ((IntMetric)mreg.findMetric(active ? "ActiveDictionaries" : "TrainedDictionaries")).value();
    }

    private void checkMetrics(boolean decompress) {
        MetricRegistry mreg = this.grid(0).context().metric().registry("cacheGroups.default.compression");
        double acceptance = ((DoubleMetric)mreg.findMetric("Acceptance")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("Acceptance: " + acceptance), (acceptance > 0.7 && acceptance <= 1.0 ? 1 : 0) != 0);
        double ratio = ((DoubleMetric)mreg.findMetric("Ratio")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("Ratio: " + ratio), (ratio > 0.5 && ratio < 0.9 ? 1 : 0) != 0);
        long totalCompNum = ((LongMetric)mreg.findMetric("RecordsCompressed")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("RecordsCompressed: " + totalCompNum), (totalCompNum > 33333L && totalCompNum < 300000L ? 1 : 0) != 0);
        long totalCompBytes = ((LongMetric)mreg.findMetric("BytesCompressed")).value();
        ZstdCompressionDictionaryCyclingTest.assertTrue((String)("BytesCompressed: " + totalCompBytes), (totalCompBytes > 5000000L && totalCompBytes < 30000000L ? 1 : 0) != 0);
        if (decompress) {
            long totalDecompNum = ((LongMetric)mreg.findMetric("RecordsDecompressed")).value();
            ZstdCompressionDictionaryCyclingTest.assertTrue((String)("RecordsDecompressed: " + totalDecompNum), (totalDecompNum > 16666L && totalDecompNum < 200000L ? 1 : 0) != 0);
            long totalDecompBytes = ((LongMetric)mreg.findMetric("BytesDecompressed")).value();
            ZstdCompressionDictionaryCyclingTest.assertTrue((String)("BytesDecompressed: " + totalDecompBytes), (totalDecompBytes > 1000000L && totalDecompBytes < 10000000L ? 1 : 0) != 0);
        }
    }

    private static class TestObject {
        private long lVal;
        private String strVal;

        private TestObject(long lVal, String strVal) {
            this.lVal = lVal;
            this.strVal = strVal;
        }
    }
}

