/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.columnar.Environment;

public class NativeLibraryLoader {
    private static final IgniteLogger LOGGER = Loggers.forClass(NativeLibraryLoader.class);
    private static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    private static final Environment environment = Environment.detectSystemEnvironment();
    private static final String JNI_LIBRARY_NAME = environment.getJniLibraryName("columnar");
    private static final String JNI_LIBRARY_FILE_NAME = environment.getJniLibraryFileName("columnar");
    private static final String TEMP_FILE_PREFIX = String.format("lib%s-", JNI_LIBRARY_NAME);
    private static final String TEMP_FILE_SUFFIX = environment.getJniLibraryExtension(true);

    public static NativeLibraryLoader getInstance() {
        return INSTANCE;
    }

    public synchronized boolean tryLoadLibrary() {
        Path libraryFile;
        try {
            libraryFile = NativeLibraryLoader.extractLibraryFromJar();
        }
        catch (LibraryNotFound ex) {
            LOGGER.warn("Could not find matching library - this platform or architecture is probably not supported [libraryName={}].", new Object[]{JNI_LIBRARY_FILE_NAME});
            return false;
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to extract library from jar [libraryName={}].", (Throwable)ex, new Object[]{JNI_LIBRARY_FILE_NAME});
            return false;
        }
        try {
            System.load(libraryFile.toString());
            LOGGER.info("Library is successfully loaded [libraryName={}].", new Object[]{JNI_LIBRARY_FILE_NAME});
            return true;
        }
        catch (Exception | LinkageError ex) {
            LOGGER.warn("Unable to load native library [file={}].", ex, new Object[]{libraryFile});
            return false;
        }
    }

    private static Path extractLibraryFromJar() throws IOException, LibraryNotFound {
        ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
        URL libraryUri = classLoader.getResource(JNI_LIBRARY_FILE_NAME);
        if (libraryUri == null) {
            throw new LibraryNotFound();
        }
        if ("file".equals(libraryUri.getProtocol())) {
            return Path.of(libraryUri.getPath(), new String[0]);
        }
        Path libraryFile = NativeLibraryLoader.createTemporaryFile();
        try (InputStream is = libraryUri.openStream();){
            Files.copy(is, libraryFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return libraryFile;
    }

    private static Path createTemporaryFile() throws IOException {
        Path libraryFile = Files.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new FileAttribute[0]);
        if (!Files.exists(libraryFile, new LinkOption[0])) {
            throw new RuntimeException("File " + libraryFile + " does not exist.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.delete(libraryFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete native library file", e);
            }
        }));
        return libraryFile;
    }

    private NativeLibraryLoader() {
    }

    private static class LibraryNotFound
    extends Exception {
        private static final long serialVersionUID = -3190355429833095354L;

        private LibraryNotFound() {
            super(null, null, true, false);
        }
    }
}

