/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import org.gridgain.internal.columnar.ColumnarStorageException;

class NativeHandle {
    private final String handleName;
    private long handle;
    private final ReadWriteLock handleRwLock = new ReentrantReadWriteLock();

    NativeHandle(String name, long handle) {
        this.handleName = name;
        this.handle = handle;
    }

    public void use(LongConsumer operation) {
        this.handleRwLock.readLock().lock();
        try {
            if (this.handle == 0L) {
                throw new ColumnarStorageException(this.handleName + " handle is already disposed");
            }
            operation.accept(this.handle);
        }
        finally {
            this.handleRwLock.readLock().unlock();
        }
    }

    public <T> T apply(LongFunction<T> operation) {
        this.handleRwLock.readLock().lock();
        try {
            if (this.handle == 0L) {
                throw new ColumnarStorageException(this.handleName + " handle is already disposed");
            }
            T t = operation.apply(this.handle);
            return t;
        }
        finally {
            this.handleRwLock.readLock().unlock();
        }
    }

    public void dispose(LongConsumer disposeOperation) {
        this.handleRwLock.writeLock().lock();
        try {
            if (this.handle != 0L) {
                disposeOperation.accept(this.handle);
                this.handle = 0L;
            }
        }
        finally {
            this.handleRwLock.writeLock().unlock();
        }
    }
}

