/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class Environment {
    private static final String SPARCV9 = "sparcv9";
    private static final String LIBC_MUSL_PREFIX = "libc.musl";
    private final String os;
    private final String arch;
    private final boolean isMuslEnvironment;

    public Environment(String os, String arch) {
        this(os, arch, false);
    }

    public Environment(String os, String arch, boolean isMuslEnvironment) {
        this.os = os.toLowerCase(Locale.getDefault());
        this.arch = arch.toLowerCase(Locale.getDefault());
        this.isMuslEnvironment = isMuslEnvironment;
    }

    static Environment detectSystemEnvironment() {
        String os = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        String arch = System.getProperty("os.arch").toLowerCase(Locale.getDefault());
        boolean isLibmuslEnvironment = Environment.getUserExplicitLibmuslChoice().orElseGet(() -> Environment.detectIsMuslLibc(os, arch));
        return new Environment(os, arch, isLibmuslEnvironment);
    }

    private static Optional<Boolean> getUserExplicitLibmuslChoice() {
        return Optional.ofNullable(System.getenv("GRIDGAIN_COLUMNAR_MUSL_LIBC")).map(Boolean::parseBoolean);
    }

    public String os() {
        return this.os;
    }

    public String arch() {
        return this.arch;
    }

    public boolean isAarch64() {
        return Environment.isAarch64(this.arch);
    }

    private static boolean isAarch64(String arch) {
        return arch.contains("aarch64");
    }

    private boolean isPowerPC() {
        return Environment.isPowerPC(this.arch);
    }

    private static boolean isPowerPC(String arch) {
        return arch.contains("ppc");
    }

    public boolean isS390x() {
        return this.arch.contains("s390x");
    }

    private boolean isRiscv64() {
        return this.arch.contains("riscv64");
    }

    public boolean isWindows() {
        return this.os.contains("win");
    }

    private boolean isFreeBSD() {
        return this.os.contains("freebsd");
    }

    public boolean isMac() {
        return this.os.contains("mac");
    }

    public boolean isAix() {
        return this.os.contains("aix");
    }

    public boolean isUnix() {
        return this.os.contains("nix") || this.os.contains("nux");
    }

    private static boolean isUnix(String os) {
        return os.contains("nix") || os.contains("nux");
    }

    public boolean isSolaris() {
        return this.os.contains("sunos");
    }

    private boolean isOpenBSD() {
        return this.os.contains("openbsd");
    }

    private boolean is64Bit() {
        if (this.arch.contains(SPARCV9)) {
            return true;
        }
        return this.arch.indexOf("64") > 0;
    }

    String getJniLibraryName(String name) {
        if (!this.isUnix() && this.isMuslEnvironment) {
            throw new UnsupportedOperationException("Can't use musl libc on non-unix systems");
        }
        if (this.isUnix()) {
            String amdArch;
            String string = amdArch = this.is64Bit() ? "64" : "32";
            if (this.isPowerPC() || this.isAarch64() || this.isRiscv64()) {
                return String.format("%sjni-linux-%s%s", name, this.arch(), this.getLibcPostfix());
            }
            if (this.isS390x()) {
                return String.format("%sjni-linux-%s", name, this.arch());
            }
            return String.format("%sjni-linux-x%s%s", name, amdArch, this.getLibcPostfix());
        }
        if (this.isMac()) {
            if (this.is64Bit()) {
                String arch = this.isAarch64() ? "arm64" : "x86_64";
                return String.format("%sjni-osx-%s", name, arch);
            }
            return String.format("%sjni-osx", name);
        }
        if (this.isFreeBSD()) {
            return String.format("%sjni-freebsd%s", name, this.is64Bit() ? "64" : "32");
        }
        if (this.isAix() && this.is64Bit()) {
            return String.format("%sjni-aix64", name);
        }
        if (this.isSolaris()) {
            String arch = this.is64Bit() ? "64" : "32";
            return String.format("%sjni-solaris%s", name, arch);
        }
        if (this.isWindows() && this.is64Bit()) {
            return String.format("%sjni-win64", name);
        }
        if (this.isOpenBSD()) {
            return String.format("%sjni-openbsd%s", name, this.is64Bit() ? "64" : "32");
        }
        throw new UnsupportedOperationException(String.format("Cannot determine JNI library name for ARCH='%s' OS='%s' name='%s'", this.arch(), this.os(), name));
    }

    @Nullable
    private String getFallbackJniLibraryName(String name) {
        if (this.isMac() && this.is64Bit() && !this.isAarch64()) {
            return String.format("%sjni-osx", name);
        }
        return null;
    }

    public String getJniLibraryFileName(String name) {
        return this.appendLibOsSuffix("lib" + this.getJniLibraryName(name), true);
    }

    @Nullable
    public String getFallbackJniLibraryFileName(String name) {
        String fallbackJniLibraryName = this.getFallbackJniLibraryName(name);
        if (fallbackJniLibraryName == null) {
            return null;
        }
        return this.appendLibOsSuffix("lib" + fallbackJniLibraryName, true);
    }

    private String appendLibOsSuffix(String libraryFileName, boolean shared) {
        return libraryFileName + this.getJniLibraryExtension(shared);
    }

    String getJniLibraryExtension(boolean shared) {
        if (this.isUnix() || this.isAix() || this.isSolaris() || this.isFreeBSD() || this.isOpenBSD()) {
            return ".so";
        }
        if (this.isMac()) {
            return shared ? ".dylib" : ".jnilib";
        }
        if (this.isWindows()) {
            return ".dll";
        }
        throw new UnsupportedOperationException();
    }

    private String getLibcPostfix() {
        String libcName = this.getLibcName();
        if (libcName == null) {
            return "";
        }
        return "-" + libcName;
    }

    @Nullable
    private String getLibcName() {
        if (this.isMuslEnvironment) {
            return "musl";
        }
        return null;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static boolean detectIsMuslLibc(String os, String arch) {
        if (!Environment.isUnix(os)) {
            return false;
        }
        if (Environment.findMuslWithLdd()) {
            return true;
        }
        Path lib = Path.of("/lib", new String[0]);
        if (Files.isDirectory(lib, new LinkOption[0]) && Files.isReadable(lib)) {
            boolean bl;
            block12: {
                String possibleMuslcLibName = Environment.isPowerPC(arch) ? "libc.musl-ppc64le.so.1" : (Environment.isAarch64(arch) ? "libc.musl-aarch64.so.1" : "libc.musl-x86_64.so.1");
                Path possibleMuslcLib = lib.resolve(possibleMuslcLibName);
                if (Files.isRegularFile(possibleMuslcLib, new LinkOption[0]) && Files.isReadable(possibleMuslcLib)) {
                    return true;
                }
                Stream<Path> filesList = Files.list(lib);
                try {
                    bl = filesList.anyMatch(libFile -> libFile.getFileName().startsWith(LIBC_MUSL_PREFIX));
                    if (filesList == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (filesList != null) {
                            try {
                                filesList.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
                filesList.close();
            }
            return bl;
        }
        return false;
    }

    private static boolean findMuslWithLdd() {
        try {
            Process lddProcess = new ProcessBuilder("/usr/bin/env", "sh", "-c", "ldd /usr/bin/env | grep -q musl").start();
            if (lddProcess.waitFor() == 0) {
                return true;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "Environment(os = " + this.os + ", arch = " + this.arch + ", isMuslEnvironment = " + this.isMuslEnvironment + ")";
    }
}

