/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.gridgain.internal.columnar.NativeInterface;
import org.jetbrains.annotations.Nullable;

class DirectByteBufferHolder {
    @Nullable
    private ByteBuffer buffer;

    DirectByteBufferHolder() {
    }

    ByteBuffer get(int size) {
        if (this.buffer == null || this.buffer.capacity() < size) {
            this.buffer = ByteBuffer.allocateDirect(size);
            this.buffer.order(NativeInterface.BYTE_ORDER);
        }
        this.buffer.clear();
        return this.buffer;
    }

    ByteBuffer get() {
        return this.get(0);
    }

    void set(ByteBuffer buf) {
        this.buffer = buf;
        this.buffer.order(NativeInterface.BYTE_ORDER);
    }

    ByteBuffer use(Function<ByteBuffer, ByteBuffer> bufferUsage) {
        ByteBuffer reusedBuffer = this.get();
        ByteBuffer reallocatedBuffer = bufferUsage.apply(reusedBuffer);
        if (reallocatedBuffer != null) {
            this.set(reallocatedBuffer);
            return reallocatedBuffer;
        }
        return reusedBuffer;
    }
}

