/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.secondary.SecondaryStorage;
import org.apache.ignite.internal.storage.secondary.SecondaryStorageTableDescriptor;
import org.apache.ignite.internal.storage.secondary.SecondaryTableStorage;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.columnar.ColumnarPartitionStorage;
import org.gridgain.internal.columnar.ColumnarStorageEngine;
import org.jetbrains.annotations.Nullable;

public class ColumnarTableStorage
implements SecondaryTableStorage {
    private final int zoneId;
    private final ColumnarStorageEngine storage;
    private final SecondaryStorageTableDescriptor tableDescriptor;
    private volatile AtomicReferenceArray<SecondaryStorage> partitions;
    private volatile boolean stopped = false;
    private volatile boolean destroyed = false;

    ColumnarTableStorage(ColumnarStorageEngine storage, SecondaryStorageTableDescriptor tableDescriptor) {
        this.storage = storage;
        this.tableDescriptor = tableDescriptor;
        this.zoneId = tableDescriptor.getSecondaryZoneId();
    }

    public int zoneId() {
        return this.zoneId;
    }

    public SecondaryStorage getOrCreatePartition(int partId) throws StorageException {
        SecondaryStorage wrapper = this.getPartition(partId);
        if (wrapper != null) {
            return wrapper;
        }
        ColumnarPartitionStorage actualStorage = this.storage.getTablePartition(this.tableDescriptor.getId(), partId);
        if (actualStorage == null) {
            actualStorage = this.storage.createTablePartition(this.tableDescriptor, partId);
        }
        assert (actualStorage != null) : "Unable to get or create columnar partition storage";
        this.partitions.set(partId, actualStorage);
        return actualStorage;
    }

    @Nullable
    public SecondaryStorage getPartition(int partId) {
        assert (!this.stopped) : "Storage has been stopped";
        this.checkPartitionId(partId);
        return this.partitions.get(partId);
    }

    public void destroyPartition(int partId) throws StorageException {
        SecondaryStorage partition = this.getPartition(partId);
        if (partition != null) {
            this.partitions.set(partId, null);
            partition.destroy();
        }
    }

    public void start() throws StorageException {
        this.partitions = new AtomicReferenceArray(this.tableDescriptor.getPartitions());
    }

    public void destroy() throws StorageException {
        this.close();
        if (this.destroyed) {
            return;
        }
        for (int i = 0; i < this.partitions.length(); ++i) {
            SecondaryStorage partition = this.partitions.get(i);
            if (partition == null) continue;
            this.partitions.set(i, null);
            this.storage.dropTablePartition(this.tableDescriptor.getId(), partition.partitionId());
        }
        this.destroyed = true;
    }

    private void checkPartitionId(int partId) {
        if (partId < 0 || partId >= this.partitions.length()) {
            throw new IllegalArgumentException(S.toString((String)"Unable to access partition with id outside of configured range", (String)"tableId", (Object)this.tableDescriptor.getId(), (boolean)false, (String)"partitionId", (Object)partId, (boolean)false, (String)"partitions", (Object)this.partitions.length(), (boolean)false));
        }
    }

    public void close() throws StorageException {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        ArrayList<SecondaryStorage> resources = new ArrayList<SecondaryStorage>();
        for (int i = 0; i < this.partitions.length(); ++i) {
            SecondaryStorage partition = this.partitions.get(i);
            if (partition == null) continue;
            resources.add(partition);
        }
        Collections.reverse(resources);
        try {
            IgniteUtils.closeAll(resources);
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop Columnar Storage table storage.", (Throwable)e);
        }
    }
}

