/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowImpl;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.TimedBinaryRowAndRowId;
import org.apache.ignite.internal.storage.operation.AggregatedScan;
import org.apache.ignite.internal.storage.operation.StorageOptimizedOperation;
import org.apache.ignite.internal.storage.secondary.BinaryRowAndRowId;
import org.apache.ignite.internal.storage.secondary.SecondaryStorage;
import org.apache.ignite.internal.storage.secondary.TimestampAndRowId;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.gridgain.internal.columnar.ColumnarStorageEngine;
import org.gridgain.internal.columnar.DirectByteBufferHolder;
import org.gridgain.internal.columnar.NativeCursor;
import org.gridgain.internal.columnar.NativeHandle;
import org.gridgain.internal.columnar.NativeInterface;
import org.jetbrains.annotations.Nullable;

public class ColumnarPartitionStorage
implements SecondaryStorage {
    private static final int ROWS_COUNT_FIELD_SIZE = 4;
    private static final int ROW_SCHEMA_VERSION_FIELD_SIZE = 4;
    private static final int ROW_SIZE_FIELD_SIZE = 4;
    private static final int ROW_ID_FIELD_SIZE = 16;
    private final NativeHandle handle;
    private final int partId;
    private final int tableId;
    private final ColumnarStorageEngine storage;
    private static final ThreadLocal<DirectByteBufferHolder> directBufferHolder = ThreadLocal.withInitial(DirectByteBufferHolder::new);
    private static final ThreadLocal<DirectByteBufferHolder> directResultHolder = ThreadLocal.withInitial(DirectByteBufferHolder::new);
    private TimestampAndRowId lastPersistedRow;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    ColumnarPartitionStorage(ColumnarStorageEngine storage, long handle, int tableId, int partId) {
        this.storage = storage;
        this.handle = new NativeHandle(IgniteStringFormatter.format((String)"ColumnarPartitionStorage(table={},part={})", (Object[])new Object[]{tableId, partId}), handle);
        this.partId = partId;
        this.tableId = tableId;
        this.lastPersistedRow = this.readLastPersistedRow();
    }

    public int tableId() {
        return this.tableId;
    }

    public int partitionId() {
        return this.partId;
    }

    public void destroy() throws StorageException {
        try {
            this.close();
            this.storage.dropTablePartition(this.tableId, this.partId);
        }
        catch (Exception e) {
            throw new StorageException("Unable to delete partition " + this.partId, (Throwable)e);
        }
    }

    public void close() throws Exception {
        this.handle.dispose(ColumnarStorageEngine::releaseTablePartition);
    }

    private static long encodeFuncType(AggregatedScan.Aggregate.Function function) {
        switch (function) {
            case COUNT: {
                return 0L;
            }
            case SUM: {
                return 1L;
            }
            case AVG: {
                return 2L;
            }
            case MIN: {
                return 3L;
            }
            case MAX: {
                return 4L;
            }
            case ANY_VALUE: {
                return 5L;
            }
        }
        throw new UnsupportedOperationException("Unsupported aggregate function");
    }

    private static long serializeAggregate(AggregatedScan.Aggregate aggregate, boolean distinct) {
        long value = 0L;
        long func = ColumnarPartitionStorage.encodeFuncType(aggregate.function());
        long distinctValue = distinct ? 1L : 0L;
        value |= ((long)aggregate.columnIndex() & 0xFFFFFFFFL) << 32;
        value |= (func & 7L) << 1;
        return value |= (distinctValue & 1L) << 0;
    }

    public void upsert(ByteBuffer bin, RowId rowId, HybridTimestamp timestamp) {
        ByteBuffer direct = directBufferHolder.get().get(bin.rewind().limit());
        direct.put(bin);
        this.handle.use(ptr -> NativeInterface.upsert(ptr, timestamp.longValue(), rowId.uuid().getLeastSignificantBits(), rowId.uuid().getMostSignificantBits(), GridUnsafe.bufferAddress((ByteBuffer)direct), direct.position()));
    }

    public boolean remove(ByteBuffer bin, RowId rowId, HybridTimestamp timestamp) {
        ByteBuffer direct = directBufferHolder.get().get(bin.rewind().limit());
        direct.put(bin);
        return this.handle.apply(ptr -> NativeInterface.remove(ptr, timestamp.longValue(), rowId.leastSignificantBits(), rowId.mostSignificantBits(), GridUnsafe.bufferAddress((ByteBuffer)direct), direct.position()));
    }

    public TimestampAndRowId getLastPersistedRow() {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            TimestampAndRowId timestampAndRowId = this.lastPersistedRow;
            return timestampAndRowId;
        }
        finally {
            readLock.unlock();
        }
    }

    private TimestampAndRowId readLastPersistedRow() {
        ByteBuffer reallocated = this.handle.apply(ptr -> directBufferHolder.get().use(buffer -> NativeInterface.getLastPersistedRow(ptr, GridUnsafe.bufferAddress((ByteBuffer)buffer), buffer.limit())));
        long timestamp = reallocated.getLong();
        long uuidLsb = reallocated.getLong();
        long uuidMsb = reallocated.getLong();
        if (timestamp == 0L) {
            return new TimestampAndRowId(HybridTimestamp.MIN_VALUE, RowId.lowestRowId((int)this.partId));
        }
        return new TimestampAndRowId(HybridTimestamp.hybridTimestamp((long)timestamp), new RowId(this.partitionId(), uuidMsb, uuidLsb));
    }

    public void doFullCompaction() {
        this.handle.use(NativeInterface::doFullCompaction);
    }

    public NativeCursor query(HybridTimestamp timestamp) {
        return new NativeCursor(this.handle.apply(ptr -> NativeInterface.createCursor(ptr, timestamp.longValue(), null)));
    }

    NativeCursor query(HybridTimestamp timestamp, @Nullable BitSet columnsToInclude) {
        if (columnsToInclude == null) {
            return this.query(timestamp);
        }
        return new NativeCursor(this.handle.apply(ptr -> NativeInterface.createCursor(ptr, timestamp.longValue(), columnsToInclude.toLongArray())));
    }

    NativeCursor query(HybridTimestamp timestamp, AggregatedScan scanOp) {
        long[] groupSet = null;
        if (scanOp.groupingColumns() != null) {
            groupSet = scanOp.groupingColumns().toLongArray();
        }
        List aggCalls = scanOp.aggregates();
        long[] aggCallsSerialized = new long[aggCalls.size()];
        for (int i = 0; i < aggCalls.size(); ++i) {
            aggCallsSerialized[i] = ColumnarPartitionStorage.serializeAggregate((AggregatedScan.Aggregate)aggCalls.get(i), false);
        }
        long[] effectiveGroupSet = groupSet;
        return new NativeCursor(this.handle.apply(ptr -> NativeInterface.createAggregateCursor(ptr, timestamp.longValue(), effectiveGroupSet, aggCallsSerialized)));
    }

    public void addColumn(String columnName, NativeType type, boolean nullable) {
        this.handle.use(ptr -> NativeInterface.addColumn(ptr, NativeInterface.nativeTypeToCppTypeId(type), columnName, nullable));
    }

    public void dropColumn(String columnName) {
        this.handle.use(ptr -> NativeInterface.dropColumn(ptr, columnName));
    }

    public void modifyColumnType(String columnName, NativeType type, boolean nullable) {
        this.handle.use(ptr -> NativeInterface.modifyColumnType(ptr, NativeInterface.nativeTypeToCppTypeId(type), columnName, nullable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBatch(List<BinaryRowAndRowId> rows, HybridTimestamp timestamp) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.writeBatchUnderLock(rows, timestamp);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void writeBatch(List<TimedBinaryRowAndRowId> rows) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.writeBatchUnderLock(rows);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void writeBatchUnderLock(List<BinaryRowAndRowId> rows, HybridTimestamp timestamp) {
        if (timestamp.compareTo(this.lastPersistedRow.timestamp()) < 0) {
            return;
        }
        int totalBytesSize = 4;
        int firstApplicableRowIndex = rows.size();
        boolean timestampIsNewer = timestamp.compareTo(this.lastPersistedRow.timestamp()) > 0;
        for (BinaryRowAndRowId row : rows) {
            if (!timestampIsNewer && row.rowId().compareTo(this.lastPersistedRow.rowId()) <= 0) continue;
            --firstApplicableRowIndex;
            BinaryRow binaryRow = row.binaryRow();
            ByteBuffer binaryTuple = binaryRow.tupleSlice();
            totalBytesSize += 4;
            totalBytesSize += 4;
            totalBytesSize += 16;
            totalBytesSize += binaryTuple.remaining();
        }
        ByteBuffer directBuffer = directBufferHolder.get().get(totalBytesSize);
        directBuffer.putInt(rows.size() - firstApplicableRowIndex);
        for (int i = firstApplicableRowIndex; i < rows.size(); ++i) {
            BinaryRowAndRowId row = rows.get(i);
            BinaryRow binaryRow = row.binaryRow();
            ByteBuffer binaryTuple = binaryRow.tupleSlice();
            int schemaVersion = row.schemaVersion();
            directBuffer.putInt(schemaVersion);
            directBuffer.putInt(binaryTuple.remaining());
            directBuffer.putLong(row.rowId().uuid().getLeastSignificantBits());
            directBuffer.putLong(row.rowId().uuid().getMostSignificantBits());
            directBuffer.put(binaryTuple);
        }
        this.handle.use(ptr -> NativeInterface.processBatch(ptr, timestamp.longValue(), GridUnsafe.bufferAddress((ByteBuffer)directBuffer), directBuffer.position()));
        if (firstApplicableRowIndex < rows.size()) {
            BinaryRowAndRowId lastRow = rows.get(rows.size() - 1);
            this.lastPersistedRow = new TimestampAndRowId(timestamp, lastRow.rowId());
        }
    }

    private void writeBatchUnderLock(List<TimedBinaryRowAndRowId> rows) {
        if (rows.isEmpty() || rows.get(0).rowId().compareTo(this.lastPersistedRow.rowId()) < 0) {
            return;
        }
        boolean rowIdIsNewer = rows.get(0).rowId().compareTo(this.lastPersistedRow.rowId()) > 0;
        for (TimedBinaryRowAndRowId row : rows) {
            if (!rowIdIsNewer && row.commitTimestamp().compareTo(this.lastPersistedRow.timestamp()) <= 0) continue;
            BinaryRow binaryRow = row.binaryRow();
            ByteBuffer binaryTuple = binaryRow.tupleSlice();
            int totalBytesSize = 4;
            totalBytesSize += 4;
            totalBytesSize += 4;
            totalBytesSize += 16;
            ByteBuffer directBuffer = directBufferHolder.get().get(totalBytesSize += binaryTuple.remaining());
            directBuffer.putInt(1);
            int schemaVersion = row.binaryRow().schemaVersion();
            directBuffer.putInt(schemaVersion);
            directBuffer.putInt(binaryTuple.remaining());
            directBuffer.putLong(row.rowId().uuid().getLeastSignificantBits());
            directBuffer.putLong(row.rowId().uuid().getMostSignificantBits());
            directBuffer.put(binaryTuple);
            this.handle.use(ptr -> NativeInterface.processBatch(ptr, row.commitTimestamp().longValue(), GridUnsafe.bufferAddress((ByteBuffer)directBuffer), directBuffer.position()));
            this.lastPersistedRow = new TimestampAndRowId(row.commitTimestamp(), row.rowId());
        }
    }

    @Nullable
    public ByteBuffer read(ByteBuffer key, HybridTimestamp timestamp) {
        DirectByteBufferHolder resultHolder = directResultHolder.get();
        ByteBuffer directKey = ByteBuffer.allocateDirect(key.rewind().limit());
        directKey.order(NativeInterface.BYTE_ORDER);
        directKey.put(key);
        ByteBuffer result = this.handle.apply(ptr -> resultHolder.use(buffer -> NativeInterface.readRow(ptr, timestamp.longValue(), GridUnsafe.bufferAddress((ByteBuffer)directKey), directKey.position(), GridUnsafe.bufferAddress((ByteBuffer)buffer), buffer.limit())));
        int size = result.getInt();
        if (size == 0) {
            return null;
        }
        byte[] tuple = new byte[size];
        result.get(tuple, 0, size);
        return ByteBuffer.wrap(tuple).order(NativeInterface.BYTE_ORDER);
    }

    @Nullable
    public BinaryRow read(BinaryRow key, HybridTimestamp timestamp) throws StorageException {
        ByteBuffer buffer = this.read(key.tupleSlice(), timestamp);
        return null == buffer ? null : new BinaryRowImpl(0, buffer);
    }

    public Cursor<BinaryRow> scan(HybridTimestamp timestamp, @Nullable BitSet columnsToInclude) throws StorageException {
        return new ScanCursor(this.query(timestamp, columnsToInclude));
    }

    public Cursor<BinaryRow> scanWithOperation(HybridTimestamp timestamp, StorageOptimizedOperation operation) throws StorageException {
        if (operation instanceof AggregatedScan) {
            AggregatedScan scan = (AggregatedScan)operation;
            return new ScanCursor(this.query(timestamp, scan));
        }
        throw new StorageException((Throwable)new UnsupportedOperationException());
    }

    public void updateRaftConfiguration(long lastAppliedIndex, long lastAppliedTerm) {
        this.handle.use(ptr -> NativeInterface.updateRaftConfiguration(ptr, lastAppliedIndex, lastAppliedTerm));
    }

    public void updateRaftConfiguration(long lastAppliedIndex, long lastAppliedTerm, byte[] config) {
        this.handle.use(ptr -> NativeInterface.updateRaftConfiguration(ptr, lastAppliedIndex, lastAppliedTerm, config));
    }

    public byte @Nullable [] getRaftNodeConfiguration() {
        ByteBuffer result = this.handle.apply(ptr -> directBufferHolder.get().use(buffer -> NativeInterface.getRaftNodeConfiguration(ptr, GridUnsafe.bufferAddress((ByteBuffer)buffer), buffer.limit())));
        int confLength = result.getInt();
        if (confLength == 0) {
            return null;
        }
        byte[] bytes = new byte[confLength];
        result.get(bytes, 0, confLength);
        return bytes;
    }

    public long getLastAppliedIndex() {
        return this.handle.apply(NativeInterface::getLastAppliedIndex);
    }

    public long getLastAppliedTerm() {
        return this.handle.apply(NativeInterface::getLastAppliedTerm);
    }

    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.handle.use(ptr -> NativeInterface.updateLease(ptr, leaseStartTime, primaryReplicaNodeId.getLeastSignificantBits(), primaryReplicaNodeId.getMostSignificantBits(), primaryReplicaNodeName));
    }

    public long getLeaseStartTime() {
        return this.handle.apply(NativeInterface::getLeaseStartTime);
    }

    @Nullable
    public UUID getPrimaryReplicaNodeId() {
        ByteBuffer result = this.handle.apply(ptr -> directBufferHolder.get().use(reusableBuffer -> NativeInterface.getPrimaryReplicaNodeId(ptr, GridUnsafe.bufferAddress((ByteBuffer)reusableBuffer), reusableBuffer.limit())));
        int size = result.getInt();
        if (size == 0) {
            return null;
        }
        if (size != 16) {
            throw new StorageException("Wrong data size: {}, should be exactly 16 bytes", new Object[]{size});
        }
        long uuidLsb = result.getLong();
        long uuidMsb = result.getLong();
        return new UUID(uuidMsb, uuidLsb);
    }

    @Nullable
    public String getPrimaryReplicaNodeName() {
        ByteBuffer result = directBufferHolder.get().use(buffer -> this.handle.apply(ptr -> NativeInterface.getPrimaryReplicaNodeName(ptr, GridUnsafe.bufferAddress((ByteBuffer)buffer), buffer.limit())));
        int size = result.getInt();
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        result.get(bytes, 0, size);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static class ScanCursor
    implements Cursor<BinaryRow> {
        private final NativeCursor nativeCursor;
        @Nullable
        private ByteBuffer[] lastRows;
        private int lastRowsIndex;

        ScanCursor(NativeCursor nativeCursor) {
            this.nativeCursor = nativeCursor;
        }

        public void close() {
            this.nativeCursor.close();
        }

        public boolean hasNext() {
            if (ArrayUtils.nullOrEmpty((Object[])this.lastRows) || this.lastRowsIndex >= this.lastRows.length) {
                if (!this.nativeCursor.hasNextPage()) {
                    return false;
                }
                this.lastRows = this.nativeCursor.nextPage();
                this.lastRowsIndex = 0;
            }
            return true;
        }

        public BinaryRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ByteBuffer buffer = this.lastRows[this.lastRowsIndex++];
            return new BinaryRowImpl(0, buffer);
        }
    }
}

