/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.util.Pair;
import org.gridgain.internal.columnar.ColumnarStorageEngine;
import org.gridgain.internal.columnar.NativeHandle;
import org.gridgain.internal.columnar.NativeInterface;

public class NativeCursor
implements AutoCloseable {
    private final NativeHandle handle;
    private final Cleaner.Cleanable cleanable;
    private final BinaryTupleSchema tupleSchema;

    public NativeCursor(long nativeCursorHandle) {
        this.handle = new NativeHandle("NativeCursor", nativeCursorHandle);
        this.cleanable = ColumnarStorageEngine.cleaner.register(this, new CursorCloser());
        ByteBuffer cursorOutputSchemaData = this.handle.apply(NativeInterface::cursorGetOutputSchema);
        cursorOutputSchemaData.order(NativeInterface.BYTE_ORDER);
        cursorOutputSchemaData.position(cursorOutputSchemaData.position() + 4);
        int numColumns = cursorOutputSchemaData.getInt();
        BinaryTupleSchema.Element[] cols = new BinaryTupleSchema.Element[numColumns];
        for (int i = 0; i < cols.length; ++i) {
            Pair<Column, Integer> columnWithPosition = ColumnarStorageEngine.deserializeColumnSchema(cursorOutputSchemaData);
            Column column = (Column)columnWithPosition.getFirst();
            cols[i] = new BinaryTupleSchema.Element(column.type(), column.nullable());
        }
        this.tupleSchema = BinaryTupleSchema.create((BinaryTupleSchema.Element[])cols);
    }

    public BinaryTupleSchema getTupleSchema() {
        return this.tupleSchema;
    }

    public ByteBuffer[] nextPage() throws NoSuchElementException {
        ByteBuffer page = this.handle.apply(NativeInterface::cursorGatherTuples);
        page.order(NativeInterface.BYTE_ORDER);
        int tuplesCount = page.getInt();
        if (0 == tuplesCount) {
            throw new NoSuchElementException();
        }
        ByteBuffer[] tuples = new ByteBuffer[tuplesCount];
        for (int i = 0; i < tuples.length; ++i) {
            int length = page.getInt();
            byte[] buffer = new byte[length];
            page.get(buffer);
            tuples[i] = ByteBuffer.wrap(buffer).order(NativeInterface.BYTE_ORDER);
        }
        return tuples;
    }

    public boolean hasNextPage() {
        return this.handle.apply(NativeInterface::cursorHasNextPage);
    }

    @Override
    public void close() {
        this.cleanable.clean();
    }

    private void closeInternally() {
        this.handle.dispose(ColumnarStorageEngine::releaseCursor);
    }

    private class CursorCloser
    implements Runnable {
        private CursorCloser() {
        }

        @Override
        public void run() {
            NativeCursor.this.closeInternally();
        }
    }
}

