/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.sql.ColumnType;
import org.gridgain.internal.columnar.ColumnarStorage;

class NativeInterface {
    static final int AGG_COUNT = 0;
    static final int AGG_SUM = 1;
    static final int AGG_AVG = 2;
    static final int AGG_MIN = 3;
    static final int AGG_MAX = 4;
    static final int AGG_ANY = 5;
    static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    static final long AGG_INDEX_MASK = 0xFFFFFFFFL;
    static final int AGG_INDEX_SHIFT = 32;
    static final long AGG_FUNC_MASK = 7L;
    static final int AGG_FUNC_SHIFT = 1;
    static final long AGG_DISTINCT_MASK = 1L;
    static final int AGG_DISTINCT_SHIFT = 0;
    static final int SCHEMA_VER_FOR_REMOVAL = -1;
    static final long SAFE_TIME_EMPTY_ROWID_LSB = 0L;
    static final long SAFE_TIME_EMPTY_ROWID_MSB = 0L;

    NativeInterface() {
    }

    static native void setLogger(IgniteLogger var0, String var1);

    static native void resetLogger();

    static native void setParameter(String var0, String var1);

    static native long createStorage(String var0);

    static native void releaseStorage(long var0);

    static native void setLowWatermark(long var0, long var2);

    static native ByteBuffer getTableSchema(long var0, int var2, int var3, long var4, int var6);

    static native long createTablePartition(String var0, long var1, int var3, int var4, long var5, int var7);

    static native void dropTablePartition(long var0, int var2, int var3);

    static native long getTablePartition(long var0, int var2, int var3);

    static native void releaseTablePartition(long var0);

    static native ByteBuffer readRow(long var0, long var2, long var4, int var6, long var7, int var9);

    static native void processBatch(long var0, long var2, long var4, int var6);

    static native void upsert(long var0, long var2, long var4, long var6, long var8, int var10);

    static native boolean remove(long var0, long var2, long var4, long var6, long var8, int var10);

    static native void doFullCompaction(long var0);

    static native void addColumn(long var0, int var2, String var3, boolean var4);

    static native void dropColumn(long var0, String var2);

    static native void modifyColumnType(long var0, int var2, String var3, boolean var4);

    static native long createCursor(long var0, long var2, long[] var4);

    static native long createAggregateCursor(long var0, long var2, @Nullable long[] var4, long[] var5);

    static native void releaseCursor(long var0);

    static native boolean cursorHasNextPage(long var0);

    static native ByteBuffer cursorGetOutputSchema(long var0);

    static native ByteBuffer cursorGatherTuples(long var0);

    static native ByteBuffer getLastPersistedRow(long var0, long var2, int var4);

    static native void updateSafeTime(long var0, long var2);

    static native void updateRaftConfiguration(long var0, long var2, long var4);

    static native void updateRaftConfiguration(long var0, long var2, long var4, byte[] var6);

    static native ByteBuffer getRaftNodeConfiguration(long var0, long var2, int var4);

    static native long getLastAppliedIndex(long var0);

    static native long getLastAppliedTerm(long var0);

    static native void updateLease(long var0, long var2, long var4, long var6, String var8);

    static native long getLeaseStartTime(long var0);

    static native ByteBuffer getPrimaryReplicaNodeId(long var0, long var2, int var4);

    static native ByteBuffer getPrimaryReplicaNodeName(long var0, long var2, int var4);

    static int nativeTypeToCppTypeId(NativeType type) {
        switch (type.spec()) {
            case INT8: {
                return ColumnType.INT8.id();
            }
            case INT16: {
                return ColumnType.INT16.id();
            }
            case INT32: {
                return ColumnType.INT32.id();
            }
            case INT64: {
                return ColumnType.INT64.id();
            }
            case FLOAT: {
                return ColumnType.FLOAT.id();
            }
            case DOUBLE: {
                return ColumnType.DOUBLE.id();
            }
            case DECIMAL: {
                return ColumnType.DECIMAL.id();
            }
            case UUID: {
                return ColumnType.UUID.id();
            }
            case STRING: {
                return ColumnType.STRING.id();
            }
            case BYTE_ARRAY: {
                return ColumnType.BYTE_ARRAY.id();
            }
            case DATE: {
                return ColumnType.DATE.id();
            }
            case TIME: {
                return ColumnType.TIME.id();
            }
            case DATETIME: {
                return ColumnType.DATETIME.id();
            }
            case TIMESTAMP: {
                return ColumnType.TIMESTAMP.id();
            }
            case BOOLEAN: {
                return ColumnType.BOOLEAN.id();
            }
        }
        throw new IllegalArgumentException("Native type not supported: " + type);
    }

    static NativeType cppTypeToNativeType(int type, int scale, int precision, int maxLength) {
        if (type == ColumnType.INT8.id()) {
            return NativeTypes.INT8;
        }
        if (type == ColumnType.INT16.id()) {
            return NativeTypes.INT16;
        }
        if (type == ColumnType.INT32.id()) {
            return NativeTypes.INT32;
        }
        if (type == ColumnType.INT64.id()) {
            return NativeTypes.INT64;
        }
        if (type == ColumnType.FLOAT.id()) {
            return NativeTypes.FLOAT;
        }
        if (type == ColumnType.DOUBLE.id()) {
            return NativeTypes.DOUBLE;
        }
        if (type == ColumnType.DATE.id()) {
            return NativeTypes.DATE;
        }
        if (type == ColumnType.UUID.id()) {
            return NativeTypes.UUID;
        }
        if (type == ColumnType.STRING.id()) {
            return NativeTypes.STRING;
        }
        if (type == ColumnType.BYTE_ARRAY.id()) {
            return NativeTypes.BYTES;
        }
        if (type == ColumnType.BOOLEAN.id()) {
            return NativeTypes.BOOLEAN;
        }
        if (type == ColumnType.DECIMAL.id()) {
            return NativeTypes.decimalOf((int)precision, (int)scale);
        }
        if (type == ColumnType.TIME.id()) {
            return NativeTypes.time((int)precision);
        }
        if (type == ColumnType.DATETIME.id()) {
            return NativeTypes.datetime((int)precision);
        }
        if (type == ColumnType.TIMESTAMP.id()) {
            return NativeTypes.timestamp((int)precision);
        }
        throw new IllegalArgumentException("Cpp type not supported: " + type);
    }

    static {
        ColumnarStorage.loadLibrary();
    }
}

