/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.secondary.SecondaryStorageEngine;
import org.apache.ignite.internal.storage.secondary.SecondaryStorageTableDescriptor;
import org.apache.ignite.internal.storage.secondary.SecondaryTableStorage;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.Pair;
import org.gridgain.internal.columnar.ColumnarPartitionStorage;
import org.gridgain.internal.columnar.ColumnarStorage;
import org.gridgain.internal.columnar.ColumnarTableStorage;
import org.gridgain.internal.columnar.DirectByteBufferHolder;
import org.gridgain.internal.columnar.NativeHandle;
import org.gridgain.internal.columnar.NativeInterface;
import org.gridgain.internal.columnar.configuration.schema.ColumnarStorageEngineConfiguration;
import org.gridgain.internal.columnar.configuration.schema.ColumnarStorageEngineExtensionConfiguration;
import org.gridgain.internal.columnar.configuration.schema.ColumnarStorageProfileView;
import org.gridgain.internal.license.LicenseFeature;
import org.jetbrains.annotations.Nullable;

public class ColumnarStorageEngine
implements AutoCloseable,
SecondaryStorageEngine {
    public static final String ENGINE_NAME = "columnar";
    static final boolean LIBRARY_LOADED;
    private static final IgniteLogger LOG;
    private final NativeHandle handle;
    private final StorageConfiguration storageConfig;
    private final ColumnarStorageEngineConfiguration engineConfig;
    private static final ThreadLocal<DirectByteBufferHolder> directBufferHolder;
    static final Cleaner cleaner;

    public ColumnarStorageEngine(StorageConfiguration storageConfig, Path storageDir) {
        this.storageConfig = storageConfig;
        this.engineConfig = ((ColumnarStorageEngineExtensionConfiguration)storageConfig.engines()).columnar();
        this.handle = new NativeHandle("ColumnarStorageEngine", NativeInterface.createStorage(storageDir.toString()));
    }

    public String name() {
        return ENGINE_NAME;
    }

    public void start() throws StorageException {
        this.setParameter("ENABLE_LZ4_COMPRESSION", ((Boolean)this.engineConfig.compressingConfiguration().enableLz4Compression().value()).toString());
        this.setParameter("MEMTABLE_MAX_SIZE", ((Long)this.engineConfig.memtableConfiguration().memtableMaxSize().value()).toString());
        this.setParameter("DATA_REGION_SIZE", ((Long)this.engineConfig.memtableConfiguration().dataRegionSize().value()).toString());
        this.setParameter("THREAD_POOL_THREAD_COUNT", ((Integer)this.engineConfig.threadPoolConfiguration().threadPoolThreadCount().value()).toString());
    }

    public void stop() throws StorageException {
        this.close();
    }

    public SecondaryTableStorage createTable(SecondaryStorageTableDescriptor tableDescriptor) throws StorageException {
        return new ColumnarTableStorage(this, tableDescriptor);
    }

    public LicenseFeature licenseFeature() {
        return LicenseFeature.COLUMNAR_STORAGE;
    }

    public void setParameter(String name, String value) {
        NativeInterface.setParameter(name, value);
    }

    public void setLowWatermark(HybridTimestamp timestamp) {
        this.handle.use(ptr -> NativeInterface.setLowWatermark(ptr, timestamp.longValue()));
    }

    @Nullable
    public ColumnarPartitionStorage getTablePartition(int tableId, int partitionId) {
        long partitionHandle = this.handle.apply(ptr -> NativeInterface.getTablePartition(ptr, tableId, partitionId));
        if (partitionHandle == 0L) {
            return null;
        }
        return new ColumnarPartitionStorage(this, partitionHandle, tableId, partitionId);
    }

    @Nullable
    public SchemaDescriptor getTableSchema(int tableId, int partitionId) {
        DirectByteBufferHolder bufferHolder = directBufferHolder.get();
        ByteBuffer result = this.handle.apply(ptr -> bufferHolder.use(buffer -> NativeInterface.getTableSchema(ptr, tableId, partitionId, GridUnsafe.bufferAddress((ByteBuffer)buffer), buffer.limit())));
        long schemaSize = result.getLong();
        if (schemaSize == 0L) {
            return null;
        }
        int version = result.getInt();
        int colsCount = result.getInt();
        ArrayList<Column> columns = new ArrayList<Column>(colsCount);
        ArrayList<String> keyColumns = new ArrayList<String>();
        for (int i = 0; i < colsCount; ++i) {
            Pair<Column, Integer> columnWithPosition = ColumnarStorageEngine.deserializeColumnSchema(result);
            Column column = (Column)columnWithPosition.getFirst();
            int positionInKey = (Integer)columnWithPosition.getSecond();
            columns.add(column);
            if (positionInKey == -1) continue;
            keyColumns.add(column.name());
        }
        return new SchemaDescriptor(version, columns, keyColumns, null);
    }

    public void dropTablePartition(int tableId, int partitionId) {
        this.handle.use(ptr -> NativeInterface.dropTablePartition(ptr, tableId, partitionId));
    }

    public ColumnarPartitionStorage createTablePartition(SecondaryStorageTableDescriptor tableDescriptor, int partitionId) {
        SchemaDescriptor schema = tableDescriptor.getSchemaDescriptor();
        int bufSize = 4;
        bufSize += 4;
        for (Object column : schema.columns()) {
            bufSize += ColumnarStorageEngine.calculateColumnSchemaBytes((Column)column);
        }
        ByteBuffer buf = directBufferHolder.get().get(bufSize);
        buf.putInt(schema.version());
        buf.putInt(schema.length());
        for (Column column : schema.columns()) {
            ColumnarStorageEngine.serializeColumnSchema(buf, column);
        }
        int tableId = tableDescriptor.getId();
        long partitionHandle = this.handle.apply(ptr -> NativeInterface.createTablePartition(tableDescriptor.getName(), ptr, tableId, partitionId, GridUnsafe.bufferAddress((ByteBuffer)buf), buf.position()));
        assert (partitionHandle != 0L) : "NativeInterface.createTablePartition has been called concurrently";
        return new ColumnarPartitionStorage(this, partitionHandle, tableId, partitionId);
    }

    public static int calculateColumnSchemaBytes(Column column) {
        int size = 4;
        size += 4;
        size += 4;
        size += column.name().getBytes(StandardCharsets.UTF_8).length;
        ++size;
        size += 2;
        size += 2;
        return size += 4;
    }

    public static void serializeColumnSchema(ByteBuffer buf, Column column) {
        buf.putInt(NativeInterface.nativeTypeToCppTypeId(column.type()));
        buf.putInt(column.positionInKey());
        buf.putInt(column.name().getBytes(StandardCharsets.UTF_8).length);
        buf.put(column.name().getBytes(StandardCharsets.UTF_8));
        buf.put(column.nullable() ? (byte)1 : 0);
        int scale = 0;
        int precision = 0;
        int length = 0;
        switch (column.type().spec()) {
            case DECIMAL: {
                scale = ((DecimalNativeType)column.type()).scale();
                precision = ((DecimalNativeType)column.type()).scale();
                break;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                precision = ((TemporalNativeType)column.type()).precision();
                break;
            }
            case STRING: 
            case BYTE_ARRAY: {
                length = ((VarlenNativeType)column.type()).length();
                break;
            }
        }
        buf.putShort((short)scale);
        buf.putShort((short)precision);
        buf.putInt(length);
    }

    public static Pair<Column, Integer> deserializeColumnSchema(ByteBuffer buf) {
        int typeId = buf.getInt();
        int positionInKey = buf.getInt();
        int nameLength = buf.getInt();
        byte[] bytes = new byte[nameLength];
        buf.get(bytes);
        String name = new String(bytes, StandardCharsets.UTF_8);
        boolean nullable = buf.get() != 0;
        short scale = buf.getShort();
        short precision = buf.getShort();
        int length = buf.getInt();
        NativeType type = NativeInterface.cppTypeToNativeType(typeId, scale, precision, length);
        return new Pair((Object)new Column(name, type, nullable), (Object)positionInKey);
    }

    private static void releaseStorage(long handle) {
        NativeInterface.releaseStorage(handle);
    }

    static void releaseTablePartition(long handle) {
        NativeInterface.releaseTablePartition(handle);
    }

    static void releaseCursor(long cursorId) {
        NativeInterface.releaseCursor(cursorId);
    }

    @Override
    public void close() {
        this.handle.dispose(ColumnarStorageEngine::releaseStorage);
    }

    public boolean hasConfiguredStorageProfiles() {
        return StorageUtils.hasConfiguredStorageProfiles((StorageConfiguration)this.storageConfig, ColumnarStorageProfileView.class);
    }

    static {
        LOG = Loggers.forClass(ColumnarStorageEngine.class);
        LIBRARY_LOADED = ColumnarStorage.loadLibrary();
        if (LIBRARY_LOADED) {
            if (LOG.isTraceEnabled()) {
                NativeInterface.setLogger(LOG, "TRACE");
            } else if (LOG.isDebugEnabled()) {
                NativeInterface.setLogger(LOG, "DEBUG");
            } else if (LOG.isInfoEnabled()) {
                NativeInterface.setLogger(LOG, "INFO");
            } else if (LOG.isWarnEnabled()) {
                NativeInterface.setLogger(LOG, "WARN");
            } else {
                NativeInterface.setLogger(LOG, "ERROR");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    NativeInterface.resetLogger();
                }
            });
        }
        directBufferHolder = ThreadLocal.withInitial(DirectByteBufferHolder::new);
        cleaner = Cleaner.create();
    }
}

