/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.columnar;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.gridgain.internal.columnar.NativeLibraryLoader;

public class ColumnarStorage {
    private static final long LOADING_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final AtomicReference<LibraryState> LIBRARY_LOADED = new AtomicReference<LibraryState>(LibraryState.INITIAL);

    public static boolean loadLibrary() {
        if (LIBRARY_LOADED.get() == LibraryState.LOADED) {
            return true;
        }
        if (LIBRARY_LOADED.compareAndSet(LibraryState.INITIAL, LibraryState.LOADING)) {
            boolean loaded = NativeLibraryLoader.getInstance().tryLoadLibrary();
            LIBRARY_LOADED.set(loaded ? LibraryState.LOADED : LibraryState.NOT_LOADED);
            return loaded;
        }
        long start = System.currentTimeMillis();
        while (LIBRARY_LOADED.get() == LibraryState.LOADING) {
            if (System.currentTimeMillis() - start > LOADING_TIMEOUT) {
                throw new RuntimeException("Timeout while waiting for native storage library to load");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return LIBRARY_LOADED.get() == LibraryState.LOADED;
    }

    static {
        ColumnarStorage.loadLibrary();
    }

    private static enum LibraryState {
        INITIAL,
        LOADING,
        NOT_LOADED,
        LOADED;

    }
}

