/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.cdc.api.Violation;
import org.gridgain.internal.cdc.api.sink.IcebergTableSink;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.TableSinkValidator;
import org.jetbrains.annotations.Nullable;

public class IcebergTableSinkValidator
implements TableSinkValidator {
    private static final IgniteLogger LOG = Loggers.forClass(IcebergTableSinkValidator.class);

    public List<Violation> validate(SinkDefinition definition) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        Violation violation = IcebergTableSinkValidator.warehouseCheck(definition);
        if (violation != null) {
            violations.add(violation);
            return violations;
        }
        return violations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Violation readFromTableCheck(SinkDefinition definition) {
        Catalog catalog = IcebergTableSink.createCatalog(definition);
        Violation.Builder check = Violation.builder().name("Read from the catalog");
        try {
            catalog.loadTable(TableIdentifier.of((String[])new String[]{"t", "t"}));
            Violation violation = null;
            return violation;
        }
        catch (Exception e) {
            LOG.warn("Got exception during reading from the catalog check for " + definition.name(), (Throwable)e);
            Violation violation = check.errorDetails(e.getMessage() + (String)(e.getCause() != null ? ". " + e.getCause().getMessage() : "")).hint("Ensure that the catalog can read from the underlying storage.").build();
            return violation;
        }
        finally {
            try {
                IcebergTableSink.closeCatalog(catalog);
            }
            catch (IOException e) {
                LOG.warn("Got exception during closing of the catalog for " + definition.name(), (Throwable)e);
            }
        }
    }

    @Nullable
    private static Violation warehouseCheck(SinkDefinition definition) {
        boolean hasWarehouse = definition.parameters().parameters().containsKey("warehouse");
        if (hasWarehouse) {
            return null;
        }
        return Violation.builder().name("`warehouse` parameter should exist").errorDetails("`warehouse` parameter is missing").hint("Add `warehouse` property to sink configuration.").build();
    }

    @Nullable
    private static Violation createCatalogCheck(SinkDefinition definition) {
        Violation.Builder check = Violation.builder().name("`catalog-impl` parameter should be valid");
        try {
            IcebergTableSink.closeCatalog(IcebergTableSink.createCatalog(definition));
            return null;
        }
        catch (Exception e) {
            LOG.warn("Got exception during checking the catalog for " + definition.name(), (Throwable)e);
            return check.errorDetails(e.getMessage()).hint("Ensure that `catalog-impl` is valid. By default it is `%s`", new String[]{"org.apache.iceberg.hadoop.HadoopCatalog"}).build();
        }
    }
}

