/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.sink;

import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.SdkSystemSetting;

public final class IcebergUtils {
    public static final String CLIENT_REGION = "s3.client-region";

    private IcebergUtils() {
    }

    public static Map<String, String> combineProperties(String location, Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties);
        result.computeIfAbsent("warehouse", k -> location);
        result.computeIfAbsent("client.region", k -> (String)properties.get(CLIENT_REGION));
        return result;
    }

    public static Configuration combineConfiguration(Map<String, String> properties) {
        Configuration conf = new Configuration();
        IcebergUtils.trySetAwsProperties(conf, properties, "s3.access-key-id", "s3.secret-access-key", "s3.session-token", CLIENT_REGION, "s3.endpoint");
        IcebergUtils.trySetAwsProperties(conf, properties, "fs.s3a.access.key", "fs.s3a.secret.key", "fs.s3a.session.token", "fs.s3a.endpoint.region", "fs.s3a.endpoint");
        IcebergUtils.trySetAwsProperties(conf, properties, SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), SdkSystemSetting.AWS_SESSION_TOKEN.property(), SdkSystemSetting.AWS_REGION.property(), null);
        return conf;
    }

    private static void trySetAwsProperties(Configuration conf, Map<String, String> properties, @Nullable String keyAccessKey, @Nullable String keySecretKey, @Nullable String keySessionToken, @Nullable String keyRegion, @Nullable String endpoint) {
        Optional.ofNullable(properties.get(keyAccessKey)).ifPresent(v -> {
            conf.set("fs.s3a.access.key", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.accessKeyId"), System.getenv("AWS_ACCESS_KEY_ID"), System.getenv("AWS_ACCESS_KEY")})) {
                System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), v);
            }
        });
        Optional.ofNullable(properties.get(keySecretKey)).ifPresent(v -> {
            conf.set("fs.s3a.secret.key", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.secretKey"), System.getenv("AWS_SECRET_KEY"), System.getenv("AWS_SECRET_ACCESS_KEY")})) {
                System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), v);
            }
        });
        Optional.ofNullable(properties.get(keySessionToken)).ifPresent(v -> {
            conf.set("fs.s3a.session.token", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.sessionToken"), System.getenv("AWS_SESSION_TOKEN")})) {
                System.setProperty(SdkSystemSetting.AWS_SESSION_TOKEN.property(), v);
            }
        });
        Optional.ofNullable(properties.get(keyRegion)).ifPresent(v -> conf.set("fs.s3a.endpoint.region", v));
        Optional.ofNullable(properties.get(endpoint)).ifPresent(v -> conf.set("fs.s3a.endpoint", v));
    }

    static GenericRecord asRecord(Tuple tup, GenericRecord rec, Schema schema) {
        HashMap<String, Object> recordValues = new HashMap<String, Object>(tup.columnCount(), 1.0f);
        for (int i = 0; i < tup.columnCount(); ++i) {
            String columnName = schema.findColumnName(i + 1);
            Object value = IcebergUtils.asIcebergValue(tup.value(tup.columnIndex(columnName)));
            recordValues.put(columnName, value);
        }
        return rec.copy(recordValues);
    }

    static GenericRecord asRecord(Tuple keyTup, Tuple valueTup, GenericRecord rec, Schema schema) {
        Object value;
        String columnName;
        int i;
        HashMap<String, Object> recordValues = new HashMap<String, Object>(keyTup.columnCount() + valueTup.columnCount(), 1.0f);
        for (i = 0; i < keyTup.columnCount(); ++i) {
            columnName = schema.findColumnName(i + 1);
            value = IcebergUtils.asIcebergValue(keyTup.value(keyTup.columnIndex(columnName)));
            recordValues.put(columnName, value);
        }
        for (i = 0; i < valueTup.columnCount(); ++i) {
            columnName = schema.findColumnName(i + 1 + keyTup.columnCount());
            value = IcebergUtils.asIcebergValue(valueTup.value(valueTup.columnIndex(columnName)));
            recordValues.put(columnName, value);
        }
        return rec.copy(recordValues);
    }

    public static Schema asIcebergSchema(List<Column> ggColumns) {
        List icebergColumns = IntStream.range(1, ggColumns.size() + 1).boxed().map(i -> {
            Column column = (Column)ggColumns.get(i - 1);
            boolean isOptional = column.nullable();
            String name = column.name();
            Type type = IcebergUtils.asIcebergType(column.type());
            return Types.NestedField.of((int)i, (boolean)isOptional, (String)name, (Type)type);
        }).collect(Collectors.toList());
        return new Schema(icebergColumns);
    }

    private static Type asIcebergType(NativeType type) {
        ColumnType spec = type.spec();
        String typeString = spec.name();
        if (ColumnType.INT8 == spec || ColumnType.INT16 == spec || ColumnType.INT32 == spec) {
            return Types.IntegerType.get();
        }
        if (ColumnType.INT64 == spec) {
            return Types.LongType.get();
        }
        if (ColumnType.DECIMAL == spec) {
            DecimalNativeType decType = (DecimalNativeType)type;
            return Types.DecimalType.of((int)decType.precision(), (int)decType.scale());
        }
        if (ColumnType.DATETIME == spec) {
            return Types.TimestampType.withoutZone();
        }
        if (ColumnType.BYTE_ARRAY == spec) {
            return Types.BinaryType.get();
        }
        return Types.fromPrimitiveString((String)typeString);
    }

    private static Object asIcebergValue(@Nullable Object o) {
        if (o instanceof byte[]) {
            return ByteBuffer.wrap((byte[])o);
        }
        if (o instanceof Byte) {
            return ((Byte)o).intValue();
        }
        if (o instanceof Short) {
            return ((Short)o).intValue();
        }
        if (o instanceof Date) {
            Date date = (Date)o;
            return date.toLocalDate();
        }
        return o;
    }
}

