/*
 * Decompiled with CFR 0.152.
 */
package com.gridgain.cdc.gg9togg8.meta;

import com.gridgain.cdc.gg9togg8.meta.Gg8FieldMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg8TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9FieldMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9TableMetadata;
import com.typesafe.config.Config;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.table.QualifiedName;

public class MetadataUtils {
    public static Gg9TableMetadata getGg9TableMetadata(QualifiedName tableName, List<Column> columns) {
        ArrayList<Gg9FieldMetadata> keyMeta = new ArrayList<Gg9FieldMetadata>();
        ArrayList<Gg9FieldMetadata> valMeta = new ArrayList<Gg9FieldMetadata>();
        for (Column column : columns) {
            Gg9FieldMetadata meta = new Gg9FieldMetadata(column.name(), column.nullable(), column.type().spec());
            if (column.positionInKey() >= 0) {
                keyMeta.add(meta);
                continue;
            }
            valMeta.add(meta);
        }
        return new Gg9TableMetadata(tableName.schemaName(), tableName.objectName(), keyMeta, valMeta);
    }

    public static Gg8TableMetadata getGg8TableMetadata(Config config) {
        Set keyFields = config.getStringList("options.keyFields").stream().map(String::toUpperCase).collect(Collectors.toSet());
        ArrayList<Gg8FieldMetadata> keyFieldsMeta = new ArrayList<Gg8FieldMetadata>();
        ArrayList<Gg8FieldMetadata> valueFieldsMeta = new ArrayList<Gg8FieldMetadata>();
        for (Config field : config.getConfigList("options.fields")) {
            String fieldName = field.getString("name").toUpperCase();
            String fieldType = field.getString("type");
            Gg8FieldMetadata meta = new Gg8FieldMetadata(fieldName, false, fieldType);
            if (keyFields.contains(fieldName)) {
                keyFieldsMeta.add(meta);
                continue;
            }
            valueFieldsMeta.add(meta);
        }
        String cacheName = config.getString("options.cacheName");
        String keyTypeName = config.getString("options.keyTypeName");
        String valueTypeName = config.getString("options.valueTypeName");
        return new Gg8TableMetadata(cacheName, keyTypeName, valueTypeName, keyFieldsMeta, valueFieldsMeta);
    }

    private static List<Gg8FieldMetadata> getGg8FieldMetadata(IgniteClient cl, QualifiedName tableName) {
        String sql = "SELECT column_name, type, nullable FROM sys.table_columns tc WHERE tc.schema_name = ? and tc.table_name = ? and tc.column_name not in ('_KEY', '_VAL')";
        List qryRes = cl.query(new SqlFieldsQuery(sql).setArgs(new Object[]{tableName.schemaName(), tableName.objectName()})).getAll();
        ArrayList<Gg8FieldMetadata> res = new ArrayList<Gg8FieldMetadata>();
        for (List row : qryRes) {
            String fieldName = (String)row.get(0);
            String type = (String)row.get(1);
            boolean nullable = (Boolean)row.get(2);
            res.add(new Gg8FieldMetadata(fieldName, nullable, type));
        }
        return res;
    }

    private static Set<String> getGg8PrimaryKeys(Connection conn, QualifiedName tableName) {
        try {
            ResultSet pkRes = conn.getMetaData().getPrimaryKeys(null, tableName.schemaName(), tableName.objectName());
            HashSet<String> pks = new HashSet<String>();
            while (pkRes.next()) {
                pks.add(pkRes.getString("COLUMN_NAME").toUpperCase());
            }
            return pks;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

