/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class HandshakeTimeoutObject
implements Runnable {
    private final Object connectionObj;
    private final AtomicBoolean done = new AtomicBoolean();

    public HandshakeTimeoutObject(Object connectionObj) {
        assert (connectionObj != null);
        assert (connectionObj instanceof GridCommunicationClient || connectionObj instanceof SelectableChannel);
        this.connectionObj = connectionObj;
    }

    public boolean cancel() {
        return this.done.compareAndSet(false, true);
    }

    public String toString() {
        return S.toString(HandshakeTimeoutObject.class, this);
    }

    @Override
    public void run() {
        if (this.done.compareAndSet(false, true)) {
            if (this.connectionObj instanceof GridCommunicationClient) {
                ((GridCommunicationClient)this.connectionObj).forceClose();
            } else {
                U.closeQuiet((AbstractInterruptibleChannel)this.connectionObj);
            }
        }
    }
}

