/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.eventstorage.HighPriorityListener;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionClientPool;

public class CommunicationDiscoveryEventListener
implements GridLocalEventListener,
HighPriorityListener {
    private final ConnectionClientPool clientPool;
    private final Supplier<TcpCommunicationMetricsListener> metricLsnrSupplier;

    public CommunicationDiscoveryEventListener(ConnectionClientPool clientPool, Supplier<TcpCommunicationMetricsListener> metricLsnrSupplier) {
        this.clientPool = clientPool;
        this.metricLsnrSupplier = metricLsnrSupplier;
    }

    @Override
    public void onEvent(Event evt) {
        assert (evt instanceof DiscoveryEvent) : evt;
        assert (evt.type() == 11 || evt.type() == 12);
        ClusterNode node = ((DiscoveryEvent)evt).eventNode();
        this.onNodeLeft(node.consistentId(), node.id());
    }

    @Override
    public int order() {
        return 0;
    }

    private void onNodeLeft(Object consistentId, UUID nodeId) {
        assert (nodeId != null);
        this.metricLsnrSupplier.get().onNodeLeft(consistentId);
        this.clientPool.onNodeLeft(nodeId);
    }
}

