/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.util.concurrent.Executor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerPool;
import org.apache.ignite.lang.IgniteInClosure;

public class GridNioAsyncNotifyFilter
extends GridNioFilterAdapter {
    private IgniteLogger log;
    private GridWorkerPool workerPool;
    private String igniteInstanceName;

    public GridNioAsyncNotifyFilter(String igniteInstanceName, Executor exec, IgniteLogger log) {
        super(GridNioAsyncNotifyFilter.class.getSimpleName());
        this.igniteInstanceName = igniteInstanceName;
        this.log = log;
        this.workerPool = new GridWorkerPool(exec, log);
    }

    @Override
    public void stop() {
        this.workerPool.join(false);
    }

    @Override
    public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        this.onSessionOpened(ses, null);
    }

    @Override
    public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        this.onSessionClosed(ses, null);
    }

    @Override
    public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        this.onMessageReceived(ses, msg, null);
    }

    protected void onSessionOpened(final GridNioSession ses, final Runnable opC) throws IgniteCheckedException {
        this.workerPool.execute(new GridWorker(this.igniteInstanceName, "session-opened-notify", this.log){

            @Override
            protected void body() {
                try {
                    GridNioAsyncNotifyFilter.this.proceedSessionOpened(ses);
                }
                catch (IgniteCheckedException e) {
                    GridNioAsyncNotifyFilter.this.handleException(ses, e);
                }
                finally {
                    GridNioAsyncNotifyFilter.this.onFinish(ses, opC);
                }
            }
        });
    }

    protected void onSessionClosed(final GridNioSession ses, final Runnable opC) throws IgniteCheckedException {
        this.workerPool.execute(new GridWorker(this.igniteInstanceName, "session-closed-notify", this.log){

            @Override
            protected void body() {
                try {
                    GridNioAsyncNotifyFilter.this.proceedSessionClosed(ses);
                }
                catch (IgniteCheckedException e) {
                    GridNioAsyncNotifyFilter.this.handleException(ses, e);
                }
                finally {
                    GridNioAsyncNotifyFilter.this.onFinish(ses, opC);
                }
            }
        });
    }

    protected void onMessageReceived(final GridNioSession ses, final Object msg, final Runnable opC) throws IgniteCheckedException {
        this.workerPool.execute(new GridWorker(this.igniteInstanceName, "message-received-notify", this.log){

            @Override
            protected void body() {
                try {
                    GridNioAsyncNotifyFilter.this.proceedMessageReceived(ses, msg);
                }
                catch (IgniteCheckedException e) {
                    GridNioAsyncNotifyFilter.this.handleException(ses, e);
                }
                finally {
                    GridNioAsyncNotifyFilter.this.onFinish(ses, opC);
                }
            }
        });
    }

    @Override
    public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) throws IgniteCheckedException {
        this.proceedExceptionCaught(ses, ex);
    }

    @Override
    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        return this.proceedSessionWrite(ses, msg, fut, ackC);
    }

    @Override
    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
        return this.proceedSessionClose(ses);
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionIdleTimeout(ses);
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionWriteTimeout(ses);
    }

    private void onFinish(GridNioSession ses, Runnable opC) {
        try {
            if (opC != null) {
                opC.run();
            }
        }
        catch (Throwable e) {
            this.handleException(ses, U.cast(e));
        }
    }

    private void handleException(GridNioSession ses, IgniteCheckedException ex) {
        try {
            this.proceedExceptionCaught(ses, ex);
        }
        catch (IgniteCheckedException e) {
            U.warn(this.log, "Failed to forward exception to the underlying filter (will ignore) [ses=" + ses + ", originalEx=" + ex + ", ex=" + e + ']');
        }
    }
}

