/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.marshaller;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.marshaller.ClientRequestFuture;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.marshaller.MappingAcceptedMessage;
import org.apache.ignite.internal.processors.marshaller.MappingExchangeResult;
import org.apache.ignite.internal.processors.marshaller.MappingProposedMessage;
import org.apache.ignite.internal.processors.marshaller.MappingUpdatedListener;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingItem;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingTransport;
import org.apache.ignite.internal.processors.marshaller.MissingMappingRequestMessage;
import org.apache.ignite.internal.processors.marshaller.MissingMappingResponseMessage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class GridMarshallerMappingProcessor
extends GridProcessorAdapter {
    private final MarshallerContextImpl marshallerCtx;
    private final GridClosureProcessor closProc;
    private final List<MappingUpdatedListener> mappingUpdatedLsnrs = new CopyOnWriteArrayList<MappingUpdatedListener>();
    private final ConcurrentMap<MarshallerMappingItem, GridFutureAdapter<MappingExchangeResult>> mappingExchangeSyncMap = new ConcurrentHashMap<MarshallerMappingItem, GridFutureAdapter<MappingExchangeResult>>();
    private final ConcurrentMap<MarshallerMappingItem, ClientRequestFuture> clientReqSyncMap = new ConcurrentHashMap<MarshallerMappingItem, ClientRequestFuture>();

    public GridMarshallerMappingProcessor(GridKernalContext ctx) {
        super(ctx);
        this.marshallerCtx = ctx.marshallerContext();
        this.closProc = ctx.closure();
    }

    @Override
    public void start() throws IgniteCheckedException {
        GridDiscoveryManager discoMgr = this.ctx.discovery();
        GridIoManager ioMgr = this.ctx.io();
        MarshallerMappingTransport transport = new MarshallerMappingTransport(this.ctx, this.mappingExchangeSyncMap, this.clientReqSyncMap);
        this.marshallerCtx.onMarshallerProcessorStarted(this.ctx, transport);
        discoMgr.setCustomEventListener(MappingProposedMessage.class, new MappingProposedListener());
        discoMgr.setCustomEventListener(MappingAcceptedMessage.class, new MappingAcceptedListener());
        if (this.ctx.clientNode()) {
            ioMgr.addMessageListener(GridTopic.TOPIC_MAPPING_MARSH, (GridMessageListener)new MissingMappingResponseListener());
        } else {
            ioMgr.addMessageListener(GridTopic.TOPIC_MAPPING_MARSH, (GridMessageListener)new MissingMappingRequestListener(ioMgr));
        }
        if (this.ctx.clientNode()) {
            this.ctx.event().addLocalEventListener(new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    DiscoveryEvent evt0 = (DiscoveryEvent)evt;
                    if (!GridMarshallerMappingProcessor.this.ctx.isStopping()) {
                        for (ClientRequestFuture fut : GridMarshallerMappingProcessor.this.clientReqSyncMap.values()) {
                            fut.onNodeLeft(evt0.eventNode().id());
                        }
                    }
                }
            }, 11, 12);
        }
    }

    public void addMappingUpdatedListener(MappingUpdatedListener lsnr) {
        this.mappingUpdatedLsnrs.add(lsnr);
    }

    public Iterator<Map.Entry<Byte, Map<Integer, String>>> currentMappings() {
        return this.marshallerCtx.currentMappings();
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.MARSHALLER_PROC.ordinal(), this.marshallerCtx.getCachedMappings());
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.MARSHALLER_PROC.ordinal())) {
            dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.MARSHALLER_PROC.ordinal(), this.marshallerCtx.getCachedMappings());
        }
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        List mappings = (List)((Object)data.joiningNodeData());
        this.processIncomingMappings(mappings);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        List mappings = (List)((Object)data.commonData());
        this.processIncomingMappings(mappings);
    }

    private void processIncomingMappings(List<Map<Integer, MappedName>> mappings) {
        if (mappings != null) {
            for (int i = 0; i < mappings.size(); ++i) {
                Map<Integer, MappedName> map = mappings.get(i);
                if (map == null) continue;
                try {
                    this.marshallerCtx.onMappingDataReceived((byte)i, map);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to process marshaller mapping data", e);
                }
            }
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.cancelFutures(MappingExchangeResult.createFailureResult(new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to propose or request mapping, client node disconnected.")));
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.marshallerCtx.onMarshallerProcessorStop();
        this.cancelFutures(MappingExchangeResult.createExchangeDisabledResult());
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.MARSHALLER_PROC;
    }

    private void cancelFutures(MappingExchangeResult res) {
        for (GridFutureAdapter fut : this.mappingExchangeSyncMap.values()) {
            fut.onDone(res);
        }
        for (GridFutureAdapter fut : this.clientReqSyncMap.values()) {
            fut.onDone(res);
        }
    }

    private final class MappingAcceptedListener
    implements CustomEventListener<MappingAcceptedMessage> {
        private MappingAcceptedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MappingAcceptedMessage msg) {
            GridFutureAdapter fut;
            final MarshallerMappingItem item = msg.getMappingItem();
            GridMarshallerMappingProcessor.this.marshallerCtx.onMappingAccepted(item);
            GridMarshallerMappingProcessor.this.closProc.runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    for (MappingUpdatedListener lsnr : GridMarshallerMappingProcessor.this.mappingUpdatedLsnrs) {
                        lsnr.mappingUpdated(item.platformId(), item.typeId(), item.className());
                    }
                }
            });
            ClientRequestFuture rqFut = (ClientRequestFuture)GridMarshallerMappingProcessor.this.clientReqSyncMap.get(new MarshallerMappingItem(item.platformId(), item.typeId(), null));
            if (rqFut != null) {
                rqFut.onDone(MappingExchangeResult.createSuccessfulResult(item.className()));
            }
            if ((fut = (GridFutureAdapter)GridMarshallerMappingProcessor.this.mappingExchangeSyncMap.get(item)) != null) {
                fut.onDone(MappingExchangeResult.createSuccessfulResult(item.className()));
            }
        }
    }

    private final class MappingProposedListener
    implements CustomEventListener<MappingProposedMessage> {
        private MappingProposedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MappingProposedMessage msg) {
            if (!GridMarshallerMappingProcessor.this.ctx.isStopping()) {
                if (msg.duplicated()) {
                    return;
                }
                if (!msg.inConflict()) {
                    MarshallerMappingItem item = msg.mappingItem();
                    MappedName existingName = GridMarshallerMappingProcessor.this.marshallerCtx.onMappingProposed(item);
                    if (existingName != null) {
                        String existingClsName = existingName.className();
                        if (existingClsName.equals(item.className()) && !existingName.accepted()) {
                            msg.markDuplicated();
                        } else if (!existingClsName.equals(item.className())) {
                            msg.conflictingWithClass(existingClsName);
                        }
                    }
                } else {
                    UUID origNodeId = msg.origNodeId();
                    if (origNodeId.equals(GridMarshallerMappingProcessor.this.ctx.localNodeId())) {
                        GridFutureAdapter fut = (GridFutureAdapter)GridMarshallerMappingProcessor.this.mappingExchangeSyncMap.get(msg.mappingItem());
                        assert (fut != null) : msg;
                        fut.onDone(MappingExchangeResult.createFailureResult(this.duplicateMappingException(msg.mappingItem(), msg.conflictingClassName())));
                    }
                }
            }
        }

        private IgniteCheckedException duplicateMappingException(MarshallerMappingItem mappingItem, String conflictingClsName) {
            return new IgniteCheckedException("Duplicate ID [platformId=" + mappingItem.platformId() + ", typeId=" + mappingItem.typeId() + ", oldCls=" + conflictingClsName + ", newCls=" + mappingItem.className() + "]");
        }
    }

    private final class MissingMappingResponseListener
    implements GridMessageListener {
        private MissingMappingResponseListener() {
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg instanceof MissingMappingResponseMessage) : msg;
            MissingMappingResponseMessage msg0 = (MissingMappingResponseMessage)msg;
            byte platformId = msg0.platformId();
            int typeId = msg0.typeId();
            String resolvedClsName = msg0.className();
            MarshallerMappingItem item = new MarshallerMappingItem(platformId, typeId, null);
            GridFutureAdapter fut = (GridFutureAdapter)GridMarshallerMappingProcessor.this.clientReqSyncMap.get(item);
            if (fut != null) {
                if (resolvedClsName != null) {
                    GridMarshallerMappingProcessor.this.marshallerCtx.onMappingAccepted(new MarshallerMappingItem(platformId, typeId, resolvedClsName));
                    fut.onDone(MappingExchangeResult.createSuccessfulResult(resolvedClsName));
                } else {
                    fut.onDone(MappingExchangeResult.createFailureResult(new IgniteCheckedException("Failed to resolve mapping [platformId: " + platformId + ", typeId: " + typeId + "]")));
                }
            }
        }
    }

    private final class MissingMappingRequestListener
    implements GridMessageListener {
        private final GridIoManager ioMgr;

        MissingMappingRequestListener(GridIoManager ioMgr) {
            this.ioMgr = ioMgr;
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg instanceof MissingMappingRequestMessage) : msg;
            MissingMappingRequestMessage msg0 = (MissingMappingRequestMessage)msg;
            byte platformId = msg0.platformId();
            int typeId = msg0.typeId();
            String resolvedClsName = GridMarshallerMappingProcessor.this.marshallerCtx.resolveMissedMapping(platformId, typeId);
            try {
                this.ioMgr.sendToGridTopic(nodeId, GridTopic.TOPIC_MAPPING_MARSH, (Message)new MissingMappingResponseMessage(platformId, typeId, resolvedClsName), (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                if (GridMarshallerMappingProcessor.this.log.isDebugEnabled()) {
                    GridMarshallerMappingProcessor.this.log.debug("Failed to send missing mapping response, node failed: " + nodeId);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(GridMarshallerMappingProcessor.this.log, "Failed to send missing mapping response.", e);
            }
        }
    }
}

