/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.configuration.distributed;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedIntegerProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public class DistributedThinClientConfiguration {
    public static final int DFLT_MAX_CONNECTIONS_PER_NODE = 0;
    private static final String PROPERTY_UPDATE_MESSAGE = "ThinClientProperty parameter '%s' was changed from '%s' to '%s'";
    private final DistributedChangeableProperty<Boolean> showStackTrace = DistributedBooleanProperty.detachedBooleanProperty("thinClientProperty.showStackTrace");
    private final DistributedChangeableProperty<Integer> maxConnectionsPerNode = DistributedIntegerProperty.detachedIntegerProperty("thinClientProperty.maxConnectionsPerNode");
    private final IgniteLogger log;

    public DistributedThinClientConfiguration(GridKernalContext ctx) {
        this.log = ctx.log(DistributedThinClientConfiguration.class);
        GridInternalSubscriptionProcessor isp = ctx.internalSubscriptionProcessor();
        isp.registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedThinClientConfiguration.this.showStackTrace.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedThinClientConfiguration.PROPERTY_UPDATE_MESSAGE, DistributedThinClientConfiguration.this.log));
                DistributedThinClientConfiguration.this.maxConnectionsPerNode.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedThinClientConfiguration.PROPERTY_UPDATE_MESSAGE, DistributedThinClientConfiguration.this.log));
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedThinClientConfiguration.this.showStackTrace});
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedThinClientConfiguration.this.maxConnectionsPerNode});
            }
        });
    }

    public GridFutureAdapter<?> updateThinClientSendServerStackTraceAsync(boolean showStack) throws IgniteCheckedException {
        return this.showStackTrace.propagateAsync(showStack);
    }

    @Nullable
    public Boolean sendServerExceptionStackTraceToClient() {
        return (Boolean)this.showStackTrace.get();
    }

    public GridFutureAdapter<?> updateMaxConnectionsPerNodeAsync(int limit) throws IgniteCheckedException {
        return this.maxConnectionsPerNode.propagateAsync(limit);
    }

    public void updateMaxConnectionsPerNodeLocal(int limit) {
        this.maxConnectionsPerNode.localUpdate(Integer.valueOf(limit));
    }

    public int maxConnectionsPerNode() {
        Integer value = this.maxConnectionsPerNode.getOrDefault(0);
        assert (value != null);
        return value;
    }
}

