/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PartitionReconciliationKeyMeta
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private byte[] binaryView;
    private String strView;

    public PartitionReconciliationKeyMeta() {
    }

    public PartitionReconciliationKeyMeta(byte[] binaryView, String strView) {
        this.binaryView = binaryView;
        this.strView = strView;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.binaryView);
        U.writeString(out, this.strView);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.binaryView = U.readByteArray(in);
        this.strView = U.readString(in);
    }

    public String stringView(boolean verbose) {
        if (verbose) {
            return this.strView + (this.binaryView != null && this.binaryView.length > 0 ? " hex=[" + U.byteArray2HexString(this.binaryView) + ']' : "");
        }
        return "*****";
    }

    public byte[] binaryView() {
        return this.binaryView;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReconciliationKeyMeta meta = (PartitionReconciliationKeyMeta)o;
        if (!Arrays.equals(this.binaryView, meta.binaryView)) {
            return false;
        }
        return Objects.equals(this.strView, meta.strView);
    }
}

