/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.filehandle;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileWriteHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FsyncFileWriteHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;

public class FsyncFileHandleManagerImpl
implements FileHandleManager {
    protected final GridCacheSharedContext cctx;
    protected final IgniteLogger log;
    private final WALMode mode;
    private final DataStorageMetricsImpl metrics;
    protected final RecordSerializer serializer;
    private final Supplier<FileWriteHandle> currentHandleSupplier;
    private final long maxWalSegmentSize;
    private final long fsyncDelay;
    private final int tlbSize;

    public FsyncFileHandleManagerImpl(GridCacheSharedContext cctx, DataStorageMetricsImpl metrics, RecordSerializer serializer, Supplier<FileWriteHandle> handle, WALMode mode, long maxWalSegmentSize, long fsyncDelay, int tlbSize) {
        this.cctx = cctx;
        this.log = cctx.logger(FsyncFileHandleManagerImpl.class);
        this.mode = mode;
        this.metrics = metrics;
        this.serializer = serializer;
        this.currentHandleSupplier = handle;
        this.maxWalSegmentSize = maxWalSegmentSize;
        this.fsyncDelay = fsyncDelay;
        this.tlbSize = tlbSize;
    }

    @Override
    public FileWriteHandle initHandle(SegmentIO fileIO, long position, RecordSerializer serializer) throws IOException {
        return new FsyncFileWriteHandle(this.cctx, fileIO, this.metrics, serializer, position, this.mode, this.maxWalSegmentSize, this.tlbSize, this.fsyncDelay);
    }

    @Override
    public FileWriteHandle nextHandle(SegmentIO fileIO, RecordSerializer serializer) throws IOException {
        return new FsyncFileWriteHandle(this.cctx, fileIO, this.metrics, serializer, 0L, this.mode, this.maxWalSegmentSize, this.tlbSize, this.fsyncDelay);
    }

    private FsyncFileWriteHandle currentHandle() {
        return (FsyncFileWriteHandle)this.currentHandleSupplier.get();
    }

    @Override
    public void onDeactivate() throws IgniteCheckedException {
        FsyncFileWriteHandle currHnd = this.currentHandle();
        if (this.mode == WALMode.BACKGROUND && currHnd != null) {
            currHnd.flushAllOnStop();
        }
        if (currHnd != null) {
            currHnd.close(false);
        }
    }

    @Override
    public void resumeLogging() {
    }

    @Override
    public WALPointer flush(WALPointer ptr, boolean explicitFsync) throws IgniteCheckedException, StorageException {
        FileWALPointer filePtr;
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return null;
        }
        FsyncFileWriteHandle cur = this.currentHandle();
        if (cur == null) {
            return null;
        }
        if (ptr == null) {
            WALRecord rec = cur.head.get();
            if (rec instanceof FsyncFileWriteHandle.FakeRecord) {
                return null;
            }
            filePtr = (FileWALPointer)rec.position();
        } else {
            filePtr = (FileWALPointer)ptr;
        }
        if (!cur.needFsync(filePtr)) {
            return filePtr;
        }
        cur.fsync(filePtr, false);
        return filePtr;
    }
}

