/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.util.typedef.internal.CU;

public enum CacheType {
    USER(true, 2),
    INTERNAL(false, 2),
    DATA_STRUCTURES(false, 2),
    UTILITY(false, 5);

    private final boolean userCache;
    private final byte ioPlc;

    private CacheType(boolean userCache, byte ioPlc) {
        this.userCache = userCache;
        this.ioPlc = ioPlc;
    }

    public static CacheType cacheType(String cacheName) {
        if (CU.isUtilityCache(cacheName)) {
            return UTILITY;
        }
        if (DataStructuresProcessor.isDataStructureCache(cacheName)) {
            return DATA_STRUCTURES;
        }
        return USER;
    }

    public byte ioPolicy() {
        return this.ioPlc;
    }

    public boolean userCache() {
        return this.userCache;
    }
}

