/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.ThinProtocolFeature;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryThreadLocalContext;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.HandshakeResult;
import org.apache.ignite.internal.jdbc.thin.JdbcThinSSLUtil;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinUtils;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.ipc.loopback.IpcClientTcpEndpoint;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public class JdbcThinTcpIo {
    private static final ClientListenerProtocolVersion VER_0_0_0 = ClientListenerProtocolVersion.VER_UNKNOWN;
    private static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    private static final ClientListenerProtocolVersion VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
    private static final ClientListenerProtocolVersion VER_2_7_0 = ClientListenerProtocolVersion.create(2, 7, 0);
    private static final ClientListenerProtocolVersion VER_2_8_0 = ClientListenerProtocolVersion.create(2, 8, 0);
    private static final ClientListenerProtocolVersion VER_2_8_1 = ClientListenerProtocolVersion.create(2, 8, 1);
    private static final ClientListenerProtocolVersion VER_2_8_2 = ClientListenerProtocolVersion.create(2, 8, 2);
    private static final ClientListenerProtocolVersion VER_2_8_3;
    private static final ClientListenerProtocolVersion CURRENT_VER;
    private static final int HANDSHAKE_MSG_SIZE = 13;
    private static final int DYNAMIC_SIZE_MSG_CAP = 256;
    private static final int MAX_BATCH_QRY_CNT = 32;
    private static final int QUERY_FETCH_MSG_SIZE = 13;
    private static final int QUERY_META_MSG_SIZE = 9;
    private static final int QUERY_CLOSE_MSG_SIZE = 9;
    private static final AtomicLong IDX_GEN;
    private final ConnectionProperties connProps;
    private final InetSocketAddress sockAddr;
    private final IpcClientTcpEndpoint endpoint;
    private final BufferedOutputStream out;
    private final BufferedInputStream in;
    private volatile boolean connected;
    private final IgniteProductVersion igniteVer;
    private final UUID nodeId;
    private final Object connMux = new Object();
    private final ClientListenerProtocolVersion srvProtoVer;
    private JdbcProtocolContext protoCtx;
    private final BinaryContext ctx;

    public JdbcThinTcpIo(ConnectionProperties connProps, InetSocketAddress sockAddr, BinaryContext ctx, int timeout) throws SQLException, IOException {
        this.connProps = connProps;
        this.sockAddr = sockAddr;
        this.ctx = ctx;
        Socket sock = null;
        try {
            if ("require".equalsIgnoreCase(connProps.getSslMode())) {
                sock = JdbcThinSSLUtil.createSSLSocket(sockAddr, connProps);
            } else if ("disable".equalsIgnoreCase(connProps.getSslMode())) {
                sock = new Socket();
                try {
                    sock.connect(sockAddr, timeout);
                }
                catch (IOException e) {
                    throw new SQLException("Failed to connect to server [host=" + sockAddr.getAddress() + ", port=" + sockAddr.getPort() + ']', "08001", e);
                }
            } else {
                throw new SQLException("Unknown sslMode. [sslMode=" + connProps.getSslMode() + ']', "08001");
            }
            if (connProps.getSocketSendBuffer() != 0) {
                sock.setSendBufferSize(connProps.getSocketSendBuffer());
            }
            if (connProps.getSocketReceiveBuffer() != 0) {
                sock.setReceiveBufferSize(connProps.getSocketReceiveBuffer());
            }
            sock.setTcpNoDelay(connProps.isTcpNoDelay());
            BufferedOutputStream out = null;
            BufferedInputStream in = null;
            try {
                this.endpoint = new IpcClientTcpEndpoint(sock);
                out = new BufferedOutputStream(this.endpoint.outputStream());
                in = new BufferedInputStream(this.endpoint.inputStream());
                this.connected = true;
                this.in = in;
                this.out = out;
            }
            catch (IgniteCheckedException e) {
                U.closeQuiet(in);
                U.closeQuiet(out);
                throw new SQLException("Failed to connect to server [url=" + connProps.getUrl() + " address=" + sockAddr + ']', "08001", e);
            }
        }
        catch (Exception e) {
            if (sock != null && !sock.isClosed()) {
                U.closeQuiet(sock);
            }
            throw e;
        }
        HandshakeResult handshakeRes = this.handshake(CURRENT_VER);
        this.igniteVer = handshakeRes.igniteVersion();
        this.nodeId = handshakeRes.nodeId();
        this.srvProtoVer = handshakeRes.serverProtocolVersion();
        this.protoCtx = new JdbcProtocolContext(this.srvProtoVer, handshakeRes.features(), handshakeRes.serverTimezone(), true, connProps.isKeepBinary());
    }

    private HandshakeResult handshake(ClientListenerProtocolVersion ver) throws IOException, SQLException {
        BinaryContext ctx = new BinaryContext(BinaryCachingMetadataHandler.create(), new IgniteConfiguration(), null);
        BinaryMarshaller marsh = new BinaryMarshaller();
        marsh.setContext(new MarshallerContextImpl(null, null));
        ctx.configure(marsh, new BinaryConfiguration());
        BinaryWriterExImpl writer = new BinaryWriterExImpl(ctx, new BinaryHeapOutputStream(13), null, null);
        writer.writeByte((byte)1);
        writer.writeShort(ver.major());
        writer.writeShort(ver.minor());
        writer.writeShort(ver.maintenance());
        writer.writeByte((byte)1);
        writer.writeBoolean(this.connProps.isDistributedJoins());
        writer.writeBoolean(this.connProps.isEnforceJoinOrder());
        writer.writeBoolean(this.connProps.isCollocated());
        writer.writeBoolean(this.connProps.isReplicatedOnly());
        writer.writeBoolean(this.connProps.isAutoCloseServerCursor());
        writer.writeBoolean(this.connProps.isLazy());
        writer.writeBoolean(this.connProps.isSkipReducerOnUpdate());
        if (ver.compareTo(VER_2_7_0) >= 0) {
            writer.writeString(this.connProps.nestedTxMode());
        }
        if (ver.compareTo(VER_2_8_0) > 0 || ver.compareTo(VER_2_8_0) == 0 && !this.connProps.isLimitedV2_8_0Enabled()) {
            writer.writeByte(JdbcThinUtils.nullableBooleanToByte(this.connProps.isDataPageScanEnabled()));
            JdbcUtils.writeNullableInteger(writer, this.connProps.getUpdateBatchSize());
        }
        if (ver.compareTo(VER_2_8_1) >= 0) {
            JdbcUtils.writeNullableLong(writer, this.connProps.getQueryMaxMemory());
        }
        if (ver.compareTo(VER_2_8_2) >= 0) {
            writer.writeByteArray(ThinProtocolFeature.featuresAsBytes(this.enabledFeatures()));
        }
        if (ver.compareTo(VER_2_8_3) >= 0) {
            String userAttrs = this.connProps.getUserAttributesFactory();
            if (F.isEmpty(userAttrs)) {
                writer.writeMap(null);
            } else {
                try {
                    Class<?> cls = JdbcThinSSLUtil.class.getClassLoader().loadClass(userAttrs);
                    Map attrs = (Map)((Factory)cls.newInstance()).create();
                    writer.writeMap(attrs);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new SQLException("Could not found user attributes factory class: " + userAttrs, "08001", e);
                }
            }
        }
        if (!F.isEmpty(this.connProps.getUsername())) {
            assert (ver.compareTo(VER_2_5_0) >= 0) : "Authentication is supported since 2.5";
            writer.writeString(this.connProps.getUsername());
            writer.writeString(this.connProps.getPassword());
        }
        this.send(writer.array());
        BinaryReaderExImpl reader = new BinaryReaderExImpl(ctx, new BinaryHeapInputStream(this.read()), null, null, false);
        boolean accepted = reader.readBoolean();
        if (accepted) {
            HandshakeResult handshakeRes = new HandshakeResult();
            if (reader.available() > 0) {
                byte maj = reader.readByte();
                byte min = reader.readByte();
                byte maintenance = reader.readByte();
                String stage = reader.readString();
                long ts = reader.readLong();
                byte[] hash = reader.readByteArray();
                if (ver.compareTo(VER_2_8_0) > 0 || ver.compareTo(VER_2_8_0) == 0 && !this.connProps.isLimitedV2_8_0Enabled()) {
                    handshakeRes.nodeId(reader.readUuid());
                }
                handshakeRes.igniteVersion(new IgniteProductVersion(maj, min, maintenance, stage, ts, hash));
                if (ver.compareTo(VER_2_8_2) >= 0) {
                    byte[] srvFeatures = reader.readByteArray();
                    EnumSet<JdbcThinFeature> features = JdbcThinFeature.enumSet(srvFeatures);
                    handshakeRes.features(features);
                }
            } else {
                handshakeRes.igniteVersion(new IgniteProductVersion(2, 0, 0, "Unknown", 0L, null));
            }
            handshakeRes.serverProtocolVersion(ver);
            if (handshakeRes.features().contains(JdbcThinFeature.TIME_ZONE)) {
                String srvTzId = reader.readString();
                handshakeRes.serverTimezone(TimeZone.getTimeZone(srvTzId));
            }
            return handshakeRes;
        }
        short maj = reader.readShort();
        short min = reader.readShort();
        short maintenance = reader.readShort();
        String err = reader.readString();
        int status = 1;
        try {
            status = reader.readInt();
        }
        catch (Exception ts) {
            // empty catch block
        }
        ClientListenerProtocolVersion srvProtoVer0 = ClientListenerProtocolVersion.create(maj, min, maintenance);
        if (status == 2000 && srvProtoVer0.compareTo(VER_2_5_0) < 0 && !F.isEmpty(this.connProps.getUsername())) {
            throw new SQLException("Authentication doesn't support by remote server[driverProtocolVer=" + CURRENT_VER + ", remoteNodeProtocolVer=" + srvProtoVer0 + ", err=" + err + ", url=" + this.connProps.getUrl() + " address=" + this.sockAddr + ']', "08004");
        }
        if (status == 1012) {
            throw new SQLException(err);
        }
        if (VER_2_1_0.equals(srvProtoVer0)) {
            return this.handshake_2_1_0();
        }
        if (CURRENT_VER.compareTo(srvProtoVer0) > 0 && VER_0_0_0.compareTo(srvProtoVer0) < 0) {
            return this.handshake(srvProtoVer0);
        }
        throw new SQLException("Handshake failed [driverProtocolVer=" + CURRENT_VER + ", remoteNodeProtocolVer=" + srvProtoVer0 + ", err=" + err + ']', "08004");
    }

    private HandshakeResult handshake_2_1_0() throws IOException, SQLException {
        BinaryWriterExImpl writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(13), null, null);
        writer.writeByte((byte)1);
        writer.writeShort(VER_2_1_0.major());
        writer.writeShort(VER_2_1_0.minor());
        writer.writeShort(VER_2_1_0.maintenance());
        writer.writeByte((byte)1);
        writer.writeBoolean(this.connProps.isDistributedJoins());
        writer.writeBoolean(this.connProps.isEnforceJoinOrder());
        writer.writeBoolean(this.connProps.isCollocated());
        writer.writeBoolean(this.connProps.isReplicatedOnly());
        writer.writeBoolean(this.connProps.isAutoCloseServerCursor());
        this.send(writer.array());
        BinaryReaderExImpl reader = new BinaryReaderExImpl(null, new BinaryHeapInputStream(this.read()), null, null, false);
        boolean accepted = reader.readBoolean();
        if (accepted) {
            HandshakeResult handshakeRes = new HandshakeResult();
            handshakeRes.igniteVersion(new IgniteProductVersion(2, 1, 0, "Unknown", 0L, null));
            handshakeRes.serverProtocolVersion(VER_2_1_0);
            return handshakeRes;
        }
        short maj = reader.readShort();
        short min = reader.readShort();
        short maintenance = reader.readShort();
        String err = reader.readString();
        ClientListenerProtocolVersion ver = ClientListenerProtocolVersion.create(maj, min, maintenance);
        throw new SQLException("Handshake failed [driverProtocolVer=" + CURRENT_VER + ", remoteNodeProtocolVer=" + ver + ", err=" + err + ']', "08004");
    }

    void sendRequestNoWaitResponse(JdbcRequest req) throws IOException, SQLException {
        if (!this.isUnorderedStreamSupported()) {
            throw new SQLException("Streaming without response doesn't supported by server [driverProtocolVer=" + CURRENT_VER + ", remoteNodeVer=" + this.igniteVer + ']', "50000");
        }
        this.sendRequestRaw(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdbcResponse sendRequest(JdbcRequest req, JdbcThinStatement stmt) throws IOException {
        if (stmt != null) {
            Object object = stmt.cancellationMutex();
            synchronized (object) {
                if (stmt.isCancelled()) {
                    if (req instanceof JdbcQueryCloseRequest) {
                        return new JdbcResponse(null);
                    }
                    return new JdbcResponse(3014, "The query was cancelled while executing.");
                }
                this.sendRequestRaw(req);
                if (req instanceof JdbcQueryExecuteRequest || req instanceof JdbcBatchExecuteRequest) {
                    stmt.currentRequestMeta(req.requestId(), this);
                }
            }
        } else {
            this.sendRequestRaw(req);
        }
        JdbcResponse resp = this.readResponse();
        return stmt != null && stmt.isCancelled() ? new JdbcResponse(3014, "The query was cancelled while executing.") : resp;
    }

    void sendCancelRequest(JdbcQueryCancelRequest cancellationReq) throws IOException {
        this.sendRequestRaw(cancellationReq);
    }

    JdbcResponse readResponse() throws IOException {
        BinaryReaderExImpl reader = new BinaryReaderExImpl(this.ctx, new BinaryHeapInputStream(this.read()), null, true);
        JdbcResponse res = new JdbcResponse();
        res.readBinary(reader, this.protoCtx);
        return res;
    }

    private static int guessCapacity(JdbcRequest req) {
        int cap;
        if (req instanceof JdbcBatchExecuteRequest) {
            List<JdbcQuery> qrys = ((JdbcBatchExecuteRequest)req).queries();
            int cnt = !F.isEmpty(qrys) ? Math.min(32, qrys.size()) : 0;
            cap = cnt * 256 + 2;
        } else {
            cap = req instanceof JdbcQueryCloseRequest ? 9 : (req instanceof JdbcQueryMetadataRequest ? 9 : (req instanceof JdbcQueryFetchRequest ? 13 : 256));
        }
        return cap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestRaw(JdbcRequest req) throws IOException {
        int cap = JdbcThinTcpIo.guessCapacity(req);
        BinaryWriterExImpl writer = new BinaryWriterExImpl(this.ctx, new BinaryHeapOutputStream(cap), BinaryThreadLocalContext.get().schemaHolder(), null);
        req.writeBinary(writer, this.protoCtx);
        Object object = this.connMux;
        synchronized (object) {
            this.send(writer.array());
        }
    }

    private void send(byte[] req) throws IOException {
        int size = req.length;
        this.out.write(size & 0xFF);
        this.out.write(size >> 8 & 0xFF);
        this.out.write(size >> 16 & 0xFF);
        this.out.write(size >> 24 & 0xFF);
        this.out.write(req);
        this.out.flush();
    }

    private byte[] read() throws IOException {
        byte[] sizeBytes = this.read(4);
        int msgSize = (0xFF & sizeBytes[3]) << 24 | (0xFF & sizeBytes[2]) << 16 | ((0xFF & sizeBytes[1]) << 8) + (0xFF & sizeBytes[0]);
        return this.read(msgSize);
    }

    private byte[] read(int size) throws IOException {
        int res;
        byte[] data = new byte[size];
        for (int off = 0; off != size; off += res) {
            res = this.in.read(data, off, size - off);
            if (res != -1) continue;
            throw new IOException("Failed to read incoming message (not enough data).");
        }
        return data;
    }

    public void close() {
        if (!this.connected) {
            return;
        }
        U.closeQuiet(this.out);
        U.closeQuiet(this.in);
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        this.connected = false;
    }

    public ConnectionProperties connectionProperties() {
        return this.connProps;
    }

    IgniteProductVersion igniteVersion() {
        return this.igniteVer;
    }

    boolean isUnorderedStreamSupported() {
        assert (this.srvProtoVer != null);
        return this.srvProtoVer.compareTo(VER_2_5_0) >= 0;
    }

    boolean isQueryCancellationSupported() {
        assert (this.srvProtoVer != null);
        return this.srvProtoVer.compareTo(VER_2_8_0) >= 0;
    }

    boolean isPartitionAwarenessSupported() {
        assert (this.srvProtoVer != null);
        return this.srvProtoVer.compareTo(VER_2_8_0) >= 0;
    }

    boolean isCustomObjectSupported() {
        return this.protoCtx.isFeatureSupported(JdbcThinFeature.CUSTOM_OBJECT);
    }

    private static int nextServerIndex(int len) {
        if (len == 1) {
            return 0;
        }
        long nextIdx = IDX_GEN.getAndIncrement();
        return (int)(Math.abs(nextIdx) % (long)len);
    }

    public void timeout(int ms) throws SQLException {
        this.endpoint.timeout(ms);
    }

    public int timeout() throws SQLException {
        return this.endpoint.timeout();
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public InetSocketAddress socketAddress() {
        return this.sockAddr;
    }

    public boolean connected() {
        return this.connected;
    }

    private EnumSet<JdbcThinFeature> enabledFeatures() {
        EnumSet<JdbcThinFeature> features = JdbcThinFeature.allFeaturesAsEnumSet();
        String disabledFeaturesStr = this.connProps.disabledFeatures();
        if (Objects.isNull(disabledFeaturesStr)) {
            return features;
        }
        for (String f : disabledFeaturesStr.split("\\W+")) {
            features.remove(JdbcThinFeature.valueOf(f.toUpperCase()));
        }
        return features;
    }

    static {
        CURRENT_VER = VER_2_8_3 = ClientListenerProtocolVersion.create(2, 8, 3);
        IDX_GEN = new AtomicLong(new Random(U.currentTimeMillis()).nextLong());
    }
}

