/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal.shmem;

import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.GridConcurrentLinkedHashSet;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.IpcToNioAdapter;
import org.apache.ignite.internal.util.nio.GridConnectionBytesVerifyFilter;
import org.apache.ignite.internal.util.nio.GridDirectParser;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioMessageReaderFactory;
import org.apache.ignite.internal.util.nio.GridNioMessageWriterFactory;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioTracerFilter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;

public class ShmemWorker
extends GridWorker {
    private static final String WORKER_NAME = "shmem-worker";
    private final Set<Runnable> finishListeners = new GridConcurrentLinkedHashSet<Runnable>();
    private final IpcEndpoint endpoint;
    private final GridNioServerListener<Message> srvLsnr;
    private final TcpCommunicationMetricsListener metricsLsnr;
    private final GridNioMessageReaderFactory readerFactory;
    private final GridNioMessageWriterFactory writerFactory;
    private final MessageFactory msgFactory;
    private final IgniteLogger log;
    private Tracing tracing;

    public ShmemWorker(String igniteInstanceName, IgniteLogger log, Tracing tracing, IpcEndpoint endpoint, GridNioServerListener<Message> srvLsnr, TcpCommunicationMetricsListener metricsLsnr, GridNioMessageReaderFactory readerFactory, GridNioMessageWriterFactory writerFactory, MessageFactory msgFactory) {
        super(igniteInstanceName, WORKER_NAME, log);
        this.endpoint = endpoint;
        this.log = log;
        this.tracing = tracing;
        this.srvLsnr = srvLsnr;
        this.metricsLsnr = metricsLsnr;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.msgFactory = msgFactory;
    }

    @Override
    protected void body() throws InterruptedException {
        try {
            IpcToNioAdapter<Message> adapter = new IpcToNioAdapter<Message>(this.metricsLsnr.metricRegistry(), this.log, this.endpoint, this.srvLsnr, this.writerFactory, new GridNioTracerFilter(this.log, this.tracing), new GridNioCodecFilter(new GridDirectParser(this.log.getLogger(GridDirectParser.class), this.msgFactory, this.readerFactory), this.log, true), new GridConnectionBytesVerifyFilter(this.log));
            adapter.serve();
        }
        finally {
            this.finishListeners.forEach(Runnable::run);
            this.endpoint.close();
        }
    }

    public void onFinish(Runnable lsnr) {
        this.finishListeners.add(lsnr);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.endpoint.close();
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.endpoint.close();
    }

    @Override
    public String toString() {
        return S.toString(ShmemWorker.class, this);
    }
}

