/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.sharedfs;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsCheckpointData;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsCheckpointSpiMBean;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsTimeData;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsTimeoutTask;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsUtils;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=false)
public class SharedFsCheckpointSpi
extends IgniteSpiAdapter
implements CheckpointSpi {
    public static final String DFLT_DIR_PATH = "cp/sharedfs";
    private static final String CODES = "0123456789QWERTYUIOPASDFGHJKLZXCVBNM";
    private static final int CODES_LEN = "0123456789QWERTYUIOPASDFGHJKLZXCVBNM".length();
    @LoggerResource
    private IgniteLogger log;
    @IgniteInstanceResource
    private Ignite ignite;
    private Queue<String> dirPaths = new LinkedList<String>();
    private String curDirPath = "cp/sharedfs";
    private File folder;
    private String host;
    private String igniteInstanceName;
    private SharedFsTimeoutTask timeoutTask;
    private CheckpointListener lsnr;
    private Marshaller marsh;

    public SharedFsCheckpointSpi() {
        this.dirPaths.offer(DFLT_DIR_PATH);
    }

    public Collection<String> getDirectoryPaths() {
        return this.dirPaths;
    }

    public String getCurrentDirectoryPath() {
        return this.curDirPath;
    }

    @IgniteSpiConfiguration(optional=true)
    public SharedFsCheckpointSpi setDirectoryPaths(Collection<String> dirPaths) {
        A.ensure(!F.isEmpty(dirPaths), "!F.isEmpty(dirPaths)");
        this.dirPaths.clear();
        this.dirPaths.addAll(dirPaths);
        return this;
    }

    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(!F.isEmpty(this.dirPaths), "!F.isEmpty(dirPaths)");
        this.igniteInstanceName = igniteInstanceName;
        this.marsh = this.ignite.configuration().getMarshaller() instanceof BinaryMarshaller ? ((IgniteEx)this.ignite).context().marshallerContext().jdkMarshaller() : this.ignite.configuration().getMarshaller();
        this.folder = this.getNextSharedPath();
        if (this.folder == null) {
            throw new IgniteSpiException("Failed to create checkpoint directory.");
        }
        if (!this.folder.isDirectory()) {
            throw new IgniteSpiException("Checkpoint directory path is not a valid directory: " + this.curDirPath);
        }
        this.registerMBean(igniteInstanceName, new SharedFsCheckpointSpiMBeanImpl(this), SharedFsCheckpointSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("folder", this.folder));
            this.log.debug(this.configInfo("dirPaths", this.dirPaths));
        }
        try {
            this.host = U.getLocalHost().getHostName();
        }
        catch (IOException e) {
            throw new IgniteSpiException("Failed to get localhost address.", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        if (this.timeoutTask != null) {
            U.interrupt(this.timeoutTask);
            U.join(this.timeoutTask, this.log);
        }
        this.unregisterMBean();
        this.folder = null;
        this.host = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Nullable
    private File getNextSharedPath() throws IgniteSpiException {
        if (this.folder != null) {
            this.folder = null;
            this.dirPaths.poll();
        }
        if (this.timeoutTask != null) {
            U.interrupt(this.timeoutTask);
            U.join(this.timeoutTask, this.log);
        }
        while (!this.dirPaths.isEmpty()) {
            this.curDirPath = this.dirPaths.peek();
            if (new File(this.curDirPath).exists()) {
                this.folder = new File(this.curDirPath);
                break;
            }
            try {
                this.folder = U.resolveWorkDirectory(this.ignite.configuration().getWorkDirectory(), this.curDirPath, false);
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to resolve directory [path=" + this.curDirPath + ", exception=" + e.getMessage() + ']');
                }
                this.dirPaths.poll();
                if (!this.dirPaths.isEmpty()) continue;
                throw new IgniteSpiException("Failed to resolve directory: " + this.curDirPath + ']', e);
            }
            if (!this.log.isDebugEnabled()) break;
            this.log.debug("Created shared filesystem checkpoint directory: " + this.folder.getAbsolutePath());
            break;
        }
        if (this.folder != null) {
            HashMap<File, SharedFsTimeData> files = new HashMap<File, SharedFsTimeData>();
            for (File file : this.getFiles()) {
                if (!file.exists()) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Checking checkpoint file: " + file.getAbsolutePath());
                }
                try {
                    SharedFsCheckpointData data = SharedFsUtils.read(file, this.marsh, this.log);
                    if (!data.getHost().equals(this.host)) continue;
                    files.put(file, new SharedFsTimeData(data.getExpireTime(), file.lastModified(), data.getKey()));
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Registered existing checkpoint from: " + file.getAbsolutePath());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to unmarshal objects in checkpoint file (ignoring): " + file.getAbsolutePath(), e);
                }
                catch (IOException e) {
                    U.error(this.log, "IO error reading checkpoint file (ignoring): " + file.getAbsolutePath(), e);
                }
            }
            this.timeoutTask = new SharedFsTimeoutTask(this.igniteInstanceName, this.marsh, this.log);
            this.timeoutTask.setCheckpointListener(this.lsnr);
            this.timeoutTask.add(files);
            this.timeoutTask.start();
        }
        return this.folder;
    }

    private String getUniqueFileName(CharSequence key) {
        assert (key != null);
        SB sb = new SB();
        for (int i = 0; i < key.length() && i < 124; ++i) {
            sb.a(CODES.charAt(key.charAt(i) % CODES_LEN));
        }
        return sb.a(".gcp").toString();
    }

    @Override
    public byte[] loadCheckpoint(String key) throws IgniteSpiException {
        assert (key != null);
        File file = new File(this.folder, this.getUniqueFileName(key));
        if (file.exists()) {
            try {
                SharedFsCheckpointData data = SharedFsUtils.read(file, this.marsh, this.log);
                return data != null ? (Object)(data.getExpireTime() == 0L || data.getExpireTime() > U.currentTimeMillis() ? data.getState() : null) : null;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteSpiException("Failed to unmarshal objects in checkpoint file: " + file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                throw new IgniteSpiException("Failed to read checkpoint file: " + file.getAbsolutePath(), e);
            }
        }
        return null;
    }

    @Override
    public boolean saveCheckpoint(String key, byte[] state, long timeout, boolean overwrite) throws IgniteSpiException {
        assert (key != null);
        long expireTime = 0L;
        if (timeout > 0L && (expireTime = U.currentTimeMillis() + timeout) < 0L) {
            expireTime = Long.MAX_VALUE;
        }
        boolean saved = false;
        while (!saved) {
            File file = new File(this.folder, this.getUniqueFileName(key));
            if (file.exists()) {
                if (!overwrite) {
                    return false;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Overriding existing file: " + file.getAbsolutePath());
                }
            }
            try {
                SharedFsUtils.write(file, new SharedFsCheckpointData(state, expireTime, this.host, key), this.marsh, this.log);
            }
            catch (IOException e) {
                if (this.getNextSharedPath() != null) continue;
                throw new IgniteSpiException("Failed to write checkpoint data into file: " + file.getAbsolutePath(), e);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteSpiException("Failed to marshal checkpoint data into file: " + file.getAbsolutePath(), e);
            }
            if (timeout > 0L) {
                this.timeoutTask.add(file, new SharedFsTimeData(expireTime, file.lastModified(), key));
            }
            saved = true;
        }
        return true;
    }

    private File[] getFiles() {
        assert (this.folder != null);
        return this.folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathName) {
                return !pathName.isDirectory();
            }
        });
    }

    @Override
    public boolean removeCheckpoint(String key) {
        CheckpointListener lsnr;
        boolean rmv;
        assert (key != null);
        File file = new File(this.folder, this.getUniqueFileName(key));
        if (this.timeoutTask != null) {
            this.timeoutTask.remove(file);
        }
        if ((rmv = file.delete()) && (lsnr = this.lsnr) != null) {
            lsnr.onCheckpointRemoved(key);
        }
        return rmv;
    }

    @Override
    public void setCheckpointListener(CheckpointListener lsnr) {
        this.lsnr = lsnr;
        if (this.timeoutTask != null) {
            this.timeoutTask.setCheckpointListener(lsnr);
        }
    }

    @Override
    public SharedFsCheckpointSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(SharedFsCheckpointSpi.class, this);
    }

    private class SharedFsCheckpointSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements SharedFsCheckpointSpiMBean {
        SharedFsCheckpointSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public Collection<String> getDirectoryPaths() {
            return SharedFsCheckpointSpi.this.getDirectoryPaths();
        }

        @Override
        public String getCurrentDirectoryPath() {
            return SharedFsCheckpointSpi.this.getCurrentDirectoryPath();
        }
    }
}

