/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.ObjectInputStreamWrapper;
import org.apache.ignite.marshaller.jdk.JdkMarshallerDummySerializable;

public class JdkMarshallerObjectInputStream
extends ObjectInputStream
implements ObjectInputStreamWrapper {
    private final ClassLoader clsLdr;
    private final IgnitePredicate<String> clsFilter;

    public JdkMarshallerObjectInputStream(InputStream in, ClassLoader clsLdr, IgnitePredicate<String> clsFilter) throws IOException {
        super(in);
        assert (clsLdr != null);
        this.clsLdr = clsLdr;
        this.clsFilter = clsFilter;
        this.enableResolveObject(true);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return U.forName(desc.getName(), this.clsLdr, this.clsFilter);
    }

    @Override
    protected Object resolveObject(Object o) throws IOException {
        if (o != null && o.getClass().equals(JdkMarshallerDummySerializable.class)) {
            return new Object();
        }
        return super.resolveObject(o);
    }

    @Override
    public ObjectInputStream wrap(InputStream inputStream) throws IOException {
        return new JdkMarshallerObjectInputStream(inputStream, this.clsLdr, this.clsFilter);
    }
}

