/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.websession;

import java.io.Serializable;
import java.util.Map;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.websession.WebSessionEntity;

public class WebSessionAttributeProcessor
implements EntryProcessor<String, WebSessionEntity, Void>,
Serializable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private Map<String, byte[]> updatesMap;
    private long accessTime;
    private int maxInactiveInterval;
    private boolean maxIntervalChanged;

    public WebSessionAttributeProcessor() {
    }

    public WebSessionAttributeProcessor(Map<String, byte[]> updatesMap, long accessTime, int maxInactiveInterval, boolean maxIntervalChanged) {
        this.updatesMap = updatesMap;
        this.accessTime = accessTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.maxIntervalChanged = maxIntervalChanged;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeMap(this.updatesMap);
        rawWriter.writeLong(this.accessTime);
        rawWriter.writeBoolean(this.maxIntervalChanged);
        if (this.maxIntervalChanged) {
            rawWriter.writeInt(this.maxInactiveInterval);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        this.updatesMap = rawReader.readMap();
        this.accessTime = rawReader.readLong();
        this.maxIntervalChanged = rawReader.readBoolean();
        if (this.maxIntervalChanged) {
            this.maxInactiveInterval = rawReader.readInt();
        }
    }

    @Override
    public Void process(MutableEntry<String, WebSessionEntity> entry, Object ... arguments) throws EntryProcessorException {
        WebSessionEntity entity = entry.getValue();
        WebSessionEntity newEntity = new WebSessionEntity(entity);
        if (newEntity.accessTime() < this.accessTime) {
            newEntity.accessTime(this.accessTime);
        }
        if (this.maxIntervalChanged) {
            newEntity.maxInactiveInterval(this.maxInactiveInterval);
        }
        if (!F.isEmpty(this.updatesMap)) {
            for (Map.Entry<String, byte[]> update : this.updatesMap.entrySet()) {
                String name = update.getKey();
                assert (name != null);
                byte[] val = update.getValue();
                if (val != null) {
                    newEntity.putAttribute(name, val);
                    continue;
                }
                newEntity.removeAttribute(name);
            }
        }
        entry.setValue(newEntity);
        return null;
    }
}

