/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheAggregatedMetrics;
import org.apache.ignite.internal.visor.cache.VisorCacheMetrics;
import org.apache.ignite.internal.visor.cache.VisorCacheMetricsCollectorTaskArg;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCacheMetricsCollectorTask
extends VisorMultiNodeTask<VisorCacheMetricsCollectorTaskArg, Iterable<VisorCacheAggregatedMetrics>, Collection<VisorCacheMetrics>> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheMetricsCollectorJob job(VisorCacheMetricsCollectorTaskArg arg) {
        return new VisorCacheMetricsCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Iterable<VisorCacheAggregatedMetrics> reduce0(List<ComputeJobResult> results) {
        HashMap<String, VisorCacheAggregatedMetrics> grpAggrMetrics = U.newHashMap(results.size());
        for (ComputeJobResult res : results) {
            if (res.getException() != null) continue;
            Collection cms = (Collection)res.getData();
            for (VisorCacheMetrics cm : cms) {
                VisorCacheAggregatedMetrics am = (VisorCacheAggregatedMetrics)grpAggrMetrics.get(cm.getName());
                if (am == null) {
                    am = new VisorCacheAggregatedMetrics(cm);
                    grpAggrMetrics.put(cm.getName(), am);
                }
                am.getMetrics().put(res.getNode().id(), cm);
            }
        }
        return new ArrayList<VisorCacheAggregatedMetrics>(grpAggrMetrics.values());
    }

    private static class VisorCacheMetricsCollectorJob
    extends VisorJob<VisorCacheMetricsCollectorTaskArg, Collection<VisorCacheMetrics>> {
        private static final long serialVersionUID = 0L;

        private VisorCacheMetricsCollectorJob(VisorCacheMetricsCollectorTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Collection<VisorCacheMetrics> run(VisorCacheMetricsCollectorTaskArg arg) {
            assert (arg != null);
            boolean showSysCaches = arg.isShowSystemCaches();
            List<String> cacheNames = arg.getCacheNames();
            assert (cacheNames != null);
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            Collection<IgniteCacheProxy<?, ?>> caches = cacheProcessor.jcaches();
            ArrayList<VisorCacheMetrics> res = new ArrayList<VisorCacheMetrics>(caches.size());
            boolean allCaches = cacheNames.isEmpty();
            for (IgniteCacheProxy<?, ?> ca : caches) {
                GridCacheContext<?, ?> ctx;
                String cacheName = ca.getName();
                if (VisorTaskUtils.isRestartingCache(this.ignite, cacheName) || !(ctx = ca.context()).started() || !ctx.affinityNode() && !ctx.isNear()) continue;
                VisorCacheMetrics cm = new VisorCacheMetrics(this.ignite, cacheName);
                if (!allCaches && !cacheNames.contains(cacheName) || !showSysCaches && cm.isSystem()) continue;
                res.add(cm);
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorCacheMetricsCollectorJob.class, this);
        }
    }
}

