/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class GridClassLoaderCache {
    private static final ConcurrentMap<Class<?>, ClassLoader> cache = new ConcurrentHashMap();

    public static ClassLoader classLoader(Class<?> cls) {
        ClassLoader old;
        ClassLoader cached = (ClassLoader)cache.get(cls);
        if (cached == null && (old = cache.putIfAbsent(cls, cached = GridClassLoaderCache.detectClassLoader(cls))) != null) {
            cached = old;
        }
        return cached;
    }

    public static void onUndeployed(ClassLoader ldr) {
        assert (ldr != null);
        for (Map.Entry e : cache.entrySet()) {
            if (!((ClassLoader)e.getValue()).equals(ldr)) continue;
            cache.remove(e.getKey(), ldr);
        }
    }

    private static ClassLoader detectClassLoader(Class<?> cls) {
        ClassLoader ctxClsLdr = Thread.currentThread().getContextClassLoader();
        ClassLoader clsLdr = cls.getClassLoader();
        if (clsLdr == null) {
            clsLdr = U.gridClassLoader();
        }
        if (U.p2pLoader(ctxClsLdr)) {
            return clsLdr;
        }
        if (ctxClsLdr != null) {
            if (ctxClsLdr == clsLdr) {
                return ctxClsLdr;
            }
            try {
                Class<?> c = Class.forName(cls.getName(), true, ctxClsLdr);
                if (c == cls) {
                    return ctxClsLdr;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clsLdr;
    }

    public static void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> GridClassLoaderCache memory stats:", new Object[0]);
        X.println(" Cache size: " + cache.size(), new Object[0]);
        for (Map.Entry e : cache.entrySet()) {
            X.println(" " + e.getKey() + " : " + e.getValue(), new Object[0]);
        }
    }

    public static void clear() {
        cache.clear();
    }

    private GridClassLoaderCache() {
    }
}

