/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.stat;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.stat.IoStatisticsManager;
import org.apache.ignite.mxbean.IoStatisticsMetricsMXBean;

public class IoStatisticsMetricsLocalMXBeanImpl
implements IoStatisticsMetricsMXBean {
    private IoStatisticsManager statMgr;

    public IoStatisticsMetricsLocalMXBeanImpl(IoStatisticsManager statMgr) {
        this.statMgr = statMgr;
    }

    @Override
    public long getStartTime() {
        return this.statMgr.startTime().toEpochSecond();
    }

    @Override
    public String getStartTimeLocal() {
        return this.statMgr.startTime().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public void reset() {
        this.statMgr.reset();
    }

    @Override
    public String getCacheGroupStatistics(String cacheGrpName) {
        if (cacheGrpName == null) {
            return null;
        }
        return this.formattedStats(IoStatisticsType.CACHE_GROUP, cacheGrpName, null);
    }

    @Override
    public Long getCacheGroupPhysicalReads(String cacheGrpName) {
        if (cacheGrpName == null) {
            return null;
        }
        return this.statMgr.physicalReads(IoStatisticsType.CACHE_GROUP, cacheGrpName, null);
    }

    @Override
    public Long getCacheGroupLogicalReads(String cacheGrpName) {
        if (cacheGrpName == null) {
            return null;
        }
        return this.statMgr.logicalReads(IoStatisticsType.CACHE_GROUP, cacheGrpName, null);
    }

    @Override
    public String getIndexStatistics(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        return this.formattedStats(this.getIndexStatType(idxName), cacheGrpName, idxName);
    }

    private IoStatisticsType getIndexStatType(String idxName) {
        return idxName.equals("HASH_PK") ? IoStatisticsType.HASH_INDEX : IoStatisticsType.SORTED_INDEX;
    }

    private String formattedStats(IoStatisticsType statType, String name, String subName) {
        Map<String, Long> logicalReads = this.statMgr.logicalReadsMap(statType, name, subName);
        Map<String, Long> physicalReads = this.statMgr.physicalReadsMap(statType, name, subName);
        String stats = Stream.concat(logicalReads.entrySet().stream(), physicalReads.entrySet().stream()).map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ", "[", "]"));
        String statInfo = statType.name() + " " + (subName != null ? name + "." + subName : name);
        return statInfo + " " + stats;
    }

    @Override
    public Long getIndexPhysicalReads(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        return this.statMgr.physicalReads(this.getIndexStatType(idxName), cacheGrpName, idxName);
    }

    @Override
    public Long getIndexLogicalReads(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        return this.statMgr.logicalReads(this.getIndexStatType(idxName), cacheGrpName, idxName);
    }

    @Override
    public Long getIndexLeafLogicalReads(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        Map<String, Long> logicalReads = this.statMgr.logicalReadsMap(this.getIndexStatType(idxName), cacheGrpName, idxName);
        return logicalReads.get("LOGICAL_READS_LEAF");
    }

    @Override
    public Long getIndexLeafPhysicalReads(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        Map<String, Long> logicalReads = this.statMgr.physicalReadsMap(this.getIndexStatType(idxName), cacheGrpName, idxName);
        return logicalReads.get("PHYSICAL_READS_LEAF");
    }

    @Override
    public Long getIndexInnerLogicalReads(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        Map<String, Long> logicalReads = this.statMgr.logicalReadsMap(this.getIndexStatType(idxName), cacheGrpName, idxName);
        return logicalReads.get("LOGICAL_READS_INNER");
    }

    @Override
    public Long getIndexInnerPhysicalReads(String cacheGrpName, String idxName) {
        if (cacheGrpName == null || idxName == null) {
            return null;
        }
        Map<String, Long> logicalReads = this.statMgr.physicalReadsMap(this.getIndexStatType(idxName), cacheGrpName, idxName);
        return logicalReads.get("PHYSICAL_READS_INNER");
    }
}

