/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class SqlClientContext
implements AutoCloseable {
    private final GridKernalContext ctx;
    private final boolean distributedJoins;
    private final boolean enforceJoinOrder;
    private final boolean collocated;
    private final boolean replicatedOnly;
    private final boolean lazy;
    private final boolean skipReducerOnUpdate;
    @Nullable
    private final Boolean dataPageScanEnabled;
    @Nullable
    private final Integer updateBatchSize;
    private long qryMaxMemory;
    private final Object muxStreamer = new Object();
    private boolean streamAllowOverwrite;
    private int streamNodeParOps;
    private int streamNodeBufSize;
    private long streamFlushTimeout;
    private boolean streamOrdered;
    private volatile Map<String, IgniteDataStreamer<?, ?>> streamers;
    private IgniteThread orderedBatchThread;
    private Factory<GridWorker> orderedBatchWorkerFactory;
    private long totalProcessedOrderedReqs;
    private final boolean serverBulkLoadEnabled;
    private final IgniteLogger log;

    public SqlClientContext(GridKernalContext ctx, Factory<GridWorker> orderedBatchWorkerFactory, boolean distributedJoins, boolean enforceJoinOrder, boolean collocated, boolean replicatedOnly, boolean lazy, boolean skipReducerOnUpdate, @Nullable Boolean dataPageScanEnabled, @Nullable Integer updateBatchSize, long qryMaxMemory, boolean serverBulkLoadEnabled) {
        this.ctx = ctx;
        this.orderedBatchWorkerFactory = orderedBatchWorkerFactory;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.collocated = collocated;
        this.replicatedOnly = replicatedOnly;
        this.lazy = lazy;
        this.skipReducerOnUpdate = skipReducerOnUpdate;
        this.dataPageScanEnabled = dataPageScanEnabled;
        this.updateBatchSize = updateBatchSize;
        this.qryMaxMemory = qryMaxMemory;
        this.serverBulkLoadEnabled = serverBulkLoadEnabled;
        this.log = ctx.log(SqlClientContext.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStreaming(boolean allowOverwrite, long flushFreq, int perNodeBufSize, int perNodeParOps, boolean ordered) {
        Object object = this.muxStreamer;
        synchronized (object) {
            if (this.isStream()) {
                return;
            }
            this.streamers = new HashMap();
            this.streamAllowOverwrite = allowOverwrite;
            this.streamFlushTimeout = flushFreq;
            this.streamNodeBufSize = perNodeBufSize;
            this.streamNodeParOps = perNodeParOps;
            this.streamOrdered = ordered;
            this.totalProcessedOrderedReqs = 0L;
            if (ordered) {
                this.orderedBatchThread = new IgniteThread(this.orderedBatchWorkerFactory.create());
                this.orderedBatchThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableStreaming() {
        Object object = this.muxStreamer;
        synchronized (object) {
            if (!this.isStream()) {
                return;
            }
            Iterator<IgniteDataStreamer<?, ?>> it = this.streamers.values().iterator();
            while (it.hasNext()) {
                IgniteDataStreamer<?, ?> streamer = it.next();
                U.close(streamer, this.log);
                it.remove();
            }
            this.streamers = null;
            this.orderedBatchThread = null;
            this.totalProcessedOrderedReqs = 0L;
        }
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean isReplicatedOnly() {
        return this.replicatedOnly;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isSkipReducerOnUpdate() {
        return this.skipReducerOnUpdate;
    }

    @Nullable
    public Boolean dataPageScanEnabled() {
        return this.dataPageScanEnabled;
    }

    @Nullable
    public Integer updateBatchSize() {
        return this.updateBatchSize;
    }

    public long maxMemory() {
        return this.qryMaxMemory;
    }

    public boolean serverBulkLoadEnabled() {
        return this.serverBulkLoadEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStream() {
        Object object = this.muxStreamer;
        synchronized (object) {
            return this.streamers != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamOrdered() {
        Object object = this.muxStreamer;
        synchronized (object) {
            return this.streamOrdered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteDataStreamer<?, ?> streamerForCache(String cacheName) {
        Object object = this.muxStreamer;
        synchronized (object) {
            if (this.streamers == null) {
                return null;
            }
            IgniteDataStreamer<Object, Object> res = this.streamers.get(cacheName);
            if (res != null) {
                return res;
            }
            res = this.ctx.grid().dataStreamer(cacheName);
            res.autoFlushFrequency(this.streamFlushTimeout);
            res.allowOverwrite(this.streamAllowOverwrite);
            if (this.streamNodeBufSize > 0) {
                res.perNodeBufferSize(this.streamNodeBufSize);
            }
            if (this.streamNodeParOps > 0) {
                res.perNodeParallelOperations(this.streamNodeParOps);
            }
            this.streamers.put(cacheName, res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTotalProcessedOrderedRequests(long total) {
        Object object = this.muxStreamer;
        synchronized (object) {
            while (this.totalProcessedOrderedReqs < total) {
                try {
                    this.muxStreamer.wait();
                }
                catch (InterruptedException e) {
                    throw new IgniteException("Waiting for end of processing the last batch is interrupted", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderedRequestProcessed() {
        Object object = this.muxStreamer;
        synchronized (object) {
            ++this.totalProcessedOrderedReqs;
            this.muxStreamer.notifyAll();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.streamers == null) {
            return;
        }
        for (IgniteDataStreamer<?, ?> s : this.streamers.values()) {
            U.close(s, this.log);
        }
    }
}

