/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.streamer;

import java.util.Collection;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerHandle;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerReader;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerRequest;

public class ClientDataStreamerAddDataRequest
extends ClientDataStreamerRequest {
    private final long streamerId;
    private final byte flags;
    private final Collection<DataStreamerEntry> entries;

    public ClientDataStreamerAddDataRequest(BinaryReaderExImpl reader) {
        super(reader);
        this.streamerId = reader.readLong();
        this.flags = reader.readByte();
        this.entries = ClientDataStreamerReader.read(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        ClientDataStreamerHandle handle = (ClientDataStreamerHandle)ctx.resources().get(this.streamerId);
        DataStreamerImpl dataStreamer = (DataStreamerImpl)handle.getStreamer();
        try {
            if (this.entries != null) {
                dataStreamer.addData(this.entries);
            }
            if ((this.flags & 8) != 0) {
                dataStreamer.flush();
            }
            if ((this.flags & 0x10) != 0) {
                dataStreamer.close();
                ctx.resources().release(this.streamerId);
            }
        }
        catch (IllegalStateException unused) {
            return this.getInvalidNodeStateResponse();
        }
        return new ClientResponse(this.requestId());
    }
}

