/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.jetbrains.annotations.Nullable;

public class ClientAtomicCreateRequest
extends ClientRequest {
    protected final String name;
    protected final long initVal;
    protected final AtomicConfiguration atomicConfiguration;

    public ClientAtomicCreateRequest(BinaryRawReader reader) {
        super(reader);
        this.name = reader.readString();
        this.initVal = reader.readLong();
        this.atomicConfiguration = ClientAtomicCreateRequest.readAtomicConfiguration(reader);
    }

    @Nullable
    private static AtomicConfiguration readAtomicConfiguration(BinaryRawReader reader) {
        if (!reader.readBoolean()) {
            return null;
        }
        return new AtomicConfiguration().setAtomicSequenceReserveSize(reader.readInt()).setCacheMode(CacheMode.fromOrdinal(reader.readByte())).setBackups(reader.readInt()).setGroupName(reader.readString());
    }
}

