/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueAdapter;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeader;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridTransactionalCacheQueueImpl<T>
extends GridCacheQueueAdapter<T> {
    public GridTransactionalCacheQueueImpl(String queueName, GridCacheQueueHeader hdr, GridCacheContext<?, ?> cctx) {
        super(queueName, hdr, cctx);
    }

    @Override
    public boolean offer(final T item) throws IgniteException {
        A.notNull(item, "item");
        try {
            return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try (GridNearTxLocal tx = GridTransactionalCacheQueueImpl.this.cache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        boolean retVal;
                        Long idx = GridTransactionalCacheQueueImpl.this.cache.invoke(GridTransactionalCacheQueueImpl.this.queueKey, new GridCacheQueueAdapter.AddProcessor(GridTransactionalCacheQueueImpl.this.id, 1), new Object[0]).get();
                        if (idx != null) {
                            GridTransactionalCacheQueueImpl.this.checkRemoved(idx);
                            GridTransactionalCacheQueueImpl.this.cache.getAndPut(GridTransactionalCacheQueueImpl.this.itemKey(idx), item);
                            retVal = true;
                        } else {
                            retVal = false;
                        }
                        tx.commit();
                        Boolean bl = retVal;
                        return bl;
                    }
                }
            });
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public T poll() throws IgniteException {
        try {
            return (T)GridCacheUtils.retryTopologySafe(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    while (true) {
                        GridNearTxLocal tx = GridTransactionalCacheQueueImpl.this.cache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
                        Throwable throwable = null;
                        try {
                            Object retVal;
                            Long idx = GridTransactionalCacheQueueImpl.this.cache.invoke(GridTransactionalCacheQueueImpl.this.queueKey, new GridCacheQueueAdapter.PollProcessor(GridTransactionalCacheQueueImpl.this.id), new Object[0]).get();
                            if (idx != null) {
                                GridTransactionalCacheQueueImpl.this.checkRemoved(idx);
                                retVal = GridTransactionalCacheQueueImpl.this.cache.getAndRemove(GridTransactionalCacheQueueImpl.this.itemKey(idx));
                                if (retVal == null) {
                                    tx.commit();
                                    continue;
                                }
                            } else {
                                retVal = null;
                            }
                            tx.commit();
                            Object t = retVal;
                            return t;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                            continue;
                        }
                        break;
                    }
                }
            });
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    public boolean addAll(final Collection<? extends T> items) {
        A.notNull(items, "items");
        try {
            return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try (GridNearTxLocal tx = GridTransactionalCacheQueueImpl.this.cache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        boolean retVal;
                        Long idx = GridTransactionalCacheQueueImpl.this.cache.invoke(GridTransactionalCacheQueueImpl.this.queueKey, new GridCacheQueueAdapter.AddProcessor(GridTransactionalCacheQueueImpl.this.id, items.size()), new Object[0]).get();
                        if (idx != null) {
                            GridTransactionalCacheQueueImpl.this.checkRemoved(idx);
                            HashMap putMap = new HashMap();
                            for (Object item : items) {
                                putMap.put(GridTransactionalCacheQueueImpl.this.itemKey(idx), item);
                                Long l = idx;
                                Long l2 = idx = Long.valueOf(idx + 1L);
                            }
                            GridTransactionalCacheQueueImpl.this.cache.putAll(putMap);
                            retVal = true;
                        } else {
                            retVal = false;
                        }
                        tx.commit();
                        Boolean bl = retVal;
                        return bl;
                    }
                }
            });
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    protected void removeItem(final long rmvIdx) throws IgniteCheckedException {
        try {
            GridCacheUtils.retryTopologySafe(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try (GridNearTxLocal tx = GridTransactionalCacheQueueImpl.this.cache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        Long idx = GridTransactionalCacheQueueImpl.this.cache.invoke(GridTransactionalCacheQueueImpl.this.queueKey, new GridCacheQueueAdapter.RemoveProcessor(GridTransactionalCacheQueueImpl.this.id, rmvIdx), new Object[0]).get();
                        if (idx != null) {
                            GridTransactionalCacheQueueImpl.this.checkRemoved(idx);
                            GridTransactionalCacheQueueImpl.this.cache.remove(GridTransactionalCacheQueueImpl.this.itemKey(idx));
                        }
                        tx.commit();
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }
}

