/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCondition;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockState;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCacheLockImpl
extends AtomicDataStructureProxy<GridCacheLockState>
implements GridCacheLockEx,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<String> stash = new ThreadLocal();
    private final AtomicBoolean initGuard = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private Lock updateLock = new ReentrantLock();
    private Sync sync;
    private volatile boolean interruptAll;

    public GridCacheLockImpl() {
        this.ctx = null;
    }

    public GridCacheLockImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheLockState> lockView) {
        super(name, key, lockView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeReentrantLock() throws IgniteCheckedException {
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                this.sync = GridCacheUtils.retryTopologySafe(new Callable<Sync>(){

                    @Override
                    public Sync call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheLockImpl.this.ctx, GridCacheLockImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheLockState val = (GridCacheLockState)GridCacheLockImpl.this.cacheView.get(GridCacheLockImpl.this.key);
                            if (val == null) {
                                if (GridCacheLockImpl.this.log.isDebugEnabled()) {
                                    GridCacheLockImpl.this.log.debug("Failed to find reentrant lock with given name: " + GridCacheLockImpl.this.name);
                                }
                                Sync sync = null;
                                return sync;
                            }
                            tx.rollback();
                            Sync sync = new Sync(val);
                            return sync;
                        }
                    }
                });
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Initialized internal sync structure: " + this.sync);
                return;
            }
            finally {
                this.initLatch.countDown();
            }
        } else {
            U.await(this.initLatch);
            if (this.sync != null) return;
            throw new IgniteCheckedException("Internal reentrant lock has not been properly initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(GridCacheLockState val) {
        if (this.sync == null) {
            return;
        }
        this.updateLock.lock();
        try {
            if (!val.isChanged()) {
                return;
            }
            boolean loc = this.sync.isLockedLocally(val.getId());
            boolean incomingSignals = this.sync.checkIncomingSignals(val);
            this.sync.setPermits(val.get());
            this.sync.setCurrentOwnerNode(val.getId());
            this.sync.setCurrentOwnerThread(val.getThreadId());
            if ((incomingSignals || this.sync.getPermits() == 0) && !loc) {
                this.sync.release(0);
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @Override
    public void onNodeRemoved(UUID nodeId) {
        this.updateLock.lock();
        try {
            if (nodeId.equals(this.sync.getOwnerNode()) && !this.sync.failoverSafe) {
                this.sync.setBroken(true);
                this.sync.interruptAll();
            }
            this.sync.release(0);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @Override
    public void onReconnected(UUID nodeId) {
        this.sync.setThisNode(nodeId);
    }

    @Override
    public void onStop() {
        if (this.sync == null) {
            this.interruptAll = true;
            return;
        }
        if (!this.sync.failoverSafe) {
            this.sync.setBroken(true);
        }
        this.sync.interruptAll();
        this.sync.release(0);
    }

    @Override
    public void lock() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeReentrantLock();
            if (this.sync == null) {
                throw new IgniteCheckedException("Failed to find reentrant lock with given name: " + this.name);
            }
            this.sync.lock();
            this.sync.validate(false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public void lockInterruptibly() throws IgniteInterruptedException {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeReentrantLock();
            this.sync.acquireInterruptibly(1);
            this.sync.validate(true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (InterruptedException e) {
            if (this.sync.fair) {
                this.sync.synchronizeQueue(true, Thread.currentThread());
            }
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean tryLock() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeReentrantLock();
            boolean result = this.sync.tryAcquire(1, false);
            this.sync.validate(false);
            boolean bl = result;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws IgniteInterruptedException {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeReentrantLock();
            boolean result = this.sync.tryAcquireNanos(1, unit.toNanos(timeout));
            this.sync.validate(true);
            boolean bl = result;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (InterruptedException e) {
            if (this.sync.fair) {
                this.sync.synchronizeQueue(true, Thread.currentThread());
            }
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public void unlock() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeReentrantLock();
            this.sync.validate(false);
            this.sync.release(1);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    @NotNull
    public Condition newCondition() {
        throw new UnsupportedOperationException("IgniteLock does not allow creation of nameless conditions. ");
    }

    @Override
    public IgniteCondition getOrCreateCondition(String name) {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeReentrantLock();
            IgniteCondition result = this.sync.newCondition(name);
            this.sync.validate(false);
            IgniteCondition igniteCondition = result;
            return igniteCondition;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public int getHoldCount() {
        try {
            this.initializeReentrantLock();
            return this.sync.getHoldCount();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean isHeldByCurrentThread() {
        try {
            this.initializeReentrantLock();
            return this.sync.isHeldExclusively();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean isLocked() {
        try {
            this.initializeReentrantLock();
            return this.sync.isLocked();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean hasQueuedThreads() {
        try {
            this.initializeReentrantLock();
            return this.sync.hasQueuedThreads();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean hasQueuedThread(Thread thread) {
        try {
            this.initializeReentrantLock();
            return this.sync.isQueued(thread);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean hasWaiters(IgniteCondition condition) {
        try {
            this.initializeReentrantLock();
            AbstractQueuedSynchronizer.ConditionObject c = (AbstractQueuedSynchronizer.ConditionObject)this.sync.conditionMap.get(condition.name());
            if (c == null) {
                throw new IllegalArgumentException();
            }
            return this.sync.hasWaiters(c);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public int getWaitQueueLength(IgniteCondition condition) {
        try {
            this.initializeReentrantLock();
            AbstractQueuedSynchronizer.ConditionObject c = (AbstractQueuedSynchronizer.ConditionObject)this.sync.conditionMap.get(condition.name());
            if (c == null) {
                throw new IllegalArgumentException();
            }
            return this.sync.getWaitQueueLength(c);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean isFailoverSafe() {
        try {
            this.initializeReentrantLock();
            return this.sync.failoverSafe;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean isFair() {
        try {
            this.initializeReentrantLock();
            return this.sync.fair;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean isBroken() {
        try {
            this.initializeReentrantLock();
            return this.sync.isBroken();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void needCheckNotRemoved() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        stash.set(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        String name = stash.get();
        assert (name != null);
        try {
            IgniteLock lock = IgnitionEx.localIgnite().context().dataStructures().reentrantLock(name, null, false, false, false);
            if (lock == null) {
                throw new IllegalStateException("Lock was not found on deserialization: " + name);
            }
            IgniteLock igniteLock = lock;
            return igniteLock;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public void close() {
        if (!this.rmvd) {
            try {
                boolean force = this.sync != null && this.sync.isBroken() && !this.sync.failoverSafe;
                this.ctx.kernalContext().dataStructures().removeReentrantLock(this.name, this.ctx.group().name(), force);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(GridCacheLockImpl.class, this, super.toString());
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1192457210091910933L;
        private static final long LOCK_FREE = 0L;
        private Map<String, AbstractQueuedSynchronizer.ConditionObject> conditionMap;
        private Map<String, Integer> outgoingSignals;
        @Nullable
        private volatile String lastCondition;
        private volatile boolean isBroken;
        private volatile UUID currentOwnerNode;
        private volatile long currentOwnerThreadId;
        private volatile UUID thisNode;
        private final boolean failoverSafe;
        private final boolean fair;
        private Set<Long> waitingThreads;

        protected Sync(GridCacheLockState state) {
            this.setState(state.get());
            this.thisNode = GridCacheLockImpl.this.ctx.localNodeId();
            this.currentOwnerNode = state.getId();
            this.currentOwnerThreadId = state.getThreadId();
            this.conditionMap = new HashMap<String, AbstractQueuedSynchronizer.ConditionObject>();
            this.outgoingSignals = new HashMap<String, Integer>();
            this.failoverSafe = state.isFailoverSafe();
            this.fair = state.isFair();
            this.waitingThreads = new ConcurrentSkipListSet<Long>();
        }

        protected void addOutgoingSignal(String condition) {
            int cnt = 0;
            if (this.outgoingSignals.containsKey(condition) && (cnt = this.outgoingSignals.get(condition).intValue()) == 0) {
                return;
            }
            this.outgoingSignals.put(condition, cnt + 1);
        }

        protected void addOutgoingSignalAll(String condition) {
            this.outgoingSignals.put(condition, 0);
        }

        private String processAwait() {
            if (this.lastCondition == null) {
                return null;
            }
            String ret = this.lastCondition;
            this.lastCondition = null;
            return ret;
        }

        private Map<String, Integer> processSignal() {
            HashMap<String, Integer> ret = new HashMap<String, Integer>(this.outgoingSignals);
            this.outgoingSignals.clear();
            return ret;
        }

        private synchronized void interruptAll() {
            if (!this.conditionMap.isEmpty()) {
                UUID tempUUID = this.getOwnerNode();
                long tempThreadID = this.currentOwnerThreadId;
                this.setCurrentOwnerNode(this.thisNode);
                this.currentOwnerThreadId = Thread.currentThread().getId();
                for (Condition condition : this.conditionMap.values()) {
                    condition.signalAll();
                }
                this.setCurrentOwnerNode(tempUUID);
                this.currentOwnerThreadId = tempThreadID;
            }
            GridCacheLockImpl.this.interruptAll = true;
            for (Thread t : this.getQueuedThreads()) {
                t.interrupt();
            }
        }

        private void validate(boolean throwInterrupt) {
            boolean interrupted = Thread.currentThread().isInterrupted();
            if (throwInterrupt || GridCacheLockImpl.this.interruptAll) {
                Thread.interrupted();
            }
            if (GridCacheLockImpl.this.interruptAll) {
                throw new IgniteException("Lock broken (possible reason: node stopped or node owning lock failed while in non-failoversafe mode).");
            }
            if (this.fair && throwInterrupt && interrupted && !GridCacheLockImpl.this.interruptAll) {
                this.synchronizeQueue(true, Thread.currentThread());
                throw new IgniteInterruptedException("Lock is interrupted.");
            }
        }

        final synchronized void setPermits(int permits) {
            this.setState(permits);
        }

        final int getPermits() {
            return this.getState();
        }

        final synchronized void setCurrentOwnerNode(UUID ownerNode) {
            this.currentOwnerNode = ownerNode;
        }

        final UUID getOwnerNode() {
            return this.currentOwnerNode;
        }

        protected boolean isLockedLocally(UUID newOwnerID) {
            return this.thisNode.equals(this.getOwnerNode()) || this.thisNode.equals(newOwnerID);
        }

        protected void setCurrentOwnerThread(long newOwnerThreadId) {
            this.currentOwnerThreadId = newOwnerThreadId;
        }

        protected void setThisNode(UUID nodeId) {
            this.thisNode = nodeId;
        }

        protected boolean isBroken() {
            return this.isBroken;
        }

        protected void setBroken(boolean isBroken) {
            this.isBroken = isBroken;
        }

        protected synchronized boolean hasPredecessor(LinkedList<UUID> nodes) {
            if (!this.fair) {
                return false;
            }
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                UUID node = (UUID)it.next();
                if (GridCacheLockImpl.this.ctx.discovery().node(node) == null) {
                    it.remove();
                    continue;
                }
                return !node.equals(this.thisNode);
            }
            return false;
        }

        final boolean tryAcquire(int acquires, boolean fair) {
            if (GridCacheLockImpl.this.interruptAll) {
                return true;
            }
            Thread current = Thread.currentThread();
            boolean failed = false;
            int c = this.getState();
            while (c != 0) {
                UUID currentOwner = this.currentOwnerNode;
                if (currentOwner != null) {
                    failed = GridCacheLockImpl.this.ctx.discovery().node(currentOwner) == null;
                    break;
                }
                c = this.getState();
            }
            if (c == 0 || failed) {
                if (this.compareAndSetGlobalState(0, acquires, current, fair)) {
                    this.setExclusiveOwnerThread(current);
                    while (!this.isHeldExclusively() && !GridCacheLockImpl.this.interruptAll) {
                        Thread.yield();
                    }
                    return true;
                }
            } else if (this.isHeldExclusively()) {
                int nextc = c + acquires;
                if (nextc < 0) {
                    throw new Error("Maximum lock count exceeded.");
                }
                this.setState(nextc);
                return true;
            }
            if (fair && !this.isQueued(current)) {
                this.synchronizeQueue(false, current);
            }
            return false;
        }

        final void lock() {
            this.acquire(1);
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            return this.tryAcquire(acquires, this.fair);
        }

        @Override
        protected final boolean tryRelease(int releases) {
            if (releases == 0) {
                return true;
            }
            if (GridCacheLockImpl.this.interruptAll) {
                return true;
            }
            int c = this.getState() - releases;
            if (!this.isHeldExclusively()) {
                GridCacheLockImpl.this.log.error("Lock.unlock() is called in illegal state [callerNodeId=" + this.thisNode + ", ownerNodeId=" + this.currentOwnerNode + ", callerThreadId=" + Thread.currentThread().getId() + ", ownerThreadId=" + this.currentOwnerThreadId + ", lockState=" + this.getState() + "]");
                throw new IllegalMonitorStateException();
            }
            boolean free = false;
            if (c == 0) {
                free = true;
                this.setGlobalState(0, this.processAwait(), this.processSignal());
                while (this.isHeldExclusively() && !GridCacheLockImpl.this.interruptAll) {
                    Thread.yield();
                }
            } else {
                this.setState(c);
            }
            return free;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.currentOwnerThreadId == Thread.currentThread().getId() && this.thisNode.equals(this.currentOwnerNode);
        }

        final synchronized IgniteCondition newCondition(String name) {
            if (this.conditionMap.containsKey(name)) {
                return new IgniteConditionObject(name, this.conditionMap.get(name));
            }
            AbstractQueuedSynchronizer.ConditionObject cond = new AbstractQueuedSynchronizer.ConditionObject(this);
            this.conditionMap.put(name, cond);
            return new IgniteConditionObject(name, cond);
        }

        final int getHoldCount() {
            return this.isHeldExclusively() ? this.getState() : 0;
        }

        final boolean isLocked() throws IgniteCheckedException {
            return this.getState() != 0 || ((GridCacheLockState)GridCacheLockImpl.this.cacheView.get(GridCacheLockImpl.this.key)).get() != 0;
        }

        boolean compareAndSetGlobalState(final int expVal, final int newVal, final Thread newThread, final boolean bargingProhibited) {
            try {
                return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Boolean call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheLockImpl.this.ctx, GridCacheLockImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheLockState val = (GridCacheLockState)GridCacheLockImpl.this.cacheView.get(GridCacheLockImpl.this.key);
                            if (val == null) {
                                throw new IgniteCheckedException("Failed to find reentrant lock with given name: " + GridCacheLockImpl.this.name);
                            }
                            long newThreadID = newThread.getId();
                            LinkedList<UUID> nodes = val.getNodes();
                            if (!(bargingProhibited && Sync.this.hasPredecessor(nodes) || val.get() != expVal && GridCacheLockImpl.this.ctx.discovery().node(val.getId()) != null)) {
                                val.set(newVal);
                                val.setId(Sync.this.thisNode);
                                val.setThreadId(newThreadID);
                                val.setSignals(null);
                                if (val.isFair() && (nodes.isEmpty() || !bargingProhibited)) {
                                    nodes.addFirst(Sync.this.thisNode);
                                }
                                val.setNodes(nodes);
                                val.setChanged(true);
                                GridCacheLockImpl.this.cacheView.put(GridCacheLockImpl.this.key, val);
                                tx.commit();
                                Boolean bl2 = true;
                                return bl2;
                            }
                            Boolean bl = false;
                            return bl;
                        }
                        catch (Exception e) {
                            if (GridCacheLockImpl.this.interruptAll) {
                                if (!GridCacheLockImpl.this.log.isInfoEnabled()) return true;
                                GridCacheLockImpl.this.log.info("Node is stopped (or lock is broken in non-failover safe mode), aborting transaction.");
                                return true;
                            }
                            if (!Thread.currentThread().isInterrupted()) {
                                U.error(GridCacheLockImpl.this.log, "Failed to compare and set: " + this, e);
                                throw e;
                            }
                            if (GridCacheLockImpl.this.log.isInfoEnabled()) {
                                GridCacheLockImpl.this.log.info("Thread is interrupted while attempting to acquire lock.");
                            }
                            GridCacheLockImpl.this.sync.release(0);
                            return false;
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        boolean synchronizeQueue(final boolean cancelled, final Thread thread) {
            final AtomicBoolean interrupted = new AtomicBoolean(false);
            try {
                boolean bl = GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Boolean call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheLockImpl.this.ctx, GridCacheLockImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheLockState val = (GridCacheLockState)GridCacheLockImpl.this.cacheView.get(GridCacheLockImpl.this.key);
                            if (val == null) {
                                throw new IgniteCheckedException("Failed to find reentrant lock with given name: " + GridCacheLockImpl.this.name);
                            }
                            LinkedList<UUID> nodes = val.getNodes();
                            if (!cancelled) {
                                nodes.add(Sync.this.thisNode);
                                val.setChanged(false);
                                GridCacheLockImpl.this.cacheView.put(GridCacheLockImpl.this.key, val);
                                tx.commit();
                                GridCacheLockImpl.this.sync.waitingThreads.add(thread.getId());
                                Boolean bl = true;
                                return bl;
                            }
                            if (GridCacheLockImpl.this.sync.waitingThreads.contains(thread.getId())) {
                                val.setChanged(nodes.lastIndexOf(Sync.this.thisNode) == 0);
                                nodes.removeLastOccurrence(Sync.this.thisNode);
                                GridCacheLockImpl.this.cacheView.put(GridCacheLockImpl.this.key, val);
                                tx.commit();
                                GridCacheLockImpl.this.sync.waitingThreads.remove(thread.getId());
                                Boolean bl = true;
                                return bl;
                            }
                            Boolean bl = false;
                            return bl;
                        }
                        catch (Exception e) {
                            if (GridCacheLockImpl.this.interruptAll) {
                                if (GridCacheLockImpl.this.log.isInfoEnabled()) {
                                    GridCacheLockImpl.this.log.info("Node is stopped (or lock is broken in non-failover safe mode), aborting transaction.");
                                }
                                GridCacheLockImpl.this.sync.release(0);
                                return false;
                            }
                            if (!Thread.interrupted() && !X.hasCause((Throwable)e, InterruptedException.class)) {
                                U.error(GridCacheLockImpl.this.log, "Failed to synchronize global lock queue: " + this, e);
                                throw e;
                            }
                            interrupted.set(true);
                            throw new TransactionRollbackException("Thread got interrupted while synchronizing the global queue, retrying. ");
                        }
                    }
                });
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                if (interrupted.get()) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        protected boolean setGlobalState(final int newVal, final @Nullable String lastCond, final Map<String, Integer> outgoingSignals) {
            try {
                return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Boolean call() throws Exception {
                        HashMap<UUID, LinkedList<String>> signalMap;
                        Map<String, LinkedList<UUID>> condMap;
                        GridCacheLockState val;
                        Throwable throwable;
                        GridNearTxLocal tx;
                        try {
                            tx = CU.txStartInternal(GridCacheLockImpl.this.ctx, GridCacheLockImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
                            throwable = null;
                            try {
                                val = (GridCacheLockState)GridCacheLockImpl.this.cacheView.get(GridCacheLockImpl.this.key);
                                if (val == null) {
                                    throw new IgniteCheckedException("Failed to find reentrant lock with given name: " + GridCacheLockImpl.this.name);
                                }
                                val.set(newVal);
                                if (newVal == 0) {
                                    val.setId(null);
                                    val.setThreadId(0L);
                                }
                                val.setChanged(true);
                                if (val.isFair() && newVal == 0) {
                                    UUID rmvdNode = val.getNodes().removeFirst();
                                    assert (Sync.this.thisNode.equals(rmvdNode));
                                }
                                condMap = val.getConditionMap();
                                signalMap = new HashMap<UUID, LinkedList<String>>();
                                if (!outgoingSignals.isEmpty()) {
                                    for (String condition : outgoingSignals.keySet()) {
                                        int cnt = (Integer)outgoingSignals.get(condition);
                                        List list = condMap.get(condition);
                                        if (list == null || list.isEmpty()) continue;
                                        if (cnt == 0) {
                                            cnt = list.size();
                                        }
                                        for (int i = 0; i < cnt && !list.isEmpty(); ++i) {
                                            UUID uuid = (UUID)list.remove(0);
                                            if (GridCacheLockImpl.this.ctx.discovery().node(uuid) == null) {
                                                ++cnt;
                                                continue;
                                            }
                                            LinkedList<String> queue = (LinkedList<String>)signalMap.get(uuid);
                                            if (queue == null) {
                                                queue = new LinkedList<String>();
                                                signalMap.put(uuid, queue);
                                            }
                                            queue.add(condition);
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Exception e) {
                            if (GridCacheLockImpl.this.interruptAll) {
                                if (!GridCacheLockImpl.this.log.isInfoEnabled()) return true;
                                GridCacheLockImpl.this.log.info("Node is stopped (or lock is broken in non-failover safe mode), aborting transaction.");
                                return true;
                            }
                            U.error(GridCacheLockImpl.this.log, "Failed to release: " + this, e);
                            throw e;
                        }
                        val.setSignals(signalMap);
                        if (lastCond != null) {
                            LinkedList<UUID> queue = !condMap.containsKey(lastCond) ? new LinkedList<UUID>() : condMap.get(lastCond);
                            queue.add(Sync.this.thisNode);
                            condMap.put(lastCond, queue);
                        }
                        val.setConditionMap(condMap);
                        GridCacheLockImpl.this.cacheView.put(GridCacheLockImpl.this.key, val);
                        tx.commit();
                        return true;
                        finally {
                            if (tx != null) {
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                } else {
                                    tx.close();
                                }
                            }
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        synchronized boolean checkIncomingSignals(GridCacheLockState state) {
            if (state.getSignals() == null) {
                return false;
            }
            LinkedList<String> signals = state.getSignals().get(this.thisNode);
            if (signals == null || signals.isEmpty()) {
                return false;
            }
            UUID tempUUID = this.getOwnerNode();
            Thread tempThread = this.getExclusiveOwnerThread();
            long tempThreadID = this.currentOwnerThreadId;
            this.setCurrentOwnerNode(this.thisNode);
            this.setExclusiveOwnerThread(Thread.currentThread());
            this.currentOwnerThreadId = Thread.currentThread().getId();
            for (String signal : signals) {
                this.conditionMap.get(signal).signal();
            }
            this.setCurrentOwnerNode(tempUUID);
            this.setExclusiveOwnerThread(tempThread);
            this.currentOwnerThreadId = tempThreadID;
            return true;
        }

        private class IgniteConditionObject
        implements IgniteCondition {
            private final String name;
            private final AbstractQueuedSynchronizer.ConditionObject obj;

            protected IgniteConditionObject(String name, AbstractQueuedSynchronizer.ConditionObject obj) {
                this.name = name;
                this.obj = obj;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public void await() throws IgniteInterruptedException {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    Sync.this.lastCondition = this.name;
                    this.obj.await();
                    GridCacheLockImpl.this.sync.validate(true);
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedException(e);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }

            @Override
            public void awaitUninterruptibly() {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    Sync.this.lastCondition = this.name;
                    this.obj.awaitUninterruptibly();
                    GridCacheLockImpl.this.sync.validate(false);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }

            @Override
            public long awaitNanos(long nanosTimeout) throws IgniteInterruptedException {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    Sync.this.lastCondition = this.name;
                    long result = this.obj.awaitNanos(nanosTimeout);
                    GridCacheLockImpl.this.sync.validate(true);
                    long l = result;
                    return l;
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedException(e);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }

            @Override
            public boolean await(long time, TimeUnit unit) throws IgniteInterruptedException {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    Sync.this.lastCondition = this.name;
                    boolean result = this.obj.await(time, unit);
                    GridCacheLockImpl.this.sync.validate(true);
                    boolean bl = result;
                    return bl;
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedException(e);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }

            @Override
            public boolean awaitUntil(Date deadline) throws IgniteInterruptedException {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    Sync.this.lastCondition = this.name;
                    boolean result = this.obj.awaitUntil(deadline);
                    GridCacheLockImpl.this.sync.validate(true);
                    boolean bl = result;
                    return bl;
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedException(e);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }

            @Override
            public void signal() {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    Sync.this.validate(false);
                    Sync.this.addOutgoingSignal(this.name);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }

            @Override
            public void signalAll() {
                GridCacheLockImpl.this.ctx.kernalContext().gateway().readLock();
                try {
                    if (!Sync.this.isHeldExclusively()) {
                        throw new IllegalMonitorStateException();
                    }
                    GridCacheLockImpl.this.sync.validate(false);
                    Sync.this.addOutgoingSignalAll(this.name);
                }
                finally {
                    GridCacheLockImpl.this.ctx.kernalContext().gateway().readUnlock();
                }
            }
        }
    }
}

