/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationValueMeta;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PartitionReconciliationRepairMeta
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean fixed;
    private PartitionReconciliationValueMeta val;
    private RepairAlgorithm repairAlg;

    public PartitionReconciliationRepairMeta() {
    }

    public PartitionReconciliationRepairMeta(boolean fixed, PartitionReconciliationValueMeta val, RepairAlgorithm repairAlg) {
        this.fixed = fixed;
        this.val = val;
        this.repairAlg = repairAlg;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.fixed);
        out.writeObject(this.val);
        U.writeEnum(out, this.repairAlg);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixed = in.readBoolean();
        this.val = (PartitionReconciliationValueMeta)in.readObject();
        this.repairAlg = RepairAlgorithm.fromOrdinal(in.readByte());
    }

    public boolean fixed() {
        return this.fixed;
    }

    public PartitionReconciliationValueMeta value() {
        return this.val;
    }

    public RepairAlgorithm repairAlg() {
        return this.repairAlg;
    }

    public String stringView(boolean verbose) {
        return "fixed=" + this.fixed + (this.fixed ? ", new_val=" + (this.val != null ? this.val.stringView(verbose) : "null") : "") + ", repairAlg=" + (Object)((Object)this.repairAlg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReconciliationRepairMeta meta = (PartitionReconciliationRepairMeta)o;
        if (this.fixed != meta.fixed) {
            return false;
        }
        if (!Objects.equals(this.val, meta.val)) {
            return false;
        }
        return this.repairAlg == meta.repairAlg;
    }
}

