/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.jetbrains.annotations.NotNull;

public interface FileInput
extends ByteBufferBackedDataInput {
    public FileIO io();

    public void seek(long var1) throws IOException;

    public long position();

    public Crc32CheckingFileInput startRead(boolean var1);

    public static class Crc32CheckingFileInput
    implements ByteBufferBackedDataInput,
    AutoCloseable {
        private final FastCrc crc = new FastCrc();
        private int lastCalcPosition;
        private boolean skipCheck;
        private FileInput delegate;
        private long calcStartPos = -1L;
        private long calcEndPos = -1L;

        public Crc32CheckingFileInput(FileInput delegate, boolean skipCheck) {
            this.delegate = delegate;
            this.lastCalcPosition = delegate.buffer().position();
            this.calcStartPos = 29 + this.lastCalcPosition;
            this.skipCheck = skipCheck;
        }

        @Override
        public void ensure(int requested) throws IOException {
            int available = this.buffer().remaining();
            if (available >= requested) {
                return;
            }
            this.updateCrc();
            this.delegate.ensure(requested);
            this.lastCalcPosition = 0;
        }

        @Override
        public void close() throws Exception {
            this.updateCrc();
            int val = this.crc.getValue();
            int writtenCrc = this.readInt();
            if ((val ^ writtenCrc) != 0 && !this.skipCheck) {
                this.ensure(5);
                throw new IgniteDataIntegrityViolationException("val: " + val + ", writtenCrc: " + writtenCrc + ", crcStartPos: " + this.calcStartPos + ", crcEndPos: " + this.calcEndPos);
            }
        }

        private void updateCrc() {
            if (this.skipCheck) {
                return;
            }
            int oldPos = this.buffer().position();
            this.buffer().position(this.lastCalcPosition);
            this.crc.update(this.delegate.buffer(), oldPos - this.lastCalcPosition);
            this.calcEndPos = this.calcStartPos + (long)(oldPos - this.lastCalcPosition);
            this.lastCalcPosition = oldPos;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.ensure(n);
            int skipped = Math.min(this.buffer().remaining(), n);
            this.buffer().position(this.buffer().position() + skipped);
            return skipped;
        }

        @Override
        public void readFully(@NotNull byte[] b) throws IOException {
            this.ensure(b.length);
            this.buffer().get(b);
        }

        @Override
        public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
            this.ensure(len);
            this.buffer().get(b, off, len);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() == 1;
        }

        @Override
        public byte readByte() throws IOException {
            this.ensure(1);
            return this.buffer().get();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.readByte() & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            this.ensure(2);
            return this.buffer().getShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.readShort() & 0xFFFF;
        }

        @Override
        public char readChar() throws IOException {
            this.ensure(2);
            return this.buffer().getChar();
        }

        @Override
        public int readInt() throws IOException {
            this.ensure(4);
            return this.buffer().getInt();
        }

        @Override
        public long readLong() throws IOException {
            this.ensure(8);
            return this.buffer().getLong();
        }

        @Override
        public float readFloat() throws IOException {
            this.ensure(4);
            return this.buffer().getFloat();
        }

        @Override
        public double readDouble() throws IOException {
            this.ensure(8);
            return this.buffer().getDouble();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer buffer() {
            return this.delegate.buffer();
        }
    }
}

