/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class FileWALPointer
implements WALPointer,
Comparable<FileWALPointer> {
    private static final long serialVersionUID = 0L;
    public static final int POINTER_SIZE = 16;
    private final long idx;
    private final int fileOff;
    private int len;

    public FileWALPointer(long idx, int fileOff, int len) {
        this.idx = idx;
        this.fileOff = fileOff;
        this.len = len;
    }

    public long index() {
        return this.idx;
    }

    public int fileOffset() {
        return this.fileOff;
    }

    public int length() {
        return this.len;
    }

    public void length(int len) {
        this.len = len;
    }

    @Override
    public FileWALPointer next() {
        if (this.len == 0) {
            throw new IllegalStateException("Failed to calculate next WAL pointer (this pointer is a terminal): " + this);
        }
        return new FileWALPointer(this.idx, this.fileOff + this.len, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileWALPointer)) {
            return false;
        }
        FileWALPointer that = (FileWALPointer)o;
        return this.idx == that.idx && this.fileOff == that.fileOff;
    }

    public int hashCode() {
        int res = (int)(this.idx ^ this.idx >>> 32);
        res = 31 * res + this.fileOff;
        return res;
    }

    @Override
    public int compareTo(@NotNull FileWALPointer o) {
        int res = Long.compare(this.idx, o.idx);
        return res == 0 ? Integer.compare(this.fileOff, o.fileOff) : res;
    }

    public String toString() {
        return S.toString(FileWALPointer.class, this);
    }
}

