/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.util.future.GridFinishedFuture;

public class StaticMvccQueryTracker
implements MvccQueryTracker {
    private final MvccSnapshot snapshot;
    private final GridCacheContext cctx;

    public StaticMvccQueryTracker(GridCacheContext cctx, MvccSnapshot snapshot) {
        this.snapshot = snapshot;
        this.cctx = cctx;
    }

    @Override
    public MvccSnapshot snapshot() {
        assert (this.snapshot != null) : this;
        return this.snapshot;
    }

    @Override
    public GridCacheContext context() {
        return this.cctx;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return AffinityTopologyVersion.NONE;
    }

    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot() {
        return new GridFinishedFuture<MvccSnapshot>(this.snapshot);
    }

    @Override
    public void onDone() {
    }
}

