/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgniteDhtPartitionsToReloadMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Map<UUID, Map<Integer, Set<Integer>>> map;

    public synchronized Set<Integer> get(UUID nodeId, int cacheId) {
        if (this.map == null) {
            return Collections.emptySet();
        }
        Map<Integer, Set<Integer>> nodeMap = this.map.get(nodeId);
        if (nodeMap == null) {
            return Collections.emptySet();
        }
        Set<Integer> parts = nodeMap.get(cacheId);
        if (parts == null) {
            return Collections.emptySet();
        }
        return parts;
    }

    public synchronized void put(UUID nodeId, int cacheId, int partId) {
        if (this.map == null) {
            this.map = new HashMap<UUID, Map<Integer, Set<Integer>>>();
        }
        Map nodeMap = this.map.computeIfAbsent(nodeId, k -> new HashMap());
        Set parts = nodeMap.computeIfAbsent(cacheId, k -> new HashSet());
        parts.add(partId);
    }

    public synchronized boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public String toString() {
        return S.toString(IgniteDhtPartitionsToReloadMap.class, this);
    }
}

