/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheClusterMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheIteratorConverter;
import org.apache.ignite.internal.processors.cache.CacheLocalMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.CacheMetricsSnapshotV2;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheClearAllRunnable;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.affinity.GridCacheAffinityImpl;
import org.apache.ignite.internal.processors.cache.distributed.IgniteExternalizableExpiryPolicy;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.dr.IgniteDrDataStreamerCacheUpdater;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.transactions.TransactionCheckedException;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.CIX3;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheAdapter<K, V>
implements IgniteInternalCache<K, V>,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final int CLEAR_ALL_SPLIT_THRESHOLD = 10000;
    public static final int DFLT_CACHE_START_SIZE = 4096;
    public static final int DFLT_START_CACHE_SIZE = IgniteSystemProperties.getInteger("IGNITE_CACHE_START_SIZE", 4096);
    private static final int REMOVE_ALL_KEYS_BATCH = 10000;
    public static final int DFLT_CACHE_RETRIES_COUNT = 100;
    public static final int MAX_RETRIES = IgniteSystemProperties.getInteger("IGNITE_CACHE_RETRIES_COUNT", 100);
    private static final IgniteProductVersion PRELOAD_PARTITION_SINCE = IgniteProductVersion.fromString("2.7.0");
    private static final ThreadLocal<IgniteBiTuple<String, String>> stash = ThreadLocal.withInitial(() -> new IgniteBiTuple());
    private static final IgniteClosure RET2VAL = new CX1<IgniteInternalFuture<GridCacheReturn>, Object>(){

        @Override
        @Nullable
        public Object applyx(IgniteInternalFuture<GridCacheReturn> fut) throws IgniteCheckedException {
            return fut.get().value();
        }

        public String toString() {
            return "Cache return value to value converter.";
        }
    };
    protected static final IgniteClosure RET2NULL = new CX1<IgniteInternalFuture<GridCacheReturn>, Object>(){

        @Override
        @Nullable
        public Object applyx(IgniteInternalFuture<GridCacheReturn> fut) throws IgniteCheckedException {
            fut.get();
            return null;
        }

        public String toString() {
            return "Cache return value to null converter.";
        }
    };
    private static final IgniteClosure RET2FLAG = new CX1<IgniteInternalFuture<GridCacheReturn>, Boolean>(){

        @Override
        public Boolean applyx(IgniteInternalFuture<GridCacheReturn> fut) throws IgniteCheckedException {
            return fut.get().success();
        }

        public String toString() {
            return "Cache return value to boolean flag converter.";
        }
    };
    protected ThreadLocal<FutureHolder> lastFut = ThreadLocal.withInitial(() -> new FutureHolder());
    @GridToStringExclude
    protected GridCacheContext<K, V> ctx;
    @GridToStringExclude
    protected GridCacheConcurrentMap map;
    @GridToStringExclude
    protected UUID locNodeId;
    @GridToStringExclude
    protected CacheConfiguration cacheCfg;
    protected CacheMetricsImpl metrics;
    private CacheMetricsMXBean locMxBean;
    private CacheMetricsMXBean clusterMxBean;
    protected IgniteLogger log;
    protected IgniteLogger txLockMsgLog;
    private Affinity<K> aff;
    private Semaphore asyncOpsSem;
    private volatile boolean partPreloadBadVerWarned;
    private volatile boolean active;

    @Override
    public String name() {
        return this.cacheCfg.getName();
    }

    protected GridCacheAdapter() {
    }

    protected GridCacheAdapter(GridCacheContext<K, V> ctx) {
        this(ctx, null);
    }

    protected GridCacheAdapter(GridCacheContext<K, V> ctx, @Nullable GridCacheConcurrentMap map) {
        assert (ctx != null);
        this.ctx = ctx;
        this.cacheCfg = ctx.config();
        this.locNodeId = ctx.gridConfig().getNodeId();
        this.map = map;
        this.log = ctx.logger(this.getClass());
        this.txLockMsgLog = ctx.shared().txLockMessageLogger();
        this.metrics = new CacheMetricsImpl(ctx, this.isNear());
        this.locMxBean = new CacheLocalMetricsMXBeanImpl(this);
        this.clusterMxBean = new CacheClusterMetricsMXBeanImpl(this);
        if (ctx.config().getMaxConcurrentAsyncOperations() > 0) {
            this.asyncOpsSem = new Semaphore(ctx.config().getMaxConcurrentAsyncOperations());
        }
        this.init();
        this.aff = new GridCacheAffinityImpl<K, V>(ctx);
    }

    public void printMemoryStats() {
        if (this.ctx.isNear()) {
            X.println(">>>  Near cache size: " + this.size(), new Object[0]);
            this.ctx.near().dht().printMemoryStats();
        } else if (this.ctx.isDht()) {
            X.println(">>>  DHT cache size: " + this.size(), new Object[0]);
        } else {
            X.println(">>>  Cache size: " + this.size(), new Object[0]);
        }
    }

    public GridCacheConcurrentMap map() {
        return this.map;
    }

    public void incrementSize(GridCacheMapEntry e) {
        this.map.incrementPublicSize(null, e);
    }

    public void decrementSize(GridCacheMapEntry e) {
        this.map.decrementPublicSize(null, e);
    }

    @Override
    public GridCacheContext<K, V> context() {
        return this.ctx;
    }

    protected IgniteLogger log() {
        return this.log;
    }

    public boolean isNear() {
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isColocated() {
        return false;
    }

    public boolean isDhtAtomic() {
        return false;
    }

    public boolean isDht() {
        return false;
    }

    public boolean active() {
        return this.active;
    }

    public void active(boolean active) {
        this.active = active;
    }

    public abstract GridCachePreloader preloader();

    @Override
    public final Affinity<K> affinity() {
        return this.aff;
    }

    @Override
    public final <K1, V1> IgniteInternalCache<K1, V1> cache() {
        return this;
    }

    @Override
    public final GridCacheProxyImpl<K, V> forSubjectId(UUID subjId) {
        CacheOperationContext opCtx = new CacheOperationContext(false, subjId, false, null, false, null, false, CacheOperationContext.defaultAllowAtomicOpsInTx());
        return new GridCacheProxyImpl<K, V>(this.ctx, this, opCtx);
    }

    @Override
    public final boolean skipStore() {
        return false;
    }

    @Override
    public final GridCacheProxyImpl<K, V> setSkipStore(boolean skipStore) {
        CacheOperationContext opCtx = new CacheOperationContext(true, null, false, null, false, null, false, CacheOperationContext.defaultAllowAtomicOpsInTx());
        return new GridCacheProxyImpl<K, V>(this.ctx, this, opCtx);
    }

    @Override
    public final <K1, V1> GridCacheProxyImpl<K1, V1> keepBinary() {
        CacheOperationContext opCtx = new CacheOperationContext(false, null, true, null, false, null, false, CacheOperationContext.defaultAllowAtomicOpsInTx());
        return new GridCacheProxyImpl<K, V>(this.ctx, this, opCtx);
    }

    @Override
    @Nullable
    public final ExpiryPolicy expiry() {
        return null;
    }

    @Override
    public final GridCacheProxyImpl<K, V> withExpiryPolicy(ExpiryPolicy plc) {
        assert (!CU.isUtilityCache(this.ctx.name()));
        CacheOperationContext opCtx = new CacheOperationContext(false, null, false, plc, false, null, false, CacheOperationContext.defaultAllowAtomicOpsInTx());
        return new GridCacheProxyImpl<K, V>(this.ctx, this, opCtx);
    }

    @Override
    public final IgniteInternalCache<K, V> withNoRetries() {
        CacheOperationContext opCtx = new CacheOperationContext(false, null, false, null, true, null, false, CacheOperationContext.defaultAllowAtomicOpsInTx());
        return new GridCacheProxyImpl<K, V>(this.ctx, this, opCtx);
    }

    @Override
    public final IgniteInternalCache<K, V> withAllowAtomicOpsInTx() {
        CacheOperationContext opCtx = new CacheOperationContext(false, null, false, null, false, null, false, CacheOperationContext.defaultAllowAtomicOpsInTx());
        return new GridCacheProxyImpl<K, V>(this.ctx, this, opCtx);
    }

    @Override
    public final CacheConfiguration configuration() {
        return this.ctx.config();
    }

    public abstract IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> var1, long var2, IgniteTxLocalEx var4, boolean var5, boolean var6, TransactionIsolation var7, boolean var8, long var9, long var11);

    protected void init() {
    }

    public abstract void start() throws IgniteCheckedException;

    protected final String startInfo() {
        return "Cache started: " + U.maskName(this.ctx.config().getName());
    }

    public void stop() {
        this.lastFut = null;
    }

    public void removeMetrics() {
        if (!this.ctx.kernalContext().isStopping()) {
            this.ctx.kernalContext().metric().remove(MetricUtils.cacheMetricsRegistryName(this.ctx.name(), this.isNear()));
        }
    }

    protected final String stopInfo() {
        return "Cache stopped: " + U.maskName(this.ctx.config().getName());
    }

    public void onKernalStart() throws IgniteCheckedException {
    }

    public void onKernalStop() {
    }

    @Override
    public final boolean isEmpty() {
        try {
            return this.localSize(null) == 0;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public final boolean containsKey(K key) {
        try {
            return this.containsKeyAsync(key).get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public final IgniteInternalFuture<Boolean> containsKeyAsync(K key) {
        A.notNull(key, "key");
        return this.getAsync(key, false, null, null, false, true, false, false);
    }

    @Override
    public final boolean containsKeys(Collection<? extends K> keys) {
        try {
            return this.containsKeysAsync(keys).get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public final IgniteInternalFuture<Boolean> containsKeysAsync(final Collection<? extends K> keys) {
        A.notNull(keys, "keys");
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.getAllAsync(keys, false, false, null, null, false, opCtx != null && opCtx.recovery(), true, false).chain(new CX1<IgniteInternalFuture<Map<K, V>>, Boolean>(){

            @Override
            public Boolean applyx(IgniteInternalFuture<Map<K, V>> fut) throws IgniteCheckedException {
                Map kvMap = fut.get();
                if (keys.size() != kvMap.size()) {
                    return false;
                }
                for (Map.Entry entry : kvMap.entrySet()) {
                    if (entry.getValue() != null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public final Iterable<Cache.Entry<K, V>> localEntries(CachePeekMode[] peekModes) throws IgniteCheckedException {
        assert (peekModes != null);
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        PeekModes modes = GridCacheAdapter.parsePeekModes(peekModes, false);
        ArrayList its = new ArrayList();
        boolean keepBinary = this.ctx.keepBinary();
        if (this.ctx.isLocal()) {
            modes.primary = true;
            modes.backup = true;
        }
        if (modes.offheap) {
            if (modes.heap && modes.near && this.ctx.isNear()) {
                its.add(this.ctx.near().nearEntries().iterator());
            }
            if (modes.primary || modes.backup) {
                AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
                IgniteCacheOffheapManager offheapMgr = this.ctx.isNear() ? this.ctx.near().dht().context().offheap() : this.ctx.offheap();
                MvccSnapshot mvccSnapshot = this.ctx.mvccEnabled() ? MvccUtils.MVCC_MAX_SNAPSHOT : null;
                its.add(offheapMgr.cacheEntriesIterator(this.ctx, modes.primary, modes.backup, topVer, this.ctx.keepBinary(), mvccSnapshot, null));
            }
        } else if (modes.heap) {
            if (this.ctx.mvccEnabled()) {
                return F.emptyIterator();
            }
            if (modes.near && this.ctx.isNear()) {
                its.add(this.ctx.near().nearEntries().iterator());
            }
            if (modes.primary || modes.backup) {
                GridDhtCacheAdapter<K, V> cache = this.ctx.isNear() ? this.ctx.near().dht() : this.ctx.dht();
                its.add(cache.localEntriesIterator(modes.primary, modes.backup, keepBinary));
            }
        }
        final Iterator it = F.flatIterators(its);
        return new Iterable<Cache.Entry<K, V>>(){

            @Override
            public Iterator<Cache.Entry<K, V>> iterator() {
                return it;
            }

            public String toString() {
                return "CacheLocalEntries []";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V localPeek(K key, CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheObject cacheVal;
        block23: {
            A.notNull(key, "key");
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            PeekModes modes = GridCacheAdapter.parsePeekModes(peekModes, false);
            KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
            cacheVal = null;
            if (!this.ctx.isLocal()) {
                boolean nearKey;
                AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
                int part = this.ctx.affinity().partition(cacheKey);
                if (!(modes.near && modes.primary && modes.backup)) {
                    boolean keyPrimary = this.ctx.affinity().primaryByPartition(this.ctx.localNode(), part, topVer);
                    if (keyPrimary) {
                        if (!modes.primary) {
                            return null;
                        }
                        nearKey = false;
                    } else {
                        boolean keyBackup = this.ctx.affinity().partitionBelongs(this.ctx.localNode(), part, topVer);
                        if (keyBackup) {
                            if (!modes.backup) {
                                return null;
                            }
                            nearKey = false;
                        } else {
                            if (!modes.near) {
                                return null;
                            }
                            nearKey = true;
                            modes.offheap = false;
                        }
                    }
                } else {
                    boolean bl = nearKey = !this.ctx.affinity().partitionBelongs(this.ctx.localNode(), part, topVer);
                    if (nearKey) {
                        modes.offheap = false;
                    }
                }
                if (nearKey && !this.ctx.isNear()) {
                    return null;
                }
                while (true) {
                    GridCacheEntryEx e;
                    if (nearKey) {
                        e = this.peekEx(key);
                    } else {
                        GridCacheContext<K, V> ctx0 = this.ctx.isNear() ? this.ctx.near().dht().context() : this.ctx;
                        GridCacheEntryEx gridCacheEntryEx = e = modes.offheap ? ctx0.cache().entryEx(key) : ctx0.cache().peekEx(key);
                    }
                    if (e == null) break block23;
                    this.ctx.shared().database().checkpointReadLock();
                    try {
                        cacheVal = this.ctx.mvccEnabled() ? e.mvccPeek(modes.heap && !modes.offheap) : e.peek(modes.heap, modes.offheap, topVer, null);
                        break block23;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Got removed entry during 'peek': " + key);
                        continue;
                    }
                    finally {
                        e.touch();
                        this.ctx.shared().database().checkpointReadUnlock();
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    cacheVal = this.localCachePeek0(cacheKey, modes.heap, modes.offheap);
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Got removed entry during 'peek': " + key);
                    continue;
                }
                break;
            }
        }
        Object val = this.ctx.unwrapBinaryIfNeeded(cacheVal, this.ctx.keepBinary(), false, null);
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CacheObject localCachePeek0(KeyCacheObject key, boolean heap, boolean offheap) throws GridCacheEntryRemovedException, IgniteCheckedException {
        GridCacheEntryEx e;
        assert (this.ctx.isLocal());
        assert (heap || offheap);
        GridCacheEntryEx gridCacheEntryEx = e = offheap ? this.entryEx(key) : this.peekEx(key);
        if (e != null) {
            try {
                CacheObject cacheObject = e.peek(heap, offheap, AffinityTopologyVersion.NONE, null);
                return cacheObject;
            }
            finally {
                e.touch();
            }
        }
        return null;
    }

    public final void onUndeploy(ClassLoader ldr) {
        this.ctx.deploy().onUndeploy(ldr, this.context());
    }

    @Nullable
    public final GridCacheEntryEx peekEx(KeyCacheObject key) {
        return this.entry0(key, this.ctx.affinity().affinityTopologyVersion(), false);
    }

    @Nullable
    public final GridCacheEntryEx peekEx(Object key) {
        return this.entry0(this.ctx.toCacheKeyObject(key), this.ctx.affinity().affinityTopologyVersion(), false);
    }

    public final GridCacheEntryEx entryEx(Object key) {
        return this.entryEx(this.ctx.toCacheKeyObject(key));
    }

    public final GridCacheEntryEx entryEx(KeyCacheObject key) {
        return this.entryEx(key, this.ctx.affinity().affinityTopologyVersion());
    }

    public GridCacheEntryEx entryEx(KeyCacheObject key, AffinityTopologyVersion topVer) {
        GridCacheMapEntry e = this.map.putEntryIfObsoleteOrAbsent(this.ctx, topVer, key, true);
        assert (e != null);
        return e;
    }

    private GridCacheEntryEx entry0(KeyCacheObject key, AffinityTopologyVersion topVer, boolean create) {
        GridCacheMapEntry cur = this.map.getEntry(this.ctx, key);
        if (cur == null || cur.obsolete()) {
            cur = this.map.putEntryIfObsoleteOrAbsent(this.ctx, topVer, key, create);
        }
        return cur;
    }

    public final Iterable<? extends GridCacheEntryEx> entries() {
        return this.allEntries();
    }

    public final Iterable<? extends GridCacheEntryEx> allEntries() {
        return this.map.entries(this.ctx.cacheId(), new CacheEntryPredicate[0]);
    }

    @Override
    public final Set<Cache.Entry<K, V>> entrySet() {
        return this.entrySet(null);
    }

    @Override
    public final Set<K> keySet() {
        return new KeySet(this.map.entrySet(this.ctx.cacheId(), new CacheEntryPredicate[0]));
    }

    public final void removeIfObsolete(KeyCacheObject key) {
        assert (key != null);
        GridCacheMapEntry entry = this.map.getEntry(this.ctx, key);
        if (entry != null && entry.obsolete()) {
            this.removeEntry(entry);
        }
    }

    public List<GridCacheClearAllRunnable<K, V>> splitClearLocally(boolean srv, boolean near, boolean readers) {
        if (this.isNear() && near || !this.isNear() && srv) {
            int keySize = this.size();
            int cnt = Math.min(keySize / 10000 + (keySize % 10000 != 0 ? 1 : 0), Runtime.getRuntime().availableProcessors());
            if (cnt == 0) {
                cnt = 1;
            }
            GridCacheVersion obsoleteVer = this.nextVersion();
            ArrayList<GridCacheClearAllRunnable<K, V>> res = new ArrayList<GridCacheClearAllRunnable<K, V>>(cnt);
            for (int i = 0; i < cnt; ++i) {
                res.add(new GridCacheClearAllRunnable(this, obsoleteVer, i, cnt, readers));
            }
            return res;
        }
        return null;
    }

    @Override
    public boolean clearLocally(K key) {
        return this.clearLocally0(key, false);
    }

    @Override
    public void clearLocallyAll(Set<? extends K> keys, boolean srv, boolean near, boolean readers) {
        if (keys != null && (this.isNear() && near || !this.isNear() && srv)) {
            for (K key : keys) {
                this.clearLocally0(key, readers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocally(boolean srv, boolean near, boolean readers) {
        this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Clear");
        List<GridCacheClearAllRunnable<K, V>> jobs = this.splitClearLocally(srv, near, readers);
        if (!F.isEmpty(jobs)) {
            ExecutorService execSvc = null;
            try {
                if (jobs.size() > 1) {
                    execSvc = Executors.newFixedThreadPool(jobs.size() - 1, new IgniteThreadFactory(this.ctx.igniteInstanceName(), "async-cache-cleaner"));
                    for (int i = 1; i < jobs.size(); ++i) {
                        execSvc.execute(jobs.get(i));
                    }
                }
                jobs.get(0).run();
            }
            finally {
                if (execSvc != null) {
                    execSvc.shutdown();
                    try {
                        while (!execSvc.isTerminated() && !Thread.currentThread().isInterrupted()) {
                            execSvc.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException ignore) {
                        U.warn(this.log, "Got interrupted while waiting for Cache.clearLocally() executor service to finish.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    @Override
    public void clear() throws IgniteCheckedException {
        this.clear((Set)null);
    }

    @Override
    public void clear(K key) throws IgniteCheckedException {
        this.clear(Collections.singleton(key));
    }

    @Override
    public void clearAll(Set<? extends K> keys) throws IgniteCheckedException {
        this.clear(keys);
    }

    @Override
    public IgniteInternalFuture<?> clearAsync() {
        return this.clearAsync((Set)null);
    }

    @Override
    public IgniteInternalFuture<?> clearAsync(K key) {
        return this.clearAsync(Collections.singleton(key));
    }

    @Override
    public IgniteInternalFuture<?> clearAllAsync(Set<? extends K> keys) {
        return this.clearAsync(keys);
    }

    @Override
    private void clear(@Nullable Set<? extends K> keys) throws IgniteCheckedException {
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Clear");
        this.ctx.shared().cache().checkReadOnlyState("clear", this.ctx.config());
        if (this.isLocal()) {
            if (keys == null) {
                this.clearLocally(true, false, false);
            } else {
                this.clearLocallyAll(keys, true, false, false);
            }
        } else {
            this.executeClearTask(keys, false).get();
            this.executeClearTask(keys, true).get();
        }
    }

    @Override
    private IgniteInternalFuture<?> clearAsync(@Nullable Set<? extends K> keys) {
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Clear");
        this.ctx.shared().cache().checkReadOnlyState("clear", this.ctx.config());
        if (this.isLocal()) {
            return this.clearLocallyAsync(keys);
        }
        return this.executeClearTask(keys, false).chainCompose(fut -> this.executeClearTask(keys, true));
    }

    private IgniteInternalFuture<?> clearLocallyAsync(final @Nullable Set<? extends K> keys) {
        return this.ctx.closures().callLocalSafe(new GridPlainCallable<Object>(){

            @Override
            public Object call() {
                if (keys == null) {
                    GridCacheAdapter.this.clearLocally(true, false, false);
                } else {
                    GridCacheAdapter.this.clearLocallyAll(keys, true, false, false);
                }
                return null;
            }
        }, false);
    }

    private IgniteInternalFuture<?> executeClearTask(@Nullable Set<? extends K> keys, boolean near) {
        Collection<ClusterNode> srvNodes = this.ctx.grid().cluster().forCacheNodes(this.name(), !near, near, false).nodes();
        if (!srvNodes.isEmpty()) {
            this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, srvNodes);
            return this.ctx.kernalContext().task().execute(new ClearTask<K>(this.ctx.name(), this.ctx.affinity().affinityTopologyVersion(), keys, near), null);
        }
        return new GridFinishedFuture();
    }

    private IgniteInternalFuture<?> executePreloadTask(int part) throws IgniteCheckedException {
        ClusterGroup grp = this.ctx.grid().cluster().forDataNodes(this.ctx.name());
        @Nullable ClusterNode targetNode = this.ctx.affinity().primaryByPartition(part, this.ctx.topology().readyTopologyVersion());
        if (targetNode == null || targetNode.version().compareTo(PRELOAD_PARTITION_SINCE) < 0) {
            if (!this.partPreloadBadVerWarned) {
                U.warn(this.log(), "Attempting to execute partition preloading task on outdated or not mapped node [targetNodeVer=" + (targetNode == null ? "NA" : targetNode.version()) + ", minSupportedNodeVer=" + PRELOAD_PARTITION_SINCE + ']');
                this.partPreloadBadVerWarned = true;
            }
            return new GridFinishedFuture();
        }
        return this.ctx.closures().affinityRun(Collections.singleton(this.name()), part, new PartitionPreloadJob(this.ctx.name(), part), grp.nodes(), null);
    }

    public void clearLocally(Collection<KeyCacheObject> keys, boolean readers) {
        if (F.isEmpty(keys)) {
            return;
        }
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Clear");
        GridCacheVersion obsoleteVer = this.ctx.versions().startVersion();
        for (KeyCacheObject key : keys) {
            GridCacheEntryEx e = this.peekEx(key);
            try {
                if (e == null) continue;
                e.clear(obsoleteVer, readers);
            }
            catch (IgniteCheckedException ex) {
                U.error(this.log, "Failed to clearLocally entry (will continue to clearLocally other entries): " + e, ex);
            }
        }
    }

    public final void removeEntry(GridCacheEntryEx entry) {
        boolean rmvd = this.map.removeEntry(entry);
        if (this.log.isDebugEnabled()) {
            if (rmvd) {
                this.log.debug("Removed entry from cache: " + entry);
            } else {
                this.log.debug("Remove will not be done for key (entry got replaced or removed): " + entry.key());
            }
        }
    }

    private boolean evictx(K key, GridCacheVersion ver, @Nullable CacheEntryPredicate[] filter) {
        KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
        GridCacheEntryEx entry = this.peekEx(cacheKey);
        if (entry == null) {
            return true;
        }
        try {
            return this.ctx.evicts().evict(entry, ver, true, filter);
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to evict entry from cache: " + entry, ex);
            return false;
        }
    }

    @Override
    public Collection<Integer> lostPartitions() {
        if (this.isLocal()) {
            return Collections.emptyList();
        }
        return this.ctx.topology().lostPartitions();
    }

    @Override
    public final V getForcePrimary(K key) throws IgniteCheckedException {
        return this.getForcePrimaryAsync(key).get();
    }

    @Override
    public final IgniteInternalFuture<V> getForcePrimaryAsync(final K key) {
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.getAllAsync(Collections.singletonList(key), true, false, null, taskName, true, opCtx != null && opCtx.recovery(), false, false).chain(new CX1<IgniteInternalFuture<Map<K, V>>, V>(){

            @Override
            public V applyx(IgniteInternalFuture<Map<K, V>> e) throws IgniteCheckedException {
                return e.get().get(key);
            }
        });
    }

    @Override
    @Nullable
    public final Map<K, V> getAllOutTx(Set<? extends K> keys) throws IgniteCheckedException {
        return this.getAllOutTxAsync(keys).get();
    }

    @Override
    public final IgniteInternalFuture<Map<K, V>> getAllOutTxAsync(Set<? extends K> keys) {
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.getAllAsync(keys, false, true, null, taskName, opCtx == null || !opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), false, false);
    }

    @Override
    @Nullable
    public V get(K key) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_GET, MTC.span()));){
            Object rawKey = key;
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_GET, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addSensitiveTagOrLog("key", SpanType.CACHE_API_GET, () -> Objects.toString(rawKey));
            A.notNull(key, "key");
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            boolean keepBinary = this.ctx.keepBinary();
            if (keepBinary) {
                key = this.ctx.toCacheKeyObject(key);
            }
            V val = this.get(key, !keepBinary, false);
            if (this.ctx.config().getInterceptor() != null) {
                key = keepBinary ? this.ctx.unwrapBinaryIfNeeded(key, true, false, null) : key;
                val = this.ctx.config().getInterceptor().onGet(key, val);
            }
            if (statsEnabled) {
                this.metrics0().addGetTimeNanos(System.nanoTime() - start);
            }
            V v = val;
            return v;
        }
    }

    @Override
    @Nullable
    public CacheEntry<K, V> getEntry(K key) throws IgniteCheckedException {
        CacheEntryImplEx<K, Object> val;
        EntryGetResult t;
        A.notNull(key, "key");
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        boolean keepBinary = this.ctx.keepBinary();
        if (keepBinary) {
            key = this.ctx.toCacheKeyObject(key);
        }
        CacheEntryImplEx<K, Object> cacheEntryImplEx = (t = (EntryGetResult)this.get(key, !keepBinary, true)) != null ? new CacheEntryImplEx<K, Object>(keepBinary ? this.ctx.unwrapBinaryIfNeeded(key, true, false, null) : key, t.value(), t.version()) : (val = null);
        if (this.ctx.config().getInterceptor() != null) {
            key = keepBinary ? this.ctx.unwrapBinaryIfNeeded(key, true, false, null) : key;
            Object val0 = this.ctx.config().getInterceptor().onGet(key, t != null ? (Object)val.getValue() : null);
            CacheEntryImplEx<K, Object> cacheEntryImplEx2 = val0 != null ? new CacheEntryImplEx<K, Object>(key, val0, t != null ? t.version() : null) : (val = null);
        }
        if (statsEnabled) {
            this.metrics0().addGetTimeNanos(System.nanoTime() - start);
        }
        return val;
    }

    @Override
    public IgniteInternalFuture<V> getAsync(K key) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_GET_ASYNC, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_GET_ASYNC, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addSensitiveTagOrLog("key", SpanType.CACHE_API_GET_ASYNC, () -> Objects.toString(key));
            A.notNull(key, "key");
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            final boolean keepBinary = this.ctx.keepBinary();
            final Object key0 = keepBinary ? this.ctx.toCacheKeyObject(key) : key;
            IgniteInternalFuture<Object> fut = null;
            try {
                this.checkJta();
            }
            catch (IgniteCheckedException e) {
                fut = new GridFinishedFuture(e);
            }
            if (fut == null) {
                String taskName = this.ctx.kernalContext().job().currentTaskName();
                fut = this.getAsync(key, false, null, taskName, !keepBinary, false, false, false);
            }
            if (this.ctx.config().getInterceptor() != null) {
                fut = fut.chain(new CX1<IgniteInternalFuture<V>, V>(){

                    @Override
                    public V applyx(IgniteInternalFuture<V> f) throws IgniteCheckedException {
                        Object key = keepBinary ? GridCacheAdapter.this.ctx.unwrapBinaryIfNeeded(key0, true, false, null) : key0;
                        return GridCacheAdapter.this.ctx.config().getInterceptor().onGet(key, f.get());
                    }
                });
            }
            if (statsEnabled) {
                fut.listen(new UpdateGetTimeStatClosure(this.metrics0(), start));
            }
            GridFinishedFuture gridFinishedFuture = fut;
            return gridFinishedFuture;
        }
    }

    @Override
    public IgniteInternalFuture<CacheEntry<K, V>> getEntryAsync(K key) {
        A.notNull(key, "key");
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        final boolean keepBinary = this.ctx.keepBinary();
        final K key0 = keepBinary ? this.ctx.toCacheKeyObject(key) : key;
        IgniteInternalFuture<Object> fut = null;
        try {
            this.checkJta();
        }
        catch (IgniteCheckedException e) {
            fut = new GridFinishedFuture(e);
        }
        if (fut == null) {
            String taskName = this.ctx.kernalContext().job().currentTaskName();
            fut = this.getAsync(key0, false, null, taskName, !keepBinary, false, true, false);
        }
        final boolean intercept = this.ctx.config().getInterceptor() != null;
        IgniteInternalFuture<CacheEntry<K, V>> fr = fut.chain(new CX1<IgniteInternalFuture<EntryGetResult>, CacheEntry<K, V>>(){

            @Override
            public CacheEntry<K, V> applyx(IgniteInternalFuture<EntryGetResult> f) throws IgniteCheckedException {
                CacheEntryImplEx val;
                EntryGetResult t = f.get();
                Object key = keepBinary ? GridCacheAdapter.this.ctx.unwrapBinaryIfNeeded(key0, true, false, null) : key0;
                CacheEntryImplEx cacheEntryImplEx = val = t != null ? new CacheEntryImplEx(key, t.value(), t.version()) : null;
                if (intercept) {
                    Object val0 = GridCacheAdapter.this.ctx.config().getInterceptor().onGet(key, t != null ? (Object)val.getValue() : null);
                    return val0 != null ? new CacheEntryImplEx<Object, Object>(key, val0, t != null ? t.version() : null) : null;
                }
                return val;
            }
        });
        if (statsEnabled) {
            fut.listen(new UpdateGetTimeStatClosure(this.metrics0(), start));
        }
        return fr;
    }

    @Override
    public final Map<K, V> getAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_GET_ALL, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_GET_ALL, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addTagOrLog("keys.count", SpanType.CACHE_API_GET_ALL, () -> keys == null ? "0" : String.valueOf(keys.size()));
            A.notNull(keys, "keys");
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            Map<? extends K, V> map = this.getAll0(keys, !this.ctx.keepBinary(), false);
            if (this.ctx.config().getInterceptor() != null) {
                map = this.interceptGet(keys, map);
            }
            if (statsEnabled) {
                this.metrics0().addGetTimeNanos(System.nanoTime() - start);
            }
            Map<? extends K, V> map2 = map;
            return map2;
        }
    }

    @Override
    public Collection<CacheEntry<K, V>> getEntries(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        A.notNull(keys, "keys");
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        Map<K, V> map = this.getAll0(keys, !this.ctx.keepBinary(), true);
        HashSet<CacheEntry<K, V>> res = new HashSet();
        if (this.ctx.config().getInterceptor() != null) {
            res = this.interceptGetEntries(keys, map);
        } else {
            for (Map.Entry<K, V> e : map.entrySet()) {
                res.add(new CacheEntryImplEx(e.getKey(), ((EntryGetResult)e.getValue()).value(), ((EntryGetResult)e.getValue()).version()));
            }
        }
        if (statsEnabled) {
            this.metrics0().addGetTimeNanos(System.nanoTime() - start);
        }
        return res;
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(final @Nullable Collection<? extends K> keys) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_GET_ALL_ASYNC, MTC.span()));){
            MTC.span().addTag("cache", () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addTag("keys.count", () -> keys == null ? "0" : String.valueOf(keys.size()));
            A.notNull(keys, "keys");
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            String taskName = this.ctx.kernalContext().job().currentTaskName();
            CacheOperationContext opCtx = this.ctx.operationContextPerCall();
            IgniteInternalFuture<Map<K, V>> fut = this.getAllAsync(keys, false, false, opCtx != null ? opCtx.subjectId() : null, taskName, opCtx == null || !opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), false, false);
            if (this.ctx.config().getInterceptor() != null) {
                IgniteInternalFuture<Map<K, V>> igniteInternalFuture = fut.chain(new CX1<IgniteInternalFuture<Map<K, V>>, Map<K, V>>(){

                    @Override
                    public Map<K, V> applyx(IgniteInternalFuture<Map<K, V>> f) throws IgniteCheckedException {
                        return GridCacheAdapter.this.interceptGet(keys, f.get());
                    }
                });
                return igniteInternalFuture;
            }
            if (statsEnabled) {
                fut.listen(new UpdateGetTimeStatClosure(this.metrics0(), start));
            }
            IgniteInternalFuture<Map<K, V>> igniteInternalFuture = fut;
            return igniteInternalFuture;
        }
    }

    @Override
    public IgniteInternalFuture<Collection<CacheEntry<K, V>>> getEntriesAsync(final @Nullable Collection<? extends K> keys) {
        A.notNull(keys, "keys");
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        IgniteInternalFuture<Map<K, V>> fut = this.getAllAsync(keys, false, false, opCtx != null ? opCtx.subjectId() : null, taskName, opCtx == null || !opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), false, true);
        final boolean intercept = this.ctx.config().getInterceptor() != null;
        IgniteInternalFuture<Collection<CacheEntry<K, V>>> rf = fut.chain(new CX1<IgniteInternalFuture<Map<K, EntryGetResult>>, Collection<CacheEntry<K, V>>>(){

            @Override
            public Collection<CacheEntry<K, V>> applyx(IgniteInternalFuture<Map<K, EntryGetResult>> f) throws IgniteCheckedException {
                if (intercept) {
                    return GridCacheAdapter.this.interceptGetEntries(keys, f.get());
                }
                HashMap res = U.newHashMap(f.get().size());
                for (Map.Entry e : f.get().entrySet()) {
                    res.put(e.getKey(), new CacheEntryImplEx(e.getKey(), e.getValue().value(), e.getValue().version()));
                }
                return res.values();
            }
        });
        if (statsEnabled) {
            fut.listen(new UpdateGetTimeStatClosure(this.metrics0(), start));
        }
        return rf;
    }

    private Map<K, V> interceptGet(@Nullable Collection<? extends K> keys, Map<K, V> map) {
        Object val;
        if (F.isEmpty(keys)) {
            return map;
        }
        CacheInterceptor<K, V> interceptor = this.cacheCfg.getInterceptor();
        assert (interceptor != null);
        HashMap res = U.newHashMap(keys.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            val = interceptor.onGet(e.getKey(), e.getValue());
            if (val == null) continue;
            res.put(e.getKey(), val);
        }
        if (map.size() != keys.size()) {
            for (Map.Entry<K, V> key : keys) {
                if (key == null || map.containsKey(key) || (val = interceptor.onGet(key, null)) == null) continue;
                res.put(key, val);
            }
        }
        return res;
    }

    private Collection<CacheEntry<K, V>> interceptGetEntries(@Nullable Collection<? extends K> keys, Map<K, EntryGetResult> map) {
        Object val;
        if (F.isEmpty(keys)) {
            assert (map.isEmpty());
            return Collections.emptySet();
        }
        HashMap res = U.newHashMap(keys.size());
        CacheInterceptor interceptor = this.cacheCfg.getInterceptor();
        assert (interceptor != null);
        for (Map.Entry<K, EntryGetResult> e : map.entrySet()) {
            val = interceptor.onGet(e.getKey(), e.getValue().value());
            if (val == null) continue;
            res.put(e.getKey(), new CacheEntryImplEx(e.getKey(), val, e.getValue().version()));
        }
        if (map.size() != keys.size()) {
            for (Map.Entry<K, EntryGetResult> key : keys) {
                if (key == null || map.containsKey(key) || (val = interceptor.onGet(key, null)) == null) continue;
                res.put(key, new CacheEntryImplEx(key, val, null));
            }
        }
        return res.values();
    }

    protected IgniteInternalFuture<V> getAsync(K key, boolean skipTx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, final boolean skipVals, boolean needVer, boolean touchTtl) {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.getAllAsync(Collections.singletonList(key), false, skipTx, subjId, taskName, deserializeBinary, opCtx != null && opCtx.recovery(), skipVals, needVer).chain(new CX1<IgniteInternalFuture<Map<K, V>>, V>(){

            @Override
            public V applyx(IgniteInternalFuture<Map<K, V>> e) throws IgniteCheckedException {
                Map map = e.get();
                assert (map.isEmpty() || map.size() == 1) : map.size();
                if (skipVals) {
                    Boolean val = map.isEmpty() ? false : (Boolean)F.firstValue(map);
                    return val;
                }
                return F.firstValue(map);
            }
        });
    }

    protected abstract IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> var1, boolean var2, boolean var3, @Nullable UUID var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9);

    protected GridNearTxLocal checkCurrentTx() {
        if (!this.ctx.mvccEnabled()) {
            return this.ctx.tm().threadLocalTx(this.ctx);
        }
        return MvccUtils.tx(this.ctx.kernalContext(), null);
    }

    protected void clearReservationsIfNeeded(Map<KeyCacheObject, EntryGetResult> loadKeys, Collection<KeyCacheObject> loaded, IgniteTxLocalAdapter tx0) {
        if (loaded.size() != loadKeys.size()) {
            boolean needTouch = tx0 == null || !tx0.implicit() && tx0.isolation() == TransactionIsolation.READ_COMMITTED;
            for (Map.Entry<KeyCacheObject, EntryGetResult> e : loadKeys.entrySet()) {
                GridCacheEntryEx entry;
                if (loaded.contains(e.getKey()) || !needTouch && !e.getValue().reserved() || (entry = this.peekEx(e.getKey())) == null) continue;
                if (e.getValue().reserved()) {
                    entry.clearReserveForLoad(e.getValue().version());
                }
                if (!needTouch) continue;
                entry.touch();
            }
        }
    }

    @Override
    public final V getAndPut(K key, V val) throws IgniteCheckedException {
        return this.getAndPut(key, val, null);
    }

    @Nullable
    public V getAndPut(K key, V val, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        A.notNull(key, "key", val, "val");
        V prevVal = this.getAndPut0(key, val, filter);
        if (statsEnabled) {
            this.metrics0().addPutAndGetTimeNanos(System.nanoTime() - start);
        }
        return prevVal;
    }

    protected V getAndPut0(final K key, final V val, final @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        return (V)this.syncOp(new SyncOp<V>(true){

            @Override
            public V op(GridNearTxLocal tx) throws IgniteCheckedException {
                return tx.putAsync(GridCacheAdapter.this.ctx, null, key, val, true, filter).get().value();
            }

            public String toString() {
                return S.toString("put", "key", key, true, "val", val, true, "filter", (Object)filter, false);
            }
        });
    }

    @Override
    public final IgniteInternalFuture<V> getAndPutAsync(K key, V val) {
        return this.getAndPutAsync(key, val, null);
    }

    protected final IgniteInternalFuture<V> getAndPutAsync(K key, V val, @Nullable CacheEntryPredicate filter) {
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        A.notNull(key, "key", val, "val");
        IgniteInternalFuture<V> fut = this.getAndPutAsync0(key, val, filter);
        if (statsEnabled) {
            fut.listen(new UpdatePutAndGetTimeStatClosure(this.metrics0(), start));
        }
        return fut;
    }

    public IgniteInternalFuture<V> getAndPutAsync0(final K key, final V val, final @Nullable CacheEntryPredicate filter) {
        return this.asyncOp(new AsyncOp<V>(){

            @Override
            public IgniteInternalFuture<V> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.putAsync(GridCacheAdapter.this.ctx, readyTopVer, key, val, true, filter).chain(RET2VAL);
            }

            public String toString() {
                return S.toString("putAsync", "key", key, true, "val", val, true, "filter", (Object)filter, false);
            }
        });
    }

    @Override
    public final boolean put(K key, V val) throws IgniteCheckedException {
        return this.put(key, val, null);
    }

    public boolean put(K key, V val, CacheEntryPredicate filter) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_PUT, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_PUT, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addSensitiveTagOrLog("key", SpanType.CACHE_API_PUT, () -> Objects.toString(key));
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            A.notNull(key, "key", val, "val");
            boolean stored = this.put0(key, val, filter);
            if (statsEnabled && stored) {
                this.metrics0().addPutTimeNanos(System.nanoTime() - start);
            }
            boolean bl = stored;
            return bl;
        }
    }

    protected boolean put0(final K key, final V val, final CacheEntryPredicate filter) throws IgniteCheckedException {
        Boolean res = this.syncOp(new SyncOp<Boolean>(true){

            @Override
            public Boolean op(GridNearTxLocal tx) throws IgniteCheckedException {
                return tx.putAsync(GridCacheAdapter.this.ctx, null, key, val, false, filter).get().success();
            }

            public String toString() {
                return S.toString("putx", "key", key, true, "val", val, true, "filter", (Object)filter, false);
            }
        });
        assert (res != null);
        return res;
    }

    @Override
    public void putAllConflict(final Map<KeyCacheObject, GridCacheDrInfo> drMap) throws IgniteCheckedException {
        if (F.isEmpty(drMap)) {
            return;
        }
        this.syncOp(new SyncInOp(drMap.size() == 1){

            @Override
            public void inOp(GridNearTxLocal tx) throws IgniteCheckedException {
                tx.putAllDrAsync(GridCacheAdapter.this.ctx, drMap).get();
            }

            public String toString() {
                return "putAllConflict [drMap=" + drMap + ']';
            }
        });
        this.ctx.dr().onReceiveCacheEntriesReceived(drMap.size());
    }

    @Override
    public IgniteInternalFuture<?> putAllConflictAsync(final Map<KeyCacheObject, GridCacheDrInfo> drMap) throws IgniteCheckedException {
        if (F.isEmpty(drMap)) {
            return new GridFinishedFuture();
        }
        this.ctx.dr().onReceiveCacheEntriesReceived(drMap.size());
        return this.asyncOp(new AsyncOp(drMap.keySet()){

            public IgniteInternalFuture op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.putAllDrAsync(GridCacheAdapter.this.ctx, drMap);
            }

            public String toString() {
                return "putAllConflictAsync [drMap=" + drMap + ']';
            }
        });
    }

    @Override
    @Nullable
    public final <T> EntryProcessorResult<T> invoke(@Nullable AffinityTopologyVersion topVer, K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.invoke0(topVer, key, entryProcessor, args);
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.invoke0(null, key, entryProcessor, args);
    }

    private <T> EntryProcessorResult<T> invoke0(final @Nullable AffinityTopologyVersion topVer, final K key, final EntryProcessor<K, V, T> entryProcessor, final Object ... args) throws IgniteCheckedException {
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        return (EntryProcessorResult)this.syncOp(new SyncOp<EntryProcessorResult<T>>(true){

            @Override
            public EntryProcessorResult<T> op(GridNearTxLocal tx) throws IgniteCheckedException {
                boolean statsEnabled;
                assert (topVer == null || tx.implicit());
                if (topVer != null) {
                    tx.topologyVersion(topVer);
                }
                long start = (statsEnabled = GridCacheAdapter.this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
                IgniteInternalFuture<GridCacheReturn> fut = tx.invokeAsync(GridCacheAdapter.this.ctx, null, key, entryProcessor, args);
                Map resMap = (Map)fut.get().value();
                if (statsEnabled) {
                    GridCacheAdapter.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                CacheInvokeResult res = null;
                if (resMap != null) {
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    res = resMap.isEmpty() ? null : (EntryProcessorResult)resMap.values().iterator().next();
                }
                return res != null ? res : new CacheInvokeResult();
            }
        });
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(final Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, final Object ... args) throws IgniteCheckedException {
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        this.warnIfUnordered(keys, BulkOperation.INVOKE);
        final boolean statsEnabled = this.ctx.statisticsEnabled();
        final long start = statsEnabled ? System.nanoTime() : 0L;
        return (Map)this.syncOp(new SyncOp<Map<K, EntryProcessorResult<T>>>(keys.size() == 1){

            @Override
            public Map<K, EntryProcessorResult<T>> op(GridNearTxLocal tx) throws IgniteCheckedException {
                Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor<K, V, Object>>(){

                    @Override
                    public EntryProcessor apply(K k) {
                        return entryProcessor;
                    }
                }, new IgnitePredicate[0]);
                IgniteInternalFuture<GridCacheReturn> fut = tx.invokeAsync(GridCacheAdapter.this.ctx, null, invokeMap, args);
                Map res = (Map)fut.get().value();
                if (statsEnabled) {
                    GridCacheAdapter.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                return res != null ? res : Collections.emptyMap();
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(final K key, final EntryProcessor<K, V, T> entryProcessor, final Object ... args) throws EntryProcessorException {
        IgniteInternalFuture<T> fut;
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        final boolean statsEnabled = this.ctx.statisticsEnabled();
        final long start = statsEnabled ? System.nanoTime() : 0L;
        IgniteInternalFuture<T> fut0 = fut = this.asyncOp(new AsyncOp(){

            public IgniteInternalFuture op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                Map<Object, EntryProcessor> invokeMap = Collections.singletonMap(key, entryProcessor);
                return tx.invokeAsync(GridCacheAdapter.this.ctx, readyTopVer, invokeMap, args);
            }

            public String toString() {
                return S.toString("invokeAsync", "key", key, true, "entryProcessor", (Object)entryProcessor, false);
            }
        });
        return fut0.chain(new CX1<IgniteInternalFuture<GridCacheReturn>, EntryProcessorResult<T>>(){

            @Override
            public EntryProcessorResult<T> applyx(IgniteInternalFuture<GridCacheReturn> fut) throws IgniteCheckedException {
                Map resMap;
                GridCacheReturn ret = fut.get();
                if (statsEnabled) {
                    GridCacheAdapter.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                if ((resMap = (Map)ret.value()) != null) {
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    return resMap.isEmpty() ? new CacheInvokeResult() : (EntryProcessorResult)resMap.values().iterator().next();
                }
                return new CacheInvokeResult();
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(final Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, final Object ... args) {
        IgniteInternalFuture<T> fut;
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        this.warnIfUnordered(keys, BulkOperation.INVOKE);
        final boolean statsEnabled = this.ctx.statisticsEnabled();
        final long start = statsEnabled ? System.nanoTime() : 0L;
        IgniteInternalFuture<T> fut0 = fut = this.asyncOp(new AsyncOp(keys){

            public IgniteInternalFuture<GridCacheReturn> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor<K, V, Object>>(){

                    @Override
                    public EntryProcessor apply(K k) {
                        return entryProcessor;
                    }
                }, new IgnitePredicate[0]);
                return tx.invokeAsync(GridCacheAdapter.this.ctx, readyTopVer, invokeMap, args);
            }

            public String toString() {
                return S.toString("invokeAllAsync", "keys", (Object)keys, true, "entryProcessor", (Object)entryProcessor, false);
            }
        });
        return fut0.chain(new CX1<IgniteInternalFuture<GridCacheReturn>, Map<K, EntryProcessorResult<T>>>(){

            @Override
            public Map<K, EntryProcessorResult<T>> applyx(IgniteInternalFuture<GridCacheReturn> fut) throws IgniteCheckedException {
                GridCacheReturn ret = fut.get();
                if (statsEnabled) {
                    GridCacheAdapter.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                assert (ret != null);
                return ret.value() != null ? (Map)ret.value() : Collections.emptyMap();
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(final Map<? extends K, ? extends EntryProcessor<K, V, T>> map, final Object ... args) {
        IgniteInternalFuture<T> fut;
        A.notNull(map, "map");
        this.warnIfUnordered(map, BulkOperation.INVOKE);
        final boolean statsEnabled = this.ctx.statisticsEnabled();
        final long start = statsEnabled ? System.nanoTime() : 0L;
        IgniteInternalFuture<T> fut0 = fut = this.asyncOp(new AsyncOp(map.keySet()){

            public IgniteInternalFuture<GridCacheReturn> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.invokeAsync(GridCacheAdapter.this.ctx, readyTopVer, map, args);
            }

            public String toString() {
                return S.toString("invokeAllAsync", "map", (Object)map, true);
            }
        });
        return fut0.chain(new CX1<IgniteInternalFuture<GridCacheReturn>, Map<K, EntryProcessorResult<T>>>(){

            @Override
            public Map<K, EntryProcessorResult<T>> applyx(IgniteInternalFuture<GridCacheReturn> fut) throws IgniteCheckedException {
                GridCacheReturn ret = fut.get();
                if (statsEnabled) {
                    GridCacheAdapter.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                assert (ret != null);
                return ret.value() != null ? (Map)ret.value() : Collections.emptyMap();
            }
        });
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(final Map<? extends K, ? extends EntryProcessor<K, V, T>> map, final Object ... args) throws IgniteCheckedException {
        A.notNull(map, "map");
        this.warnIfUnordered(map, BulkOperation.INVOKE);
        final boolean statsEnabled = this.ctx.statisticsEnabled();
        final long start = statsEnabled ? System.nanoTime() : 0L;
        return (Map)this.syncOp(new SyncOp<Map<K, EntryProcessorResult<T>>>(map.size() == 1){

            @Override
            @Nullable
            public Map<K, EntryProcessorResult<T>> op(GridNearTxLocal tx) throws IgniteCheckedException {
                IgniteInternalFuture<GridCacheReturn> fut = tx.invokeAsync(GridCacheAdapter.this.ctx, null, map, args);
                Map value = (Map)fut.get().value();
                if (statsEnabled) {
                    GridCacheAdapter.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                return value;
            }
        });
    }

    @Override
    public final IgniteInternalFuture<Boolean> putAsync(K key, V val) {
        return this.putAsync(key, val, null);
    }

    public final IgniteInternalFuture<Boolean> putAsync(K key, V val, @Nullable CacheEntryPredicate filter) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_PUT_ASYNC, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_PUT_ASYNC, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addSensitiveTagOrLog("key", SpanType.CACHE_API_PUT_ASYNC, () -> Objects.toString(key));
            A.notNull(key, "key", val, "val");
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            IgniteInternalFuture<Boolean> fut = this.putAsync0(key, val, filter);
            if (statsEnabled) {
                fut.listen(new UpdatePutTimeStatClosure(this.metrics0(), start));
            }
            IgniteInternalFuture<Boolean> igniteInternalFuture = fut;
            return igniteInternalFuture;
        }
    }

    public IgniteInternalFuture<Boolean> putAsync0(final K key, final V val, final @Nullable CacheEntryPredicate filter) {
        return this.asyncOp(new AsyncOp<Boolean>(){

            @Override
            public IgniteInternalFuture<Boolean> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.putAsync(GridCacheAdapter.this.ctx, readyTopVer, key, val, false, filter).chain(RET2FLAG);
            }

            public String toString() {
                return S.toString("putxAsync", "key", key, true, "val", val, true, "filter", (Object)filter, false);
            }
        });
    }

    @Override
    @Nullable
    public final V getAndPutIfAbsent(K key, V val) throws IgniteCheckedException {
        return this.getAndPut(key, val, this.ctx.noVal());
    }

    @Override
    public final IgniteInternalFuture<V> getAndPutIfAbsentAsync(K key, V val) {
        return this.getAndPutAsync(key, val, this.ctx.noVal());
    }

    @Override
    public final boolean putIfAbsent(K key, V val) throws IgniteCheckedException {
        return this.put(key, val, this.ctx.noVal());
    }

    @Override
    public final IgniteInternalFuture<Boolean> putIfAbsentAsync(K key, V val) {
        return this.putAsync(key, val, this.ctx.noVal());
    }

    @Override
    @Nullable
    public final V getAndReplace(K key, V val) throws IgniteCheckedException {
        return this.getAndPut(key, val, this.ctx.hasVal());
    }

    @Override
    public final IgniteInternalFuture<V> getAndReplaceAsync(K key, V val) {
        return this.getAndPutAsync(key, val, this.ctx.hasVal());
    }

    @Override
    public final boolean replace(K key, V val) throws IgniteCheckedException {
        return this.put(key, val, this.ctx.hasVal());
    }

    @Override
    public final IgniteInternalFuture<Boolean> replaceAsync(K key, V val) {
        return this.putAsync(key, val, this.ctx.hasVal());
    }

    @Override
    public final boolean replace(K key, V oldVal, V newVal) throws IgniteCheckedException {
        A.notNull(oldVal, "oldVal");
        return this.put(key, newVal, this.ctx.equalsVal(oldVal));
    }

    @Override
    public IgniteInternalFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) {
        A.notNull(oldVal, "oldVal");
        return this.putAsync(key, newVal, this.ctx.equalsVal(oldVal));
    }

    @Override
    public void putAll(@Nullable Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_PUT_ALL, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_PUT_ALL, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addTagOrLog("keys.count", SpanType.CACHE_API_PUT_ALL, () -> m == null ? "0" : String.valueOf(m.size()));
            A.notNull(m, "map");
            if (F.isEmpty(m)) {
                return;
            }
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            this.warnIfUnordered(m, BulkOperation.PUT);
            this.putAll0(m);
            if (statsEnabled) {
                this.metrics0().addPutTimeNanos(System.nanoTime() - start);
            }
        }
    }

    protected void putAll0(final Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        this.syncOp(new SyncInOp(m.size() == 1){

            @Override
            public void inOp(GridNearTxLocal tx) throws IgniteCheckedException {
                tx.putAllAsync(GridCacheAdapter.this.ctx, null, m, false).get();
            }

            public String toString() {
                return S.toString("putAll", "map", (Object)m, true);
            }
        });
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync(Map<? extends K, ? extends V> m) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_PUT_ALL_ASYNC, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_PUT_ALL_ASYNC, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addTagOrLog("keys.count", SpanType.CACHE_API_PUT_ALL_ASYNC, () -> m == null ? "0" : String.valueOf(m.size()));
            if (F.isEmpty(m)) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                return gridFinishedFuture;
            }
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            this.warnIfUnordered(m, BulkOperation.PUT);
            IgniteInternalFuture<?> fut = this.putAllAsync0(m);
            if (statsEnabled) {
                fut.listen(new UpdatePutTimeStatClosure(this.metrics0(), start));
            }
            IgniteInternalFuture<?> igniteInternalFuture = fut;
            return igniteInternalFuture;
        }
    }

    protected IgniteInternalFuture<?> putAllAsync0(final Map<? extends K, ? extends V> m) {
        return this.asyncOp(new AsyncOp(m.keySet()){

            public IgniteInternalFuture<?> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.putAllAsync(GridCacheAdapter.this.ctx, readyTopVer, m, false).chain(RET2NULL);
            }

            public String toString() {
                return S.toString("putAllAsync", "map", (Object)m, true);
            }
        });
    }

    @Override
    @Nullable
    public V getAndRemove(K key) throws IgniteCheckedException {
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        A.notNull(key, "key");
        V prevVal = this.getAndRemove0(key);
        if (statsEnabled) {
            this.metrics0().addRemoveAndGetTimeNanos(System.nanoTime() - start);
        }
        return prevVal;
    }

    protected V getAndRemove0(final K key) throws IgniteCheckedException {
        final boolean keepBinary = this.ctx.keepBinary();
        return (V)this.syncOp(new SyncOp<V>(true){

            @Override
            public V op(GridNearTxLocal tx) throws IgniteCheckedException {
                Object key0 = keepBinary ? GridCacheAdapter.this.ctx.toCacheKeyObject(key) : key;
                IgniteInternalFuture<GridCacheReturn> fut = tx.removeAllAsync(GridCacheAdapter.this.ctx, null, Collections.singletonList(key0), true, null, false);
                Object ret = fut.get().value();
                if (GridCacheAdapter.this.ctx.config().getInterceptor() != null) {
                    Object key2 = keepBinary ? GridCacheAdapter.this.ctx.unwrapBinaryIfNeeded(key0, true, false, null) : key0;
                    return GridCacheAdapter.this.ctx.config().getInterceptor().onBeforeRemove(new CacheEntryImpl(key2, ret)).get2();
                }
                return ret;
            }

            public String toString() {
                return S.toString("remove", "key", key, true);
            }
        });
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync(K key) {
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        A.notNull(key, "key");
        IgniteInternalFuture<V> fut = this.getAndRemoveAsync0(key);
        if (statsEnabled) {
            fut.listen(new UpdateRemoveTimeStatClosure(this.metrics0(), start));
        }
        return fut;
    }

    protected IgniteInternalFuture<V> getAndRemoveAsync0(final K key) {
        return this.asyncOp(new AsyncOp<V>(){

            @Override
            public IgniteInternalFuture<V> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.removeAllAsync(GridCacheAdapter.this.ctx, readyTopVer, Collections.singletonList(key), true, null, false).chain(RET2VAL);
            }

            public String toString() {
                return S.toString("removeAsync", "key", key, true);
            }
        });
    }

    @Override
    public void removeAll() throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_REMOVE_ALL, MTC.span()));){
            MTC.span().addTag("cache", () -> Objects.toString(this.cacheCfg.getName()));
            assert (this.ctx.isLocal());
            ArrayList<KeyCacheObject> keys = new ArrayList<KeyCacheObject>(Math.min(10000, this.size()));
            do {
                GridIterator<CacheDataRow> it = this.ctx.offheap().cacheIterator(this.ctx.cacheId(), true, true, null, null, null);
                while (it.hasNext() && keys.size() < 10000) {
                    keys.add(((CacheDataRow)it.next()).key());
                }
                this.removeAll(keys);
                keys.clear();
            } while (!this.isEmpty());
        }
    }

    @Override
    public void removeAll(Collection<? extends K> keys) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_REMOVE_ALL, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_REMOVE_ALL, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addTagOrLog("keys.count", SpanType.CACHE_API_REMOVE_ALL, () -> keys == null ? "0" : String.valueOf(keys.size()));
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            A.notNull(keys, "keys");
            if (F.isEmpty(keys)) {
                return;
            }
            this.warnIfUnordered(keys, BulkOperation.REMOVE);
            this.removeAll0(keys);
            if (statsEnabled) {
                this.metrics0().addRemoveTimeNanos(System.nanoTime() - start);
            }
        }
    }

    protected void removeAll0(final Collection<? extends K> keys) throws IgniteCheckedException {
        this.syncOp(new SyncInOp(keys.size() == 1){

            @Override
            public void inOp(GridNearTxLocal tx) throws IgniteCheckedException {
                tx.removeAllAsync(GridCacheAdapter.this.ctx, null, keys, false, null, false).get();
            }

            public String toString() {
                return S.toString("removeAll", "keys", (Object)keys, true);
            }
        });
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync(@Nullable Collection<? extends K> keys) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_REMOVE_ALL_ASYNC, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_REMOVE_ALL_ASYNC, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addTagOrLog("keys.count", SpanType.CACHE_API_REMOVE_ALL_ASYNC, () -> keys == null ? "0" : String.valueOf(keys.size()));
            if (F.isEmpty(keys)) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                return gridFinishedFuture;
            }
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            this.warnIfUnordered(keys, BulkOperation.REMOVE);
            IgniteInternalFuture<Object> fut = this.removeAllAsync0(keys);
            if (statsEnabled) {
                fut.listen(new UpdateRemoveTimeStatClosure(this.metrics0(), start));
            }
            IgniteInternalFuture<Object> igniteInternalFuture = fut;
            return igniteInternalFuture;
        }
    }

    protected IgniteInternalFuture<Object> removeAllAsync0(final Collection<? extends K> keys) {
        return this.asyncOp(new AsyncOp(keys){

            public IgniteInternalFuture<?> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.removeAllAsync(GridCacheAdapter.this.ctx, readyTopVer, keys, false, null, false).chain(RET2NULL);
            }

            public String toString() {
                return S.toString("removeAllAsync", "keys", (Object)keys, true);
            }
        });
    }

    @Override
    public boolean remove(K key) throws IgniteCheckedException {
        return this.remove(key, (V)null);
    }

    @Override
    public boolean remove(K key, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_REMOVE, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_REMOVE, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addSensitiveTagOrLog("key", SpanType.CACHE_API_REMOVE, () -> Objects.toString(key));
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            A.notNull(key, "key");
            boolean rmv = this.remove0(key, filter);
            if (statsEnabled && rmv) {
                this.metrics0().addRemoveTimeNanos(System.nanoTime() - start);
            }
            boolean bl = rmv;
            return bl;
        }
    }

    protected boolean remove0(final K key, final CacheEntryPredicate filter) throws IgniteCheckedException {
        Boolean res = this.syncOp(new SyncOp<Boolean>(true){

            @Override
            public Boolean op(GridNearTxLocal tx) throws IgniteCheckedException {
                return tx.removeAllAsync(GridCacheAdapter.this.ctx, null, Collections.singletonList(key), false, filter, filter == null).get().success();
            }

            public String toString() {
                return S.toString("removex", "key", key, true);
            }
        });
        assert (res != null);
        return res;
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync(K key) {
        A.notNull(key, "key");
        return this.removeAsync(key, (V)null);
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync(K key, @Nullable CacheEntryPredicate filter) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.CACHE_API_REMOVE_ASYNC, MTC.span()));){
            MTC.span().addTagOrLog("cache", SpanType.CACHE_API_REMOVE_ASYNC, () -> Objects.toString(this.cacheCfg.getName()));
            MTC.span().addSensitiveTagOrLog("key", SpanType.CACHE_API_REMOVE_ASYNC, () -> Objects.toString(key));
            boolean statsEnabled = this.ctx.statisticsEnabled();
            long start = statsEnabled ? System.nanoTime() : 0L;
            A.notNull(key, "key");
            IgniteInternalFuture<Boolean> fut = this.removeAsync0(key, filter);
            if (statsEnabled) {
                fut.listen(new UpdateRemoveTimeStatClosure(this.metrics0(), start));
            }
            IgniteInternalFuture<Boolean> igniteInternalFuture = fut;
            return igniteInternalFuture;
        }
    }

    protected IgniteInternalFuture<Boolean> removeAsync0(final K key, final @Nullable CacheEntryPredicate filter) {
        return this.asyncOp(new AsyncOp<Boolean>(){

            @Override
            public IgniteInternalFuture<Boolean> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.removeAllAsync(GridCacheAdapter.this.ctx, readyTopVer, Collections.singletonList(key), false, filter, true).chain(RET2FLAG);
            }

            public String toString() {
                return S.toString("removeAsync", "key", key, true, "filter", (Object)filter, false);
            }
        });
    }

    @Override
    public void removeAllConflict(final Map<KeyCacheObject, GridCacheVersion> drMap) throws IgniteCheckedException {
        if (F.isEmpty(drMap)) {
            return;
        }
        this.ctx.dr().onReceiveCacheEntriesReceived(drMap.size());
        this.syncOp(new SyncInOp(false){

            @Override
            public void inOp(GridNearTxLocal tx) throws IgniteCheckedException {
                tx.removeAllDrAsync(GridCacheAdapter.this.ctx, drMap).get();
            }

            public String toString() {
                return "removeAllConflict [drMap=" + drMap + ']';
            }
        });
    }

    @Override
    public IgniteInternalFuture<?> removeAllConflictAsync(final Map<KeyCacheObject, GridCacheVersion> drMap) throws IgniteCheckedException {
        if (F.isEmpty(drMap)) {
            return new GridFinishedFuture();
        }
        this.ctx.dr().onReceiveCacheEntriesReceived(drMap.size());
        return this.asyncOp(new AsyncOp(drMap.keySet()){

            public IgniteInternalFuture<?> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.removeAllDrAsync(GridCacheAdapter.this.ctx, drMap);
            }

            public String toString() {
                return "removeAllDrASync [drMap=" + drMap + ']';
            }
        });
    }

    @Override
    public final boolean remove(K key, V val) throws IgniteCheckedException {
        A.notNull(val, "val");
        return this.remove(key, (V)this.ctx.equalsVal(val));
    }

    @Override
    public final IgniteInternalFuture<Boolean> removeAsync(K key, V val) {
        A.notNull(key, "val");
        return this.removeAsync(key, (V)this.ctx.equalsVal(val));
    }

    @Override
    public final CacheMetrics clusterMetrics() {
        return this.clusterMetrics(this.ctx.grid().cluster().forDataNodes(this.ctx.name()));
    }

    @Override
    public CacheMetrics clusterMetrics(ClusterGroup grp) {
        ArrayList<CacheMetrics> metrics = new ArrayList<CacheMetrics>(grp.nodes().size());
        for (ClusterNode node : grp.nodes()) {
            CacheMetrics e;
            Map<Integer, CacheMetrics> nodeCacheMetrics = ((IgniteClusterNode)node).cacheMetrics();
            if (nodeCacheMetrics == null || (e = nodeCacheMetrics.get(this.context().cacheId())) == null) continue;
            metrics.add(e);
        }
        return this.isCacheMetricsV2Supported() ? new CacheMetricsSnapshotV2(this.ctx.cache().localMetrics(), metrics) : new CacheMetricsSnapshot(this.ctx.cache().localMetrics(), metrics);
    }

    @Override
    public CacheMetrics localMetrics() {
        return this.isCacheMetricsV2Supported() ? new CacheMetricsSnapshotV2(this.metrics) : new CacheMetricsSnapshot(this.metrics);
    }

    private boolean isCacheMetricsV2Supported() {
        Collection<ClusterNode> nodes = this.ctx.discovery().allNodes();
        return IgniteFeatures.allNodesSupports(this.ctx.kernalContext(), nodes, IgniteFeatures.CACHE_METRICS_V2);
    }

    @Override
    public CacheMetricsMXBean localMxBean() {
        return this.locMxBean;
    }

    @Override
    public CacheMetricsMXBean clusterMxBean() {
        return this.clusterMxBean;
    }

    public CacheMetricsImpl metrics0() {
        return this.metrics;
    }

    @Override
    @Nullable
    public GridNearTxLocal tx() {
        return this.ctx.tm().threadLocalTx(this.ctx);
    }

    @Override
    public boolean lock(K key, long timeout) throws IgniteCheckedException {
        A.notNull(key, "key");
        return this.lockAll(Collections.singletonList(key), timeout);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean lockAll(@Nullable Collection<? extends K> keys, long timeout) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAsync(K key, long timeout) {
        A.notNull(key, "key");
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Lock");
        return this.lockAllAsync(Collections.singletonList(key), timeout);
    }

    @Override
    public void unlock(K key) throws IgniteCheckedException {
        A.notNull(key, "key");
        this.unlockAll(Collections.singletonList(key));
    }

    @Override
    public boolean isLocked(K key) {
        A.notNull(key, "key");
        KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
        while (true) {
            try {
                GridCacheEntryEx entry = this.peekEx(cacheKey);
                return entry != null && entry.lockedByAny(new GridCacheVersion[0]);
            }
            catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isLockedByThread(K key) {
        A.notNull(key, "key");
        try {
            KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
            GridCacheEntryEx e = this.entry0(cacheKey, this.ctx.shared().exchange().readyAffinityVersion(), false);
            if (e == null) {
                return false;
            }
            if (e.isDht() && CU.isNearEnabled(this.ctx)) {
                GridNearCacheAdapter<K, V> near = this.ctx.isDht() ? this.ctx.dht().near() : this.ctx.near();
                return near.isLockedByThread(key) || e.lockedByThread();
            }
            return e.lockedByThread();
        }
        catch (GridCacheEntryRemovedException ignore) {
            return false;
        }
    }

    @Override
    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        A.notNull((Object)concurrency, "concurrency");
        A.notNull((Object)isolation, "isolation");
        TransactionConfiguration cfg = CU.transactionConfiguration(this.ctx, this.ctx.kernalContext().config());
        return this.txStart(concurrency, isolation, cfg.getDefaultTxTimeout(), 0);
    }

    @Override
    public GridNearTxLocal txStartEx(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        IgniteTransactionsEx txs = this.ctx.kernalContext().cache().transactions();
        return txs.txStartEx(this.ctx, concurrency, isolation);
    }

    @Override
    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize) throws IllegalStateException {
        IgniteTransactionsEx txs = this.ctx.kernalContext().cache().transactions();
        return txs.txStartEx(this.ctx, concurrency, isolation, timeout, txSize).proxy();
    }

    protected void checkJta() throws IgniteCheckedException {
        this.ctx.jta().checkJta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localLoadCache(final IgniteBiPredicate<K, V> p, Object[] args) throws IgniteCheckedException {
        block9: {
            boolean keepBinary;
            MvccUtils.verifyMvccOperationSupport(this.ctx, "Load");
            final boolean replicate = this.ctx.isDrEnabled();
            final AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
            CacheOperationContext opCtx = this.ctx.operationContextPerCall();
            ExpiryPolicy plc0 = opCtx != null ? opCtx.expiry() : null;
            final ExpiryPolicy plc = plc0 != null ? plc0 : this.ctx.expiry();
            boolean bl = keepBinary = opCtx != null && opCtx.isKeepBinary();
            if (p != null) {
                this.ctx.kernalContext().resource().injectGeneric(p);
            }
            try {
                if (this.ctx.store().isLocal()) {
                    DataStreamerImpl<KeyCacheObject, CacheObject> ldr = this.ctx.kernalContext().dataStream().dataStreamer(this.ctx.name());
                    try {
                        ldr.skipStore(true);
                        ldr.receiver(new IgniteDrDataStreamerCacheUpdater());
                        ldr.keepBinary(keepBinary);
                        LocalStoreLoadClosure c = new LocalStoreLoadClosure(p, ldr, plc);
                        this.ctx.store().loadCache(c, args);
                        c.onDone();
                        break block9;
                    }
                    finally {
                        ldr.closeEx(false);
                    }
                }
                final GridCacheVersion ver0 = this.ctx.versions().nextForLoad();
                this.ctx.store().loadCache((GridInClosure3<KeyCacheObject, Object, GridCacheVersion>)new CIX3<KeyCacheObject, Object, GridCacheVersion>(){

                    @Override
                    public void applyx(KeyCacheObject key, Object val, @Nullable GridCacheVersion ver) throws IgniteException {
                        assert (ver == null);
                        long ttl = CU.ttlForLoad(plc);
                        if (ttl == -2L) {
                            return;
                        }
                        GridCacheAdapter.this.loadEntry(key, val, ver0, p, topVer, replicate, ttl);
                    }
                }, args);
            }
            finally {
                if (p instanceof PlatformCacheEntryFilter) {
                    ((PlatformCacheEntryFilter)p).onClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntry(KeyCacheObject key, Object val, GridCacheVersion ver, @Nullable IgniteBiPredicate<Object, Object> p, AffinityTopologyVersion topVer, boolean replicate, long ttl) {
        if (p != null && !p.apply(key.value(this.ctx.cacheObjectContext(), false), val)) {
            return;
        }
        CacheObject cacheVal = this.ctx.toCacheObject(val);
        GridCacheEntryEx entry = this.entryEx(key);
        try {
            entry.initialValue(cacheVal, ver, ttl, -1L, false, topVer, replicate ? GridDrType.DR_LOAD : GridDrType.DR_NONE, true, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to put cache value: " + entry, e);
        }
        catch (GridCacheEntryRemovedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got removed entry during loadCache (will ignore): " + entry);
            }
        }
        finally {
            entry.touch();
        }
        CU.unwindEvicts(this.ctx);
    }

    @Override
    public IgniteInternalFuture<?> localLoadCacheAsync(final IgniteBiPredicate<K, V> p, final Object[] args) {
        return this.ctx.closures().callLocalSafe(this.ctx.projectSafe(new GridPlainCallable<Object>(){

            @Override
            @Nullable
            public Object call() throws IgniteCheckedException {
                GridCacheAdapter.this.localLoadCache(p, args);
                return null;
            }
        }), true);
    }

    public IgniteInternalFuture<?> loadAll(Set<? extends K> keys, boolean replaceExisting) {
        A.notNull(keys, "keys");
        for (K key : keys) {
            A.notNull(key, "key");
        }
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Load");
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        ExpiryPolicy plc = opCtx != null ? opCtx.expiry() : null;
        boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.runLoadKeysCallable(keys, plc, keepBinary, replaceExisting);
    }

    private IgniteInternalFuture<?> runLoadKeysCallable(Set<? extends K> keys, ExpiryPolicy plc, boolean keepBinary, boolean update) {
        Collection<ClusterNode> nodes = this.ctx.grid().cluster().forDataNodes(this.name()).nodes();
        if (nodes.isEmpty()) {
            return new GridFinishedFuture();
        }
        return this.ctx.closures().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new LoadKeysCallable(this.ctx.name(), keys, update, plc, keepBinary), nodes, true, 0L, false);
    }

    private void localLoadAndUpdate(Collection<? extends K> keys) throws IgniteCheckedException {
        try (final DataStreamerImpl ldr = this.ctx.kernalContext().dataStream().dataStreamer(this.ctx.name());){
            ldr.allowOverwrite(true);
            ldr.skipStore(true);
            final ArrayList col = new ArrayList(ldr.perNodeBufferSize());
            Collection<KeyCacheObject> keys0 = this.ctx.cacheKeysView(keys);
            this.ctx.store().loadAll(null, keys0, (IgniteBiInClosure<KeyCacheObject, Object>)new CIX2<KeyCacheObject, Object>(){

                @Override
                public void applyx(KeyCacheObject key, Object val) {
                    col.add(new DataStreamerEntry(key, GridCacheAdapter.this.ctx.toCacheObject(val)));
                    if (col.size() == ldr.perNodeBufferSize()) {
                        ldr.addDataInternal(col, false);
                        col.clear();
                    }
                }
            });
            if (!col.isEmpty()) {
                ldr.addData(col);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localLoad(Collection<? extends K> keys, @Nullable ExpiryPolicy plc, boolean keepBinary) throws IgniteCheckedException {
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Load");
        final boolean replicate = this.ctx.isDrEnabled();
        final AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        final ExpiryPolicy plc0 = plc != null ? plc : this.ctx.expiry();
        Collection<KeyCacheObject> keys0 = this.ctx.cacheKeysView(keys);
        if (this.ctx.store().isLocal()) {
            DataStreamerImpl<KeyCacheObject, CacheObject> ldr = this.ctx.kernalContext().dataStream().dataStreamer(this.ctx.name());
            try {
                ldr.skipStore(true);
                ldr.keepBinary(keepBinary);
                ldr.receiver(new IgniteDrDataStreamerCacheUpdater());
                LocalStoreLoadClosure c = new LocalStoreLoadClosure(null, ldr, plc0);
                this.ctx.store().localStoreLoadAll(null, keys0, c);
                c.onDone();
            }
            finally {
                ldr.closeEx(false);
            }
        } else {
            final GridCacheVersion ver0 = this.ctx.versions().nextForLoad();
            this.ctx.store().loadAll(null, keys0, (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                @Override
                public void apply(KeyCacheObject key, Object val) {
                    long ttl = CU.ttlForLoad(plc0);
                    if (ttl == -2L) {
                        return;
                    }
                    GridCacheAdapter.this.loadEntry(key, val, ver0, null, topVer, replicate, ttl);
                }
            });
        }
    }

    void globalLoadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws IgniteCheckedException {
        this.globalLoadCacheAsync(p, args).get();
    }

    IgniteInternalFuture<?> globalLoadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws IgniteCheckedException {
        this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        ExpiryPolicy plc = opCtx != null ? opCtx.expiry() : null;
        Collection<ClusterNode> nodes = this.ctx.kernalContext().grid().cluster().forDataNodes(this.ctx.name()).nodes();
        assert (!F.isEmpty(nodes)) : "There are not datanodes fo cache: " + this.ctx.name();
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Load");
        boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        ComputeTaskInternalFuture fut = this.ctx.kernalContext().closure().callAsync(GridClosureCallMode.BROADCAST, Collections.singletonList(new LoadCacheJobV2<K, V>(this.ctx.name(), this.ctx.affinity().affinityTopologyVersion(), p, args, plc, keepBinary)), nodes);
        return fut;
    }

    @Override
    public int size(CachePeekMode[] peekModes) throws IgniteCheckedException {
        if (this.isLocal()) {
            return this.localSize(peekModes);
        }
        return this.sizeAsync(peekModes).get();
    }

    @Override
    public long sizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        if (this.isLocal()) {
            return this.localSizeLong(peekModes);
        }
        return this.sizeLongAsync(peekModes).get();
    }

    @Override
    public long sizeLong(int partition, CachePeekMode[] peekModes) throws IgniteCheckedException {
        if (this.isLocal()) {
            return this.localSizeLong(partition, peekModes);
        }
        return this.sizeLongAsync(partition, peekModes).get();
    }

    @Override
    public IgniteInternalFuture<Integer> sizeAsync(CachePeekMode[] peekModes) {
        assert (peekModes != null);
        PeekModes modes = GridCacheAdapter.parsePeekModes(peekModes, true);
        IgniteClusterEx cluster = this.ctx.grid().cluster();
        ClusterGroup grp = modes.near ? cluster.forCacheNodes(this.name(), true, true, false) : cluster.forDataNodes(this.name());
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(grp.nodes());
        if (nodes.isEmpty()) {
            return new GridFinishedFuture<Integer>(0);
        }
        this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
        return this.ctx.kernalContext().task().execute(new SizeTask(this.ctx.name(), this.ctx.affinity().affinityTopologyVersion(), peekModes), null);
    }

    @Override
    public IgniteInternalFuture<Long> sizeLongAsync(CachePeekMode[] peekModes) {
        assert (peekModes != null);
        PeekModes modes = GridCacheAdapter.parsePeekModes(peekModes, true);
        IgniteClusterEx cluster = this.ctx.grid().cluster();
        ClusterGroup grp = modes.near ? cluster.forCacheNodes(this.name(), true, true, false) : cluster.forDataNodes(this.name());
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(grp.nodes());
        if (nodes.isEmpty()) {
            return new GridFinishedFuture<Long>(0L);
        }
        this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
        return this.ctx.kernalContext().task().execute(new SizeLongTask(this.ctx.name(), this.ctx.affinity().affinityTopologyVersion(), peekModes), null);
    }

    @Override
    public IgniteInternalFuture<Long> sizeLongAsync(final int part, CachePeekMode[] peekModes) {
        assert (peekModes != null);
        final PeekModes modes = GridCacheAdapter.parsePeekModes(peekModes, true);
        IgniteClusterEx cluster = this.ctx.grid().cluster();
        final GridCacheAffinityManager aff = this.ctx.affinity();
        final AffinityTopologyVersion topVer = aff.affinityTopologyVersion();
        ClusterGroup grp = cluster.forDataNodes(this.name());
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(grp.forPredicate(new IgnitePredicate<ClusterNode>(){

            @Override
            public boolean apply(ClusterNode clusterNode) {
                return modes.primary && aff.primaryByPartition(clusterNode, part, topVer) || modes.backup && aff.backupByPartition(clusterNode, part, topVer);
            }
        }).nodes());
        if (nodes.isEmpty()) {
            return new GridFinishedFuture<Long>(0L);
        }
        this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
        return this.ctx.kernalContext().task().execute(new PartitionSizeLongTask(this.ctx.name(), this.ctx.affinity().affinityTopologyVersion(), peekModes, part), null);
    }

    @Override
    public int localSize(CachePeekMode[] peekModes) throws IgniteCheckedException {
        return (int)this.localSizeLong(peekModes);
    }

    @Override
    public int size() {
        return this.map.publicSize(this.ctx.cacheId());
    }

    @Override
    public long sizeLong() {
        return this.map.publicSize(this.ctx.cacheId());
    }

    @Override
    public int nearSize() {
        return 0;
    }

    @Override
    public int primarySize() {
        return this.map.publicSize(this.ctx.cacheId());
    }

    @Override
    public long primarySizeLong() {
        return this.map.publicSize(this.ctx.cacheId());
    }

    public String toString() {
        return S.toString(GridCacheAdapter.class, this, "name", (Object)this.name(), "size", (Object)this.size());
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public Iterator<Cache.Entry<K, V>> scanIterator(boolean keepBinary, @Nullable IgniteBiPredicate<Object, Object> p) throws IgniteCheckedException {
        return this.igniteIterator(keepBinary, p);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> scanIterator(boolean keepBinary, @Nullable IgniteBiPredicate<Object, Object> p, long timeout) throws IgniteCheckedException {
        return this.igniteIterator(keepBinary, p, timeout);
    }

    public Iterator<Cache.Entry<K, V>> igniteIterator() throws IgniteCheckedException {
        return this.igniteIterator(this.ctx.keepBinary(), null);
    }

    public Iterator<Cache.Entry<K, V>> igniteIterator(boolean keepBinary) throws IgniteCheckedException {
        return this.igniteIterator(keepBinary, null);
    }

    public GridCacheVersion nextVersion() {
        return this.ctx.versions().next(this.ctx.topology().readyTopologyVersion().topologyVersion());
    }

    public GridCacheVersion nextVersion(byte dataCenterId) {
        return this.ctx.versions().next(this.ctx.topology().readyTopologyVersion().topologyVersion(), dataCenterId);
    }

    private Iterator<Cache.Entry<K, V>> igniteIterator(boolean keepBinary, @Nullable IgniteBiPredicate<Object, Object> p) throws IgniteCheckedException {
        return this.igniteIterator(keepBinary, p, 0L);
    }

    private Iterator<Cache.Entry<K, V>> igniteIterator(boolean keepBinary, @Nullable IgniteBiPredicate<Object, Object> p, long timeout) throws IgniteCheckedException {
        GridCacheContext<K, V> ctx0 = this.ctx.isNear() ? this.ctx.near().dht().context() : this.ctx;
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        GridCloseableIterator iter = ctx0.queries().createScanQuery(p, null, keepBinary, null, timeout).executeScanQuery();
        return this.ctx.itHolder().iterator(iter, new CacheIteratorConverter<Cache.Entry<K, V>, Map.Entry<K, V>>(){

            @Override
            protected Cache.Entry<K, V> convert(Map.Entry<K, V> e) {
                return (Cache.Entry)((Object)e);
            }

            @Override
            protected void remove(Cache.Entry<K, V> item) {
                CacheOperationContext prev = GridCacheAdapter.this.ctx.gate().enter(opCtx);
                try {
                    GridCacheAdapter.this.remove(item.getKey());
                }
                catch (IgniteCheckedException e) {
                    throw CU.convertToCacheException(e);
                }
                finally {
                    GridCacheAdapter.this.ctx.gate().leave(prev);
                }
            }
        });
    }

    @Override
    public long offHeapEntriesCount() {
        IgniteCacheOffheapManager mgr = this.ctx.offheap();
        return mgr != null ? mgr.cacheEntriesCount(this.ctx.cacheId(), true, true, this.ctx.affinity().affinityTopologyVersion()) : -1L;
    }

    @Override
    public long offHeapAllocatedSize() {
        IgniteCacheOffheapManager mgr = this.ctx.offheap();
        return mgr != null ? mgr.offHeapAllocatedSize() : -1L;
    }

    public FutureHolder lastAsyncFuture() {
        return this.lastFut.get();
    }

    @Nullable
    private <T> T syncOp(SyncOp<T> op) throws IgniteCheckedException {
        this.checkJta();
        GridNearTxLocal tx = this.checkCurrentTx();
        if (tx == null || tx.implicit()) {
            this.lastAsyncFuture().await();
            TransactionConfiguration tCfg = CU.transactionConfiguration(this.ctx, this.ctx.kernalContext().config());
            CacheOperationContext opCtx = this.ctx.operationContextPerCall();
            int retries = opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES;
            for (int i = 0; i < retries; ++i) {
                tx = this.ctx.tm().newTx(true, op.single(), this.ctx.systemTx() ? this.ctx : null, this.ctx.mvccEnabled() ? TransactionConcurrency.PESSIMISTIC : TransactionConcurrency.OPTIMISTIC, this.ctx.mvccEnabled() ? TransactionIsolation.REPEATABLE_READ : TransactionIsolation.READ_COMMITTED, tCfg.getDefaultTxTimeout(), !this.ctx.skipStore(), this.ctx.mvccEnabled(), 0, null);
                assert (tx != null);
                try {
                    T t = op.op(tx);
                    assert (tx.done()) : "Transaction is not done: " + tx;
                    T t2 = t;
                    return t2;
                }
                catch (IgniteInterruptedCheckedException | NodeStoppingException | IgniteTxHeuristicCheckedException e) {
                    throw e;
                }
                catch (IgniteCheckedException e2) {
                    ClusterTopologyCheckedException topErr;
                    IgniteTxRollbackCheckedException e2;
                    block21: {
                        if (!(e2 instanceof IgniteTxRollbackCheckedException)) {
                            try {
                                tx.rollback();
                                if (!(e2 instanceof TransactionCheckedException)) {
                                    e2 = new IgniteTxRollbackCheckedException("Transaction has been rolled back: " + tx.xid(), e2);
                                }
                            }
                            catch (AssertionError | RuntimeException | IgniteCheckedException e1) {
                                U.error(this.log, "Failed to rollback transaction (cache may contain stale locks): " + CU.txString(tx), (Throwable)e1);
                                if (e2 == e1) break block21;
                                e2.addSuppressed((Throwable)e1);
                            }
                        }
                    }
                    if (X.hasCause((Throwable)e2, ClusterTopologyCheckedException.class) && i != retries - 1 && !((topErr = e2.getCause(ClusterTopologyCheckedException.class)) instanceof ClusterTopologyServerNotFoundException)) {
                        AffinityTopologyVersion topVer = tx.topologyVersion();
                        assert (topVer != null && topVer.topologyVersion() > 0L) : tx;
                        AffinityTopologyVersion awaitVer = new AffinityTopologyVersion(topVer.topologyVersion() + 1L, 0);
                        this.ctx.shared().exchange().affinityReadyFuture(awaitVer).get();
                        continue;
                    }
                    throw e2;
                }
                catch (RuntimeException e) {
                    try {
                        tx.rollback();
                    }
                    catch (AssertionError | RuntimeException | IgniteCheckedException e1) {
                        U.error(this.log, "Failed to rollback transaction " + CU.txString(tx), (Throwable)e1);
                    }
                    throw e;
                }
                finally {
                    this.ctx.tm().resetContext();
                    if (this.ctx.isNear()) {
                        this.ctx.near().dht().context().tm().resetContext();
                    }
                }
            }
            throw new IgniteCheckedException("Failed to perform cache operation (maximum number of retries exceeded).");
        }
        tx.txState().awaitLastFuture();
        return op.op(tx);
    }

    private <T> IgniteInternalFuture<T> asyncOp(AsyncOp<T> op) {
        try {
            this.checkJta();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Performing async op: " + op);
        }
        GridNearTxLocal tx = this.checkCurrentTx();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        TransactionConfiguration txCfg = CU.transactionConfiguration(this.ctx, this.ctx.kernalContext().config());
        if (tx == null || tx.implicit()) {
            int retries;
            boolean skipStore = this.ctx.skipStore();
            int n = retries = opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES;
            if (retries == 1) {
                tx = this.ctx.tm().newTx(true, op.single(), this.ctx.systemTx() ? this.ctx : null, this.ctx.mvccEnabled() ? TransactionConcurrency.PESSIMISTIC : TransactionConcurrency.OPTIMISTIC, this.ctx.mvccEnabled() ? TransactionIsolation.REPEATABLE_READ : TransactionIsolation.READ_COMMITTED, txCfg.getDefaultTxTimeout(), !skipStore, this.ctx.mvccEnabled(), 0, null);
                return this.asyncOp(tx, op, opCtx, false);
            }
            AsyncOpRetryFuture<T> fut = new AsyncOpRetryFuture<T>(op, retries, opCtx);
            fut.execute(false);
            return fut;
        }
        return this.asyncOp(tx, op, opCtx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> IgniteInternalFuture<T> asyncOp(GridNearTxLocal tx, final AsyncOp<T> op, final CacheOperationContext opCtx, boolean retry) {
        IgniteInternalFuture<T> fail = this.asyncOpAcquire(retry);
        if (fail != null) {
            return fail;
        }
        FutureHolder holder = tx.implicit() ? this.lastAsyncFuture() : tx.txState().lastAsyncFuture();
        holder.lock();
        try {
            IgniteInternalFuture f;
            IgniteInternalFuture<?> fut = holder.future();
            final GridNearTxLocal tx0 = tx;
            final CX1 clo = new CX1<IgniteInternalFuture<T>, T>(){

                @Override
                public T applyx(IgniteInternalFuture<T> tFut) throws IgniteCheckedException {
                    try {
                        Object t = tFut.get();
                        return t;
                    }
                    catch (NodeStoppingException | IgniteTxRollbackCheckedException | IgniteTxTimeoutCheckedException e) {
                        throw e;
                    }
                    catch (IgniteCheckedException e1) {
                        block8: {
                            try {
                                tx0.rollbackNearTxLocalAsync();
                            }
                            catch (Throwable e2) {
                                if (e1 == e2) break block8;
                                e1.addSuppressed(e2);
                            }
                        }
                        throw e1;
                    }
                    finally {
                        GridCacheAdapter.this.ctx.shared().txContextReset();
                    }
                }
            };
            if (fut != null && !fut.isDone()) {
                GridEmbeddedFuture f2 = new GridEmbeddedFuture(fut, () -> {
                    final GridFutureAdapter resFut = new GridFutureAdapter();
                    this.ctx.kernalContext().closure().runLocalSafe((Runnable)new GridPlainRunnable(){

                        @Override
                        public void run() {
                            IgniteInternalFuture fut0;
                            if (GridCacheAdapter.this.ctx.kernalContext().isStopping()) {
                                fut0 = new GridFinishedFuture(new IgniteCheckedException("Operation has been cancelled (node is stopping)."));
                            } else if (GridCacheAdapter.this.ctx.gate().isStopped()) {
                                fut0 = new GridFinishedFuture(new CacheStoppedException(GridCacheAdapter.this.ctx.name()));
                            } else {
                                GridCacheAdapter.this.ctx.operationContextPerCall(opCtx);
                                GridCacheAdapter.this.ctx.shared().txContextReset();
                                try {
                                    fut0 = op.op(tx0).chain(clo);
                                }
                                finally {
                                    GridCacheAdapter.this.ctx.shared().txContextReset();
                                    GridCacheAdapter.this.ctx.operationContextPerCall(null);
                                }
                            }
                            fut0.listen(fut01 -> {
                                try {
                                    resFut.onDone(fut01.get());
                                }
                                catch (Throwable ex) {
                                    resFut.onDone(ex);
                                }
                            });
                        }
                    }, true);
                    return resFut;
                });
                holder.saveFuture(f2);
                f2.listen(f0 -> this.asyncOpRelease(retry));
                GridEmbeddedFuture gridEmbeddedFuture = f2;
                return gridEmbeddedFuture;
            }
            if (!tx0.txState().implicitSingle()) {
                tx0.txState().awaitLastFuture();
            }
            try {
                f = op.op(tx).chain(clo);
            }
            finally {
                this.ctx.shared().txContextReset();
            }
            holder.saveFuture(f);
            f.listen(f0 -> this.asyncOpRelease(retry));
            if (tx.implicit()) {
                this.ctx.tm().resetContext();
            }
            IgniteInternalFuture igniteInternalFuture = f;
            return igniteInternalFuture;
        }
        finally {
            holder.unlock();
        }
    }

    @Nullable
    protected <T> IgniteInternalFuture<T> asyncOpAcquire(boolean retry) {
        try {
            if (!retry && this.asyncOpsSem != null) {
                this.asyncOpsSem.acquire();
            }
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new GridFinishedFuture(new IgniteInterruptedCheckedException("Failed to wait for asynchronous operation permit (thread got interrupted).", e));
        }
    }

    protected final void asyncOpRelease(boolean retry) {
        if (!retry && this.asyncOpsSem != null) {
            this.asyncOpsSem.release();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.ctx.igniteInstanceName());
        U.writeString(out, this.ctx.name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<String, String> t = stash.get();
        t.set1(U.readString(in));
        t.set2(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<String, String> t = stash.get();
            IgniteInternalCache igniteInternalCache = IgnitionEx.localIgnite().cachex(t.get2());
            return igniteInternalCache;
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public IgniteInternalFuture<?> rebalance() {
        return this.ctx.preloader().forceRebalance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearLocally0(K key, boolean readers) {
        this.ctx.shared().cache().checkReadOnlyState("clear", this.ctx.config());
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Clear");
        this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        GridCacheVersion obsoleteVer = this.ctx.versions().startVersion();
        this.ctx.shared().database().checkpointReadLock();
        try {
            GridCacheEntryEx entry;
            KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
            GridCacheEntryEx gridCacheEntryEx = entry = this.ctx.isNear() ? this.peekEx(cacheKey) : this.entryEx(cacheKey);
            if (entry != null) {
                boolean bl = entry.clear(obsoleteVer, readers);
                return bl;
            }
        }
        catch (GridDhtInvalidPartitionException cacheKey) {
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to clearLocally entry for key: " + key, ex);
        }
        finally {
            this.ctx.shared().database().checkpointReadUnlock();
        }
        return false;
    }

    @Override
    public boolean evict(K key) {
        A.notNull(key, "key");
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Evict");
        return this.evictx(key, this.nextVersion(), CU.empty0());
    }

    @Override
    public void evictAll(Collection<? extends K> keys) {
        A.notNull(keys, "keys");
        if (F.isEmpty(keys)) {
            return;
        }
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Evict");
        GridCacheVersion obsoleteVer = this.nextVersion();
        try {
            this.ctx.evicts().batchEvict(keys, obsoleteVer);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to perform batch evict for keys: " + keys, e);
        }
    }

    public Set<Cache.Entry<K, V>> entrySet(CacheEntryPredicate ... filter) {
        boolean keepBinary = this.ctx.keepBinary();
        return new EntrySet(this.map.entrySet(this.ctx.cacheId(), filter), keepBinary);
    }

    @Nullable
    public final V get(K key, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        return this.get0(key, taskName, deserializeBinary, needVer);
    }

    protected V get0(K key, String taskName, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        this.checkJta();
        try {
            return this.getAsync(key, false, null, taskName, deserializeBinary, false, needVer, false).get();
        }
        catch (IgniteException e) {
            if (e.getCause(IgniteCheckedException.class) != null) {
                throw e.getCause(IgniteCheckedException.class);
            }
            throw e;
        }
    }

    protected Map<K, V> getAll0(Collection<? extends K> keys, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        this.checkJta();
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.getAllAsync(keys, false, false, null, taskName, deserializeBinary, opCtx != null && opCtx.recovery(), false, needVer).get();
    }

    public void onReconnected() {
    }

    protected void warnIfUnordered(Map<?, ?> m, BulkOperation op) {
        if (this.ctx.atomic()) {
            return;
        }
        if (m == null || m.size() <= 1) {
            return;
        }
        if (m instanceof SortedMap || m instanceof GridSerializableMap) {
            return;
        }
        Transaction tx = this.ctx.kernalContext().cache().transactions().tx();
        if (tx != null && !op.canBlockTx(tx.concurrency(), tx.isolation())) {
            return;
        }
        LT.warn(this.log, "Unordered map " + m.getClass().getName() + " is used for " + op.title() + " operation on cache " + this.name() + ". This can lead to a distributed deadlock. Switch to a sorted map like TreeMap instead.");
    }

    protected void warnIfUnordered(Collection<?> coll, BulkOperation op) {
        if (this.ctx.atomic()) {
            return;
        }
        if (coll == null || coll.size() <= 1) {
            return;
        }
        if (coll instanceof SortedSet || coll instanceof KeySet) {
            return;
        }
        if (this.ctx.lastRemoveAllJobFut().get() != null && op == BulkOperation.REMOVE) {
            return;
        }
        Transaction tx = this.ctx.kernalContext().cache().transactions().tx();
        if (op == BulkOperation.GET && tx == null) {
            return;
        }
        if (tx != null && !op.canBlockTx(tx.concurrency(), tx.isolation())) {
            return;
        }
        LT.warn(this.log, "Unordered collection " + coll.getClass().getName() + " is used for " + op.title() + " operation on cache " + this.name() + ". This can lead to a distributed deadlock. Switch to a sorted set like TreeSet instead.");
    }

    protected final Iterator<Cache.Entry<K, V>> iterator(final Iterator<? extends GridCacheEntryEx> it, final boolean deserializeBinary) {
        return new Iterator<Cache.Entry<K, V>>(){
            private Cache.Entry<K, V> next;
            {
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Cache.Entry<K, V> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Cache.Entry e = this.next;
                this.advance();
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                this.next = null;
                while (it.hasNext()) {
                    GridCacheEntryEx entry = (GridCacheEntryEx)it.next();
                    try {
                        this.next = GridCacheAdapter.this.toCacheEntry(entry, deserializeBinary);
                        if (this.next != null) break;
                    }
                    catch (IgniteCheckedException e) {
                        throw CU.convertToCacheException(e);
                    }
                    catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                    }
                }
            }
        };
    }

    @Nullable
    private Cache.Entry<K, V> toCacheEntry(GridCacheEntryEx entry, boolean deserializeBinary) throws IgniteCheckedException, GridCacheEntryRemovedException {
        CacheObject val = entry.innerGet(null, null, false, false, false, null, null, null, null, !deserializeBinary);
        if (val == null) {
            return null;
        }
        KeyCacheObject key = entry.key();
        Object key0 = this.ctx.unwrapBinaryIfNeeded(key, !deserializeBinary, true, null);
        Object val0 = this.ctx.unwrapBinaryIfNeeded(val, !deserializeBinary, true, null);
        return new CacheEntryImpl<Object, Object>(key0, val0, entry.version());
    }

    @Override
    public void preloadPartition(int part) throws IgniteCheckedException {
        if (this.isLocal()) {
            this.ctx.offheap().preloadPartition(part);
        } else {
            this.executePreloadTask(part).get();
        }
    }

    @Override
    public IgniteInternalFuture<?> preloadPartitionAsync(final int part) throws IgniteCheckedException {
        if (this.isLocal()) {
            return this.ctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    try {
                        GridCacheAdapter.this.ctx.offheap().preloadPartition(part);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
            });
        }
        return this.executePreloadTask(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean localPreloadPartition(int part) throws IgniteCheckedException {
        if (!this.ctx.affinityNode()) {
            return false;
        }
        GridDhtPartitionTopology top = this.ctx.group().topology();
        @Nullable GridDhtLocalPartition p = top.localPartition(part, top.readyTopologyVersion(), false);
        if (p == null) {
            return false;
        }
        try {
            if (!p.reserve() || p.state() != GridDhtPartitionState.OWNING) {
                boolean bl = false;
                return bl;
            }
            p.dataStore().preload();
        }
        finally {
            p.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int localEntrySize(K key) throws IgniteCheckedException {
        block14: {
            A.notNull(key, "key");
            if (this.ctx.mvccEnabled()) {
                throw new UnsupportedOperationException("Operation is not supported for " + (Object)CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT + " cache [name=" + this.name() + ']');
            }
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            cacheKey = this.ctx.toCacheKeyObject(key);
            if (this.ctx.isLocal()) break block14;
            topVer = this.ctx.affinity().affinityTopologyVersion();
            part = this.ctx.affinity().partition(cacheKey);
            keyPrimary = this.ctx.affinity().primaryByPartition(this.ctx.localNode(), part, topVer);
            keyBackup = this.ctx.affinity().partitionBelongs(this.ctx.localNode(), part, topVer);
            if (!keyPrimary && !keyBackup) {
                return 0;
            }
            while (true) lbl-1000:
            // 4 sources

            {
                ctx0 = this.ctx.isNear() != false ? this.ctx.near().dht().context() : this.ctx;
                e = ctx0.cache().entryEx(key);
                try {
                    var9_13 = e.localSize(topVer);
                    return var9_13;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!this.log.isDebugEnabled()) ** GOTO lbl-1000
                    this.log.debug("Got removed entry during calculating entry size: " + key);
                }
                finally {
                    e.touch();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
        }
        while (true) {
            e = this.entryEx(key);
            if (e == null) continue;
            try {
                var4_7 = e.localSize(AffinityTopologyVersion.NONE);
                e.touch();
                return var4_7;
            }
            catch (Throwable var11_15) {
                try {
                    e.touch();
                    throw var11_15;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Got removed entry during calculating entry size: " + key);
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public boolean touch(K key) {
        try {
            return this.touchAsync(key).get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public IgniteInternalFuture<Boolean> touchAsync(K key) {
        A.notNull(key, "key");
        if (!this.isDhtAtomic()) {
            throw new UnsupportedOperationException("Operation is not supported on " + (this.isNear() ? "near " : "") + (this.isLocal() ? "local " : "") + (Object)((Object)this.ctx.config().getAtomicityMode()) + " cache [name=" + this.name() + ']');
        }
        return this.getAsync(key, false, null, null, false, true, false, true);
    }

    protected static PeekModes parsePeekModes(CachePeekMode[] peekModes, boolean primary) {
        PeekModes modes = new PeekModes();
        if (F.isEmpty(peekModes)) {
            modes.primary = true;
            if (!primary) {
                modes.backup = true;
                modes.near = true;
            }
            modes.heap = true;
            modes.offheap = true;
        } else {
            block8: for (CachePeekMode peekMode : peekModes) {
                A.notNull((Object)peekMode, "peekMode");
                switch (peekMode) {
                    case ALL: {
                        modes.near = true;
                        modes.primary = true;
                        modes.backup = true;
                        modes.heap = true;
                        modes.offheap = true;
                        continue block8;
                    }
                    case BACKUP: {
                        modes.backup = true;
                        continue block8;
                    }
                    case PRIMARY: {
                        modes.primary = true;
                        continue block8;
                    }
                    case NEAR: {
                        modes.near = true;
                        continue block8;
                    }
                    case ONHEAP: {
                        modes.heap = true;
                        continue block8;
                    }
                    case OFFHEAP: {
                        modes.offheap = true;
                        continue block8;
                    }
                    default: {
                        assert (false) : peekMode;
                        continue block8;
                    }
                }
            }
        }
        if (!modes.heap && !modes.offheap) {
            modes.heap = true;
            modes.offheap = true;
        }
        if (!(modes.primary || modes.backup || modes.near)) {
            modes.primary = true;
            if (!primary) {
                modes.backup = true;
                modes.near = true;
            }
        }
        assert (modes.heap || modes.offheap);
        assert (modes.primary || modes.backup || modes.near);
        return modes;
    }

    @Nullable
    public final IgniteCacheExpiryPolicy expiryPolicy(@Nullable ExpiryPolicy plc) {
        if (plc == null) {
            plc = this.ctx.expiry();
        }
        return CacheExpiryPolicy.forPolicy(plc);
    }

    private final class EntrySet
    extends AbstractSet<Cache.Entry<K, V>> {
        private final Set<GridCacheMapEntry> internalSet;
        private final boolean keepBinary;

        private EntrySet(Set<GridCacheMapEntry> internalSet, boolean keepBinary) {
            this.internalSet = internalSet;
            this.keepBinary = keepBinary;
        }

        @Override
        public Iterator<Cache.Entry<K, V>> iterator() {
            return new EntryIterator(this.internalSet.iterator(), this.keepBinary);
        }

        @Override
        public int size() {
            return F.size(this.iterator(), new IgnitePredicate[0]);
        }

        @Override
        public boolean contains(Object o) {
            GridCacheMapEntry entry = GridCacheAdapter.this.map.getEntry(GridCacheAdapter.this.ctx, GridCacheAdapter.this.ctx.toCacheKeyObject(o));
            return entry != null && this.internalSet.contains(entry);
        }
    }

    private final class EntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<GridCacheMapEntry> internalIterator;
        private GridCacheMapEntry current;
        private final boolean keepBinary;

        private EntryIterator(Iterator<GridCacheMapEntry> internalIterator, boolean keepBinary) {
            this.internalIterator = internalIterator;
            this.keepBinary = keepBinary;
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public Cache.Entry<K, V> next() {
            this.current = this.internalIterator.next();
            return this.current.wrapLazyValue(this.keepBinary);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            try {
                GridCacheAdapter.this.getAndRemove(this.current.wrapLazyValue(this.keepBinary).getKey());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            this.current = null;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private final Set<GridCacheMapEntry> internalSet;
        private final boolean keepBinary;

        private KeySet(Set<GridCacheMapEntry> internalSet) {
            this.internalSet = internalSet;
            CacheOperationContext opCtx = GridCacheAdapter.this.ctx.operationContextPerCall();
            this.keepBinary = opCtx != null && opCtx.isKeepBinary();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator(this.internalSet.iterator(), this.keepBinary);
        }

        @Override
        public int size() {
            return F.size(this.iterator(), new IgnitePredicate[0]);
        }

        @Override
        public boolean contains(Object o) {
            GridCacheMapEntry entry = GridCacheAdapter.this.map.getEntry(GridCacheAdapter.this.ctx, GridCacheAdapter.this.ctx.toCacheKeyObject(o));
            return entry != null && this.internalSet.contains(entry);
        }
    }

    private final class KeySetIterator
    implements Iterator<K> {
        private final Iterator<GridCacheMapEntry> internalIterator;
        private final boolean keepBinary;
        private GridCacheMapEntry current;

        private KeySetIterator(Iterator<GridCacheMapEntry> internalIterator, boolean keepBinary) {
            this.internalIterator = internalIterator;
            this.keepBinary = keepBinary;
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.internalIterator.next();
            return GridCacheAdapter.this.ctx.unwrapBinaryIfNeeded(this.current.key(), this.keepBinary, true, null);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            try {
                GridCacheAdapter.this.getAndRemove(this.current.key());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            this.current = null;
        }
    }

    @GridInternal
    private static class PartitionPreloadJob
    implements IgniteRunnable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private final String name;
        private final int part;

        public PartitionPreloadJob(String name, int part) {
            this.name = name;
            this.part = part;
        }

        @Override
        public void run() {
            IgniteInternalCache cache = this.ignite.context().cache().cache(this.name);
            try {
                cache.context().offheap().preloadPartition(this.part);
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to preload the partition [cache=" + this.name + ", partition=" + this.part + ']', e);
                throw new IgniteException(e);
            }
        }
    }

    @GridInternal
    private static class ClearTask<K>
    extends ComputeTaskAdapter<Object, Object> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final AffinityTopologyVersion topVer;
        private final Set<? extends K> keys;
        private final boolean near;

        public ClearTask(String cacheName, AffinityTopologyVersion topVer, Set<? extends K> keys, boolean near) {
            this.cacheName = cacheName;
            this.topVer = topVer;
            this.keys = keys;
            this.near = near;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) throws IgniteException {
            HashMap<GlobalClearAllNearJob, ClusterNode> jobs = new HashMap<GlobalClearAllNearJob, ClusterNode>();
            for (ClusterNode node : subgrid) {
                TopologyVersionAwareJob job = this.near ? (this.keys == null ? new GlobalClearAllNearJob(this.cacheName, this.topVer) : new GlobalClearKeySetNearJob(this.cacheName, this.topVer, this.keys)) : (this.keys == null ? new GlobalClearAllJob(this.cacheName, this.topVer) : new GlobalClearKeySetJob(this.cacheName, this.topVer, this.keys));
                jobs.put((GlobalClearAllNearJob)job, node);
            }
            return jobs;
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            IgniteException e = res.getException();
            if (e != null) {
                if (e instanceof ClusterTopologyException) {
                    return ComputeJobResultPolicy.WAIT;
                }
                throw new IgniteException("Remote job threw exception.", e);
            }
            return ComputeJobResultPolicy.WAIT;
        }

        @Override
        @Nullable
        public Object reduce(List<ComputeJobResult> results) throws IgniteException {
            return null;
        }
    }

    @GridInternal
    private static class PartitionSizeLongTask
    extends ComputeTaskAdapter<Object, Long> {
        private static final long serialVersionUID = 0L;
        private final int partition;
        private final String cacheName;
        private final AffinityTopologyVersion topVer;
        private final CachePeekMode[] peekModes;

        private PartitionSizeLongTask(String cacheName, AffinityTopologyVersion topVer, CachePeekMode[] peekModes, int partition) {
            this.cacheName = cacheName;
            this.topVer = topVer;
            this.peekModes = peekModes;
            this.partition = partition;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) throws IgniteException {
            HashMap<PartitionSizeLongJob, ClusterNode> jobs = new HashMap<PartitionSizeLongJob, ClusterNode>();
            for (ClusterNode node : subgrid) {
                jobs.put(new PartitionSizeLongJob(this.cacheName, this.topVer, this.peekModes, this.partition), node);
            }
            return jobs;
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            IgniteException e = res.getException();
            if (e != null) {
                if (e instanceof ClusterTopologyException) {
                    return ComputeJobResultPolicy.WAIT;
                }
                throw new IgniteException("Remote job threw exception.", e);
            }
            return ComputeJobResultPolicy.WAIT;
        }

        @Override
        @Nullable
        public Long reduce(List<ComputeJobResult> results) throws IgniteException {
            long size = 0L;
            for (ComputeJobResult res : results) {
                if (res == null) continue;
                if (res.getException() == null) {
                    size += ((Long)res.getData()).longValue();
                    continue;
                }
                throw res.getException();
            }
            return size;
        }
    }

    @GridInternal
    private static class SizeLongTask
    extends ComputeTaskAdapter<Object, Long> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final AffinityTopologyVersion topVer;
        private final CachePeekMode[] peekModes;

        private SizeLongTask(String cacheName, AffinityTopologyVersion topVer, CachePeekMode[] peekModes) {
            this.cacheName = cacheName;
            this.topVer = topVer;
            this.peekModes = peekModes;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) throws IgniteException {
            HashMap<SizeLongJob, ClusterNode> jobs = new HashMap<SizeLongJob, ClusterNode>();
            for (ClusterNode node : subgrid) {
                jobs.put(new SizeLongJob(this.cacheName, this.topVer, this.peekModes), node);
            }
            return jobs;
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            IgniteException e = res.getException();
            if (e != null) {
                if (e instanceof ClusterTopologyException) {
                    return ComputeJobResultPolicy.WAIT;
                }
                throw new IgniteException("Remote job threw exception.", e);
            }
            return ComputeJobResultPolicy.WAIT;
        }

        @Override
        @Nullable
        public Long reduce(List<ComputeJobResult> results) throws IgniteException {
            long size = 0L;
            for (ComputeJobResult res : results) {
                if (res == null || res.getException() != null) continue;
                size += ((Long)res.getData()).longValue();
            }
            return size;
        }
    }

    @GridInternal
    private static class SizeTask
    extends ComputeTaskAdapter<Object, Integer> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final AffinityTopologyVersion topVer;
        private final CachePeekMode[] peekModes;

        public SizeTask(String cacheName, AffinityTopologyVersion topVer, CachePeekMode[] peekModes) {
            this.cacheName = cacheName;
            this.topVer = topVer;
            this.peekModes = peekModes;
        }

        @Override
        @NotNull
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) throws IgniteException {
            HashMap<SizeJob, ClusterNode> jobs = new HashMap<SizeJob, ClusterNode>();
            for (ClusterNode node : subgrid) {
                jobs.put(new SizeJob(this.cacheName, this.topVer, this.peekModes), node);
            }
            return jobs;
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            IgniteException e = res.getException();
            if (e != null) {
                if (e instanceof ClusterTopologyException) {
                    return ComputeJobResultPolicy.WAIT;
                }
                throw new IgniteException("Remote job threw exception.", e);
            }
            return ComputeJobResultPolicy.WAIT;
        }

        @Override
        @Nullable
        public Integer reduce(List<ComputeJobResult> results) throws IgniteException {
            int size = 0;
            for (ComputeJobResult res : results) {
                if (res.getException() != null || res == null) continue;
                size += ((Integer)res.getData()).intValue();
            }
            return size;
        }
    }

    public static abstract class TopologyVersionAwareJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        protected ComputeJobContext jobCtx;
        @IgniteInstanceResource
        protected Ignite ignite;
        protected final AffinityTopologyVersion topVer;
        protected final String cacheName;

        public TopologyVersionAwareJob(String cacheName, AffinityTopologyVersion topVer) {
            assert (topVer != null);
            this.cacheName = cacheName;
            this.topVer = topVer;
        }

        @Override
        @Nullable
        public final Object execute() {
            if (!this.waitAffinityReadyFuture()) {
                return null;
            }
            IgniteInternalCache cache = ((IgniteEx)this.ignite).context().cache().cache(this.cacheName);
            return this.localExecute(cache);
        }

        @Nullable
        protected abstract Object localExecute(@Nullable IgniteInternalCache var1);

        private boolean waitAffinityReadyFuture() {
            IgniteInternalFuture<AffinityTopologyVersion> fut;
            GridCacheProcessor cacheProc = ((IgniteEx)this.ignite).context().cache();
            AffinityTopologyVersion locTopVer = cacheProc.context().exchange().readyAffinityVersion();
            if (locTopVer.compareTo(this.topVer) < 0 && (fut = cacheProc.context().exchange().affinityReadyFuture(this.topVer)) != null && !fut.isDone()) {
                this.jobCtx.holdcc();
                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> t) {
                        ((IgniteEx)ignite).context().closure().runLocalSafe((Runnable)new GridPlainRunnable(){

                            @Override
                            public void run() {
                                jobCtx.callcc();
                            }
                        }, false);
                    }
                });
                return false;
            }
            return true;
        }
    }

    protected static class InvokeAllTimeStatClosure<T>
    extends UpdateTimeStatClosure {
        private static final long serialVersionUID = 0L;

        public InvokeAllTimeStatClosure(CacheMetricsImpl metrics, long start) {
            super(metrics, start);
        }

        @Override
        protected void updateTimeStat() {
            this.metrics.addInvokeTimeNanos(System.nanoTime() - this.start);
        }
    }

    protected static class UpdatePutAndGetTimeStatClosure<T>
    extends UpdateTimeStatClosure {
        private static final long serialVersionUID = 0L;

        public UpdatePutAndGetTimeStatClosure(CacheMetricsImpl metrics, long start) {
            super(metrics, start);
        }

        @Override
        protected void updateTimeStat() {
            this.metrics.addPutAndGetTimeNanos(System.nanoTime() - this.start);
        }
    }

    protected static class UpdatePutTimeStatClosure<T>
    extends UpdateTimeStatClosure {
        private static final long serialVersionUID = 0L;

        public UpdatePutTimeStatClosure(CacheMetricsImpl metrics, long start) {
            super(metrics, start);
        }

        @Override
        protected void updateTimeStat() {
            this.metrics.addPutTimeNanos(System.nanoTime() - this.start);
        }
    }

    protected static class UpdateRemoveTimeStatClosure<T>
    extends UpdateTimeStatClosure<T> {
        private static final long serialVersionUID = 0L;

        public UpdateRemoveTimeStatClosure(CacheMetricsImpl metrics, long start) {
            super(metrics, start);
        }

        @Override
        protected void updateTimeStat() {
            this.metrics.addRemoveTimeNanos(System.nanoTime() - this.start);
        }
    }

    protected static class UpdateGetTimeStatClosure<T>
    extends UpdateTimeStatClosure<T> {
        private static final long serialVersionUID = 0L;

        public UpdateGetTimeStatClosure(CacheMetricsImpl metrics, long start) {
            super(metrics, start);
        }

        @Override
        protected void updateTimeStat() {
            this.metrics.addGetTimeNanos(System.nanoTime() - this.start);
        }
    }

    protected static abstract class UpdateTimeStatClosure<T>
    implements CI1<IgniteInternalFuture<T>> {
        protected final CacheMetricsImpl metrics;
        protected final long start;

        public UpdateTimeStatClosure(CacheMetricsImpl metrics, long start) {
            this.metrics = metrics;
            this.start = start;
        }

        @Override
        public void apply(IgniteInternalFuture<T> fut) {
            try {
                if (!fut.isCancelled()) {
                    fut.get();
                    this.updateTimeStat();
                }
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        }

        protected abstract void updateTimeStat();
    }

    private class LocalStoreLoadClosure
    extends CIX3<KeyCacheObject, Object, GridCacheVersion> {
        final IgniteBiPredicate<K, V> p;
        final Collection<GridCacheRawVersionedEntry> col;
        final DataStreamerImpl<K, V> ldr;
        final ExpiryPolicy plc;

        private LocalStoreLoadClosure(IgniteBiPredicate<K, V> p, @Nullable DataStreamerImpl<K, V> ldr, ExpiryPolicy plc) {
            this.p = p;
            this.ldr = ldr;
            this.plc = plc;
            this.col = new ArrayList<GridCacheRawVersionedEntry>(ldr.perNodeBufferSize());
        }

        @Override
        public void applyx(KeyCacheObject key, Object val, GridCacheVersion ver) throws IgniteCheckedException {
            assert (ver != null);
            if (this.p != null && !this.p.apply(key.value(GridCacheAdapter.this.ctx.cacheObjectContext(), false), val)) {
                return;
            }
            long ttl = 0L;
            if (this.plc != null) {
                ttl = CU.toTtl(this.plc.getExpiryForCreation());
                if (ttl == -2L) {
                    return;
                }
                if (ttl == -1L) {
                    ttl = 0L;
                }
            }
            GridCacheRawVersionedEntry e = new GridCacheRawVersionedEntry(GridCacheAdapter.this.ctx.toCacheKeyObject(key), GridCacheAdapter.this.ctx.toCacheObject(val), ttl, 0L, ver.conflictVersion());
            e.prepareDirectMarshal(GridCacheAdapter.this.ctx.cacheObjectContext());
            this.col.add(e);
            if (this.col.size() == this.ldr.perNodeBufferSize()) {
                this.ldr.addDataInternal(this.col, false);
                this.col.clear();
            }
        }

        void onDone() {
            if (!this.col.isEmpty()) {
                this.ldr.addDataInternal(this.col, false);
            }
        }
    }

    static class LoadKeysCallable<K, V>
    implements IgniteCallable<Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String cacheName;
        @IgniteInstanceResource
        private Ignite ignite;
        private Collection<? extends K> keys;
        private boolean update;
        private ExpiryPolicy plc;
        private boolean keepBinary;

        public LoadKeysCallable() {
        }

        LoadKeysCallable(String cacheName, Collection<? extends K> keys, boolean update, ExpiryPolicy plc, boolean keepBinary) {
            this.cacheName = cacheName;
            this.keys = keys;
            this.update = update;
            this.plc = plc;
            this.keepBinary = keepBinary;
        }

        @Override
        public Void call() throws Exception {
            GridCacheAdapter cache = ((IgniteKernal)this.ignite).context().cache().internalCache(this.cacheName);
            assert (cache != null) : this.cacheName;
            cache.context().gate().enter();
            try {
                if (this.update) {
                    cache.localLoadAndUpdate(this.keys);
                } else {
                    cache.localLoad(this.keys, this.plc, this.keepBinary);
                }
            }
            finally {
                cache.context().gate().leave();
            }
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.cacheName);
            U.writeCollection(out, this.keys);
            out.writeBoolean(this.update);
            out.writeObject(this.plc != null ? new IgniteExternalizableExpiryPolicy(this.plc) : null);
            out.writeBoolean(this.keepBinary);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cacheName = U.readString(in);
            this.keys = U.readCollection(in);
            this.update = in.readBoolean();
            this.plc = (ExpiryPolicy)in.readObject();
            this.keepBinary = in.readBoolean();
        }
    }

    protected static abstract class CacheExpiryPolicy
    implements IgniteCacheExpiryPolicy {
        private Map<KeyCacheObject, GridCacheVersion> entries;
        private Map<UUID, Collection<IgniteBiTuple<KeyCacheObject, GridCacheVersion>>> rdrsMap;

        protected CacheExpiryPolicy() {
        }

        @Nullable
        private static CacheExpiryPolicy forPolicy(final @Nullable ExpiryPolicy expiryPlc) {
            if (expiryPlc == null) {
                return null;
            }
            return new CacheExpiryPolicy(){

                @Override
                public long forAccess() {
                    return CU.toTtl(expiryPlc.getExpiryForAccess());
                }

                @Override
                public long forCreate() {
                    return CU.toTtl(expiryPlc.getExpiryForCreation());
                }

                @Override
                public long forUpdate() {
                    return CU.toTtl(expiryPlc.getExpiryForUpdate());
                }
            };
        }

        @Nullable
        public static CacheExpiryPolicy fromRemote(final long createTtl, final long accessTtl) {
            if (createTtl == -1L && accessTtl == -1L) {
                return null;
            }
            return new CacheExpiryPolicy(){

                @Override
                public long forCreate() {
                    return createTtl;
                }

                @Override
                public long forAccess() {
                    return accessTtl;
                }

                @Override
                public long forUpdate() {
                    return -1L;
                }
            };
        }

        @Override
        public void reset() {
            if (this.entries != null) {
                this.entries.clear();
            }
            if (this.rdrsMap != null) {
                this.rdrsMap.clear();
            }
        }

        @Override
        public void ttlUpdated(KeyCacheObject key, GridCacheVersion ver, @Nullable Collection<UUID> rdrs) {
            if (this.entries == null) {
                this.entries = new HashMap<KeyCacheObject, GridCacheVersion>();
            }
            this.entries.put(key, ver);
            if (rdrs != null && !rdrs.isEmpty()) {
                if (this.rdrsMap == null) {
                    this.rdrsMap = new HashMap<UUID, Collection<IgniteBiTuple<KeyCacheObject, GridCacheVersion>>>();
                }
                for (UUID nodeId : rdrs) {
                    Collection<IgniteBiTuple<KeyCacheObject, GridCacheVersion>> col = this.rdrsMap.get(nodeId);
                    if (col == null) {
                        col = new ArrayList<IgniteBiTuple<KeyCacheObject, GridCacheVersion>>();
                        this.rdrsMap.put(nodeId, col);
                    }
                    col.add(new T2<KeyCacheObject, GridCacheVersion>(key, ver));
                }
            }
        }

        @Override
        @Nullable
        public Map<KeyCacheObject, GridCacheVersion> entries() {
            return this.entries;
        }

        @Override
        @Nullable
        public Map<UUID, Collection<IgniteBiTuple<KeyCacheObject, GridCacheVersion>>> readers() {
            return this.rdrsMap;
        }

        @Override
        public boolean readyToFlush(int cnt) {
            return this.entries != null && this.entries.size() > cnt || this.rdrsMap != null && this.rdrsMap.size() > cnt;
        }

        public String toString() {
            return S.toString(CacheExpiryPolicy.class, this);
        }
    }

    public static class FutureHolder {
        private final ReentrantLock lock = new ReentrantLock();
        private IgniteInternalFuture<?> fut;

        public boolean tryLock() {
            return this.lock.tryLock();
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public boolean holdsLock() {
            return this.lock.isHeldByCurrentThread();
        }

        public IgniteInternalFuture<?> future() {
            return this.fut;
        }

        public void future(@Nullable IgniteInternalFuture<?> fut) {
            this.fut = fut;
        }

        public void await() {
            IgniteInternalFuture<?> fut = this.fut;
            if (fut != null && !fut.isDone()) {
                try {
                    fut.get();
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
            }
        }

        public void saveFuture(IgniteInternalFuture<?> fut) {
            assert (fut != null);
            assert (this.holdsLock());
            if (fut.isDone()) {
                this.future(null);
            } else {
                this.future(fut);
                fut.listen(f -> {
                    if (!this.tryLock()) {
                        return;
                    }
                    try {
                        if (this.future() == f) {
                            this.future(null);
                        }
                    }
                    finally {
                        this.unlock();
                    }
                });
            }
        }
    }

    private static class LoadCacheJobV2<K, V>
    extends LoadCacheJob<K, V> {
        private static final long serialVersionUID = 0L;
        private final boolean keepBinary;

        public LoadCacheJobV2(String cacheName, AffinityTopologyVersion topVer, IgniteBiPredicate<K, V> p, Object[] loadArgs, ExpiryPolicy plc, boolean keepBinary) {
            super(cacheName, topVer, p, loadArgs, plc);
            this.keepBinary = keepBinary;
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            assert (cache != null) : "Failed to get a cache [cacheName=" + this.cacheName + ", topVer=" + this.topVer + "]";
            if (this.keepBinary) {
                cache = cache.keepBinary();
            }
            return super.localExecute(cache);
        }

        @Override
        public String toString() {
            return S.toString(LoadCacheJobV2.class, this);
        }
    }

    @GridInternal
    private static class LoadCacheJob<K, V>
    extends TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final IgniteBiPredicate<K, V> p;
        private final Object[] loadArgs;
        private final ExpiryPolicy plc;

        private LoadCacheJob(String cacheName, AffinityTopologyVersion topVer, IgniteBiPredicate<K, V> p, Object[] loadArgs, ExpiryPolicy plc) {
            super(cacheName, topVer);
            this.p = p;
            this.loadArgs = loadArgs;
            this.plc = plc;
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            try {
                assert (cache != null) : "Failed to get a cache [cacheName=" + this.cacheName + ", topVer=" + this.topVer + "]";
                if (this.plc != null) {
                    cache = cache.withExpiryPolicy(this.plc);
                }
                cache.localLoadCache(this.p, this.loadArgs);
                return null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        public String toString() {
            return S.toString(LoadCacheJob.class, this);
        }
    }

    private static class SizeLongJob
    extends TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final CachePeekMode[] peekModes;

        private SizeLongJob(String cacheName, AffinityTopologyVersion topVer, CachePeekMode[] peekModes) {
            super(cacheName, topVer);
            this.peekModes = peekModes;
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            if (cache == null) {
                return 0L;
            }
            try {
                return cache.localSizeLong(this.peekModes);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        public String toString() {
            return S.toString(SizeLongJob.class, this);
        }
    }

    private static class SizeJob
    extends TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final CachePeekMode[] peekModes;

        private SizeJob(String cacheName, AffinityTopologyVersion topVer, CachePeekMode[] peekModes) {
            super(cacheName, topVer);
            this.peekModes = peekModes;
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            if (cache == null) {
                return 0;
            }
            try {
                return cache.localSize(this.peekModes);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        public String toString() {
            return S.toString(SizeJob.class, this);
        }
    }

    private static class PartitionSizeLongJob
    extends TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final int partition;
        private final CachePeekMode[] peekModes;

        private PartitionSizeLongJob(String cacheName, AffinityTopologyVersion topVer, CachePeekMode[] peekModes, int partition) {
            super(cacheName, topVer);
            this.peekModes = peekModes;
            this.partition = partition;
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            if (cache == null) {
                return 0;
            }
            try {
                return cache.localSizeLong(this.partition, this.peekModes);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        public String toString() {
            return S.toString(PartitionSizeLongJob.class, this);
        }
    }

    private static class GlobalClearKeySetNearJob<K>
    extends GlobalClearKeySetJob<K> {
        private static final long serialVersionUID = 0L;

        private GlobalClearKeySetNearJob(String cacheName, AffinityTopologyVersion topVer, Set<? extends K> keys) {
            super(cacheName, topVer, keys);
        }

        @Override
        protected boolean clearServerCache() {
            return false;
        }

        @Override
        protected boolean clearNearCache() {
            return true;
        }
    }

    private static class GlobalClearAllNearJob
    extends GlobalClearAllJob {
        private static final long serialVersionUID = 0L;

        private GlobalClearAllNearJob(String cacheName, AffinityTopologyVersion topVer) {
            super(cacheName, topVer);
        }

        @Override
        protected boolean clearServerCache() {
            return false;
        }

        @Override
        protected boolean clearNearCache() {
            return true;
        }
    }

    private static class GlobalClearKeySetJob<K>
    extends TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final Set<? extends K> keys;

        private GlobalClearKeySetJob(String cacheName, AffinityTopologyVersion topVer, Set<? extends K> keys) {
            super(cacheName, topVer);
            this.keys = keys;
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            if (cache != null) {
                cache.clearLocallyAll(this.keys, this.clearServerCache(), this.clearNearCache(), true);
            }
            return null;
        }

        protected boolean clearServerCache() {
            return true;
        }

        protected boolean clearNearCache() {
            return false;
        }
    }

    private static class GlobalClearAllJob
    extends TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;

        private GlobalClearAllJob(String cacheName, AffinityTopologyVersion topVer) {
            super(cacheName, topVer);
        }

        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache) {
            if (cache != null) {
                cache.clearLocally(this.clearServerCache(), this.clearNearCache(), true);
            }
            return null;
        }

        protected boolean clearServerCache() {
            return true;
        }

        protected boolean clearNearCache() {
            return false;
        }
    }

    protected abstract class AsyncOp<T> {
        private final boolean single;

        protected AsyncOp() {
            this.single = true;
        }

        protected AsyncOp(Collection<?> keys) {
            this.single = keys.size() == 1;
        }

        final boolean single() {
            return this.single;
        }

        public abstract IgniteInternalFuture<T> op(GridNearTxLocal var1, AffinityTopologyVersion var2);

        public IgniteInternalFuture<T> op(GridNearTxLocal tx) {
            AffinityTopologyVersion txTopVer = tx.topologyVersionSnapshot();
            if (txTopVer != null) {
                return this.op(tx, null);
            }
            AffinityTopologyVersion topVer = GridCacheAdapter.this.ctx.shared().exchange().readyAffinityVersion();
            IgniteInternalFuture<AffinityTopologyVersion> topFut = GridCacheAdapter.this.ctx.shared().exchange().affinityReadyFuture(topVer);
            if (topFut == null || topFut.isDone()) {
                return this.op(tx, topVer);
            }
            return this.waitTopologyFuture(topFut, topVer, tx, GridCacheAdapter.this.ctx.operationContextPerCall());
        }

        private IgniteInternalFuture<T> waitTopologyFuture(IgniteInternalFuture<?> topFut, final AffinityTopologyVersion topVer, final GridNearTxLocal tx, final CacheOperationContext opCtx) {
            final GridFutureAdapter fut0 = new GridFutureAdapter();
            topFut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> topFut) {
                    try {
                        topFut.get();
                        IgniteInternalFuture opFut = AsyncOp.this.runOp(tx, topVer, opCtx);
                        opFut.listen(new CI1<IgniteInternalFuture<?>>(){

                            @Override
                            public void apply(IgniteInternalFuture<?> opFut) {
                                try {
                                    fut0.onDone(opFut.get());
                                }
                                catch (IgniteCheckedException e) {
                                    fut0.onDone(e);
                                }
                            }
                        });
                    }
                    catch (IgniteCheckedException e) {
                        fut0.onDone(e);
                    }
                }
            });
            return fut0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IgniteInternalFuture<T> runOp(GridNearTxLocal tx, AffinityTopologyVersion topVer, CacheOperationContext opCtx) {
            GridCacheAdapter.this.ctx.operationContextPerCall(opCtx);
            GridCacheAdapter.this.ctx.shared().txContextReset();
            try {
                IgniteInternalFuture<T> igniteInternalFuture = this.op(tx, topVer);
                return igniteInternalFuture;
            }
            finally {
                GridCacheAdapter.this.ctx.shared().txContextReset();
                GridCacheAdapter.this.ctx.operationContextPerCall(null);
            }
        }
    }

    private abstract class SyncInOp
    extends SyncOp<Object> {
        SyncInOp(boolean single) {
            super(single);
        }

        @Override
        @Nullable
        public final Object op(GridNearTxLocal tx) throws IgniteCheckedException {
            this.inOp(tx);
            return null;
        }

        public abstract void inOp(GridNearTxLocal var1) throws IgniteCheckedException;
    }

    private abstract class SyncOp<T> {
        private final boolean single;

        SyncOp(boolean single) {
            this.single = single;
        }

        final boolean single() {
            return this.single;
        }

        @Nullable
        public abstract T op(GridNearTxLocal var1) throws IgniteCheckedException;
    }

    protected static final class PeekModes {
        public boolean near;
        public boolean primary;
        public boolean backup;
        public boolean heap;
        public boolean offheap;

        protected PeekModes() {
        }

        public String toString() {
            return S.toString(PeekModes.class, this);
        }
    }

    private class AsyncOpRetryFuture<T>
    extends GridFutureAdapter<T> {
        private AsyncOp<T> op;
        private int retries;
        private GridNearTxLocal tx;
        private CacheOperationContext opCtx;

        public AsyncOpRetryFuture(AsyncOp<T> op, int retries, CacheOperationContext opCtx) {
            assert (retries > 1) : retries;
            this.tx = null;
            this.op = op;
            this.retries = retries;
            this.opCtx = opCtx;
        }

        public void execute(boolean retry) {
            this.tx = GridCacheAdapter.this.ctx.tm().newTx(true, this.op.single(), GridCacheAdapter.this.ctx.systemTx() ? GridCacheAdapter.this.ctx : null, GridCacheAdapter.this.ctx.mvccEnabled() ? TransactionConcurrency.PESSIMISTIC : TransactionConcurrency.OPTIMISTIC, GridCacheAdapter.this.ctx.mvccEnabled() ? TransactionIsolation.REPEATABLE_READ : TransactionIsolation.READ_COMMITTED, CU.transactionConfiguration(GridCacheAdapter.this.ctx, GridCacheAdapter.this.ctx.kernalContext().config()).getDefaultTxTimeout(), this.opCtx == null || !this.opCtx.skipStore(), GridCacheAdapter.this.ctx.mvccEnabled(), 0, null);
            IgniteInternalFuture<T> fut = GridCacheAdapter.this.asyncOp(this.tx, this.op, this.opCtx, retry);
            fut.listen(new IgniteInClosure<IgniteInternalFuture<T>>(){

                @Override
                public void apply(IgniteInternalFuture<T> fut) {
                    try {
                        Object res = fut.get();
                        AsyncOpRetryFuture.this.onDone(res);
                    }
                    catch (IgniteCheckedException e) {
                        ClusterTopologyCheckedException topErr;
                        if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class) && --AsyncOpRetryFuture.this.retries > 0 && !((topErr = e.getCause(ClusterTopologyCheckedException.class)) instanceof ClusterTopologyServerNotFoundException)) {
                            GridNearTxLocal tx = AsyncOpRetryFuture.this.tx;
                            assert (tx != null);
                            AffinityTopologyVersion topVer = tx.topologyVersion();
                            assert (topVer != null && topVer.topologyVersion() > 0L) : tx;
                            AffinityTopologyVersion awaitVer = new AffinityTopologyVersion(topVer.topologyVersion() + 1L, 0);
                            IgniteInternalFuture<AffinityTopologyVersion> topFut = GridCacheAdapter.this.ctx.shared().exchange().affinityReadyFuture(awaitVer);
                            topFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                                @Override
                                public void apply(IgniteInternalFuture<?> topFut) {
                                    try {
                                        topFut.get();
                                        AsyncOpRetryFuture.this.execute(true);
                                    }
                                    catch (IgniteCheckedException e) {
                                        AsyncOpRetryFuture.this.onDone(e);
                                    }
                                    finally {
                                        GridCacheAdapter.this.ctx.shared().txContextReset();
                                    }
                                }
                            });
                            return;
                        }
                        AsyncOpRetryFuture.this.onDone(e);
                    }
                }
            });
        }
    }

    protected static enum BulkOperation {
        GET,
        PUT,
        INVOKE,
        REMOVE,
        LOCK;


        public String title() {
            return this.name().toLowerCase() + "All";
        }

        public boolean canBlockTx(TransactionConcurrency concurrency, TransactionIsolation isolation) {
            if (concurrency == TransactionConcurrency.OPTIMISTIC && isolation == TransactionIsolation.SERIALIZABLE) {
                return false;
            }
            return this != GET || concurrency != TransactionConcurrency.PESSIMISTIC || isolation != TransactionIsolation.READ_COMMITTED;
        }
    }
}

