/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.ClientCacheUpdateTimeout;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class ClientCacheChangeDiscoveryMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    @GridToStringInclude
    private Map<Integer, Boolean> startedCaches;
    @GridToStringInclude
    private Set<Integer> closedCaches;
    private transient ClientCacheUpdateTimeout updateTimeoutObj;

    public ClientCacheChangeDiscoveryMessage(Map<Integer, Boolean> startedCaches, Set<Integer> closedCaches) {
        this.startedCaches = startedCaches;
        this.closedCaches = closedCaches;
    }

    public void merge(@Nullable Map<Integer, Boolean> startedCaches, @Nullable Set<Integer> closedCaches) {
        Map<Integer, Boolean> startedCaches0 = this.startedCaches;
        Set<Integer> closedCaches0 = this.closedCaches;
        if (startedCaches != null) {
            if (startedCaches0 == null) {
                this.startedCaches = startedCaches0 = new HashMap<Integer, Boolean>();
            }
            for (Map.Entry entry : startedCaches.entrySet()) {
                if (closedCaches0 != null && closedCaches0.remove(entry.getKey())) continue;
                Boolean old = startedCaches0.put((Integer)entry.getKey(), (Boolean)entry.getValue());
                assert (old == null) : (Integer)entry.getKey();
            }
        }
        if (closedCaches != null) {
            if (closedCaches0 == null) {
                this.closedCaches = closedCaches0 = new HashSet<Integer>();
            }
            for (Integer n : closedCaches) {
                if (startedCaches0 != null && startedCaches0.remove(n) != null) continue;
                boolean add = closedCaches0.add(n);
                assert (add) : n;
            }
        }
    }

    public boolean empty() {
        return F.isEmpty(this.startedCaches) && F.isEmpty(this.closedCaches);
    }

    void checkCachesExist(Set<Integer> caches) {
        Integer cacheId;
        Iterator<Integer> it;
        if (this.closedCaches != null) {
            it = this.closedCaches.iterator();
            while (it.hasNext()) {
                cacheId = it.next();
                if (caches.contains(cacheId)) continue;
                it.remove();
            }
        }
        if (this.startedCaches != null) {
            it = this.startedCaches.keySet().iterator();
            while (it.hasNext()) {
                cacheId = it.next();
                if (caches.contains(cacheId)) continue;
                it.remove();
            }
        }
    }

    public ClientCacheUpdateTimeout updateTimeoutObject() {
        return this.updateTimeoutObj;
    }

    public void updateTimeoutObject(ClientCacheUpdateTimeout updateTimeoutObj) {
        this.updateTimeoutObj = updateTimeoutObj;
    }

    @Nullable
    public Map<Integer, Boolean> startedCaches() {
        return this.startedCaches;
    }

    @Nullable
    public Set<Integer> closedCaches() {
        return this.closedCaches;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean stopProcess() {
        return false;
    }

    @Override
    @Nullable
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(ClientCacheChangeDiscoveryMessage.class, this);
    }
}

