/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.SerializeSeparately;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;

public class CacheConfigurationSplitterImpl
implements CacheConfigurationSplitter {
    private static final CacheConfiguration<?, ?> DEFAULT_CACHE_CONFIG = new CacheConfiguration();
    private static final NearCacheConfiguration<?, ?> DEFAULT_NEAR_CACHE_CONFIG = new NearCacheConfiguration();
    private static final String[] FIELDS_V1 = new String[]{"evictPlcFactory", "evictFilter", "storeFactory", "storeSesLsnrs"};
    private final Marshaller marshaller;
    private final GridKernalContext ctx;

    public CacheConfigurationSplitterImpl(GridKernalContext ctx, Marshaller marshaller) {
        this.marshaller = marshaller;
        this.ctx = ctx;
    }

    @Override
    public T2<CacheConfiguration, CacheConfigurationEnrichment> split(CacheConfiguration ccfg) {
        try {
            CacheConfiguration cfgCp = new CacheConfiguration(ccfg);
            CacheConfigurationEnrichment enrichment = this.buildEnrichment(CacheConfiguration.class, cfgCp, DEFAULT_CACHE_CONFIG);
            return new T2<CacheConfiguration, CacheConfigurationEnrichment>(cfgCp, enrichment);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to split cache configuration", e);
        }
    }

    private <T> CacheConfigurationEnrichment buildEnrichment(Class<T> cfgCls, T cfg, T dfltCfg) throws IllegalAccessException {
        HashMap<String, byte[]> enrichment = new HashMap<String, byte[]>();
        HashMap<String, String> fieldClsNames = new HashMap<String, String>();
        for (Field field : cfgCls.getDeclaredFields()) {
            if (!this.supports(field)) continue;
            field.setAccessible(true);
            Object val = field.get(cfg);
            byte[] serializedVal = this.serialize(field.getName(), val);
            enrichment.put(field.getName(), serializedVal);
            fieldClsNames.put(field.getName(), val != null ? val.getClass().getName() : null);
            field.set(cfg, field.get(dfltCfg));
        }
        return new CacheConfigurationEnrichment(enrichment, fieldClsNames);
    }

    private boolean supports(Field field) {
        if (field.getDeclaredAnnotation(SerializeSeparately.class) == null) {
            return false;
        }
        if (IgniteFeatures.allNodesSupport(this.ctx, IgniteFeatures.SPLITTED_CACHE_CONFIGURATIONS_V2)) {
            return true;
        }
        for (String filedName : FIELDS_V1) {
            if (!filedName.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private byte[] serialize(String fieldName, Object val) {
        try {
            return U.marshal(this.marshaller, val);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to serialize field [fieldName=" + fieldName + ", value=" + val + ']', e);
        }
    }
}

