/*
 * Decompiled with CFR 0.152.
 */
package com.gridgain.cdc.gg9togg8;

import com.gridgain.cdc.gg9togg8.ConversionService;
import com.gridgain.cdc.gg9togg8.meta.Gg8FieldMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg8TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9FieldMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9TableMetadata;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class ConversionServiceImpl
implements ConversionService {
    private final Gg8TableMetadata gg8TabMeta;
    private final Gg9TableMetadata gg9TabMeta;
    private final IgniteBinary igniteBinary;

    public ConversionServiceImpl(Gg8TableMetadata gg8TabMeta, Gg9TableMetadata gg9TabMeta, IgniteBinary igniteBinary) {
        this.gg9TabMeta = gg9TabMeta;
        this.gg8TabMeta = gg8TabMeta;
        this.igniteBinary = igniteBinary;
    }

    @Override
    @Nullable
    public Object convertKeyTuple(Tuple tuple) {
        return this.convert(tuple, this.gg8TabMeta.keyTypeName(), this.gg8TabMeta.keyMeta(), this.gg9TabMeta.keyMeta());
    }

    @Override
    @Nullable
    public Object convertValTuple(Tuple tuple) {
        return this.convert(tuple, this.gg8TabMeta.valTypeName(), this.gg8TabMeta.valMeta(), this.gg9TabMeta.valMeta());
    }

    @Nullable
    private Object convert(Tuple tuple, String gg8TypeName, Map<String, Gg8FieldMetadata> gg8FieldMeta, Map<String, Gg9FieldMetadata> gg9FieldMeta) {
        int colCnt = tuple.columnCount();
        assert (colCnt > 0) : "Can't process tuple with zero fields [tuple=" + tuple + "]";
        boolean simpleType = ConversionServiceImpl.isSimpleType(gg8TypeName);
        assert (simpleType == (colCnt == 1)) : "Incompatible GG9 and GG8 schemas: GG8 type is simple but GG9 type is not";
        BinaryObjectBuilder builder = simpleType ? null : this.igniteBinary.builder(gg8TypeName);
        for (int i = 0; i < colCnt; ++i) {
            Object gg8val;
            Class<?> realType;
            String fieldName = tuple.columnName(i);
            Gg9FieldMetadata gg9Meta = gg9FieldMeta.get(fieldName);
            assert (gg9Meta != null) : "Missing gg9 metadata for field named " + fieldName;
            ColumnType gg9Type = gg9Meta.type();
            Object gg9Val = tuple.value(i);
            Class<?> clazz = realType = gg9Val == null ? null : gg9Val.getClass();
            assert (realType == null || realType == gg9Type.javaClass()) : "Real type differs from what defined in metadata [tuple=" + tuple + ", fieldName=" + fieldName + ", gg9Meta=" + gg9Meta + "]";
            switch (gg9Type) {
                case NULL: {
                    assert (gg9Val == null);
                    gg8val = null;
                    break;
                }
                case BOOLEAN: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT: 
                case DOUBLE: 
                case DECIMAL: 
                case UUID: 
                case STRING: 
                case BYTE_ARRAY: {
                    gg8val = gg9Val;
                    break;
                }
                case DATE: {
                    gg8val = ConversionServiceImpl.convert((LocalDate)gg9Val);
                    break;
                }
                case TIME: {
                    gg8val = ConversionServiceImpl.convert((LocalTime)gg9Val);
                    break;
                }
                case DATETIME: {
                    gg8val = ConversionServiceImpl.convert((LocalDateTime)gg9Val);
                    break;
                }
                case TIMESTAMP: {
                    gg8val = ConversionServiceImpl.convert((Instant)gg9Val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected enum value [tuple=" + tuple + ",gg9type=" + gg9Type + "]");
                }
            }
            Gg8FieldMetadata gg8Meta = gg8FieldMeta.get(fieldName);
            if (!gg8Meta.nullable() && gg8val == null) {
                throw new IllegalArgumentException("Null value for non-nullable field [tuple=" + tuple + ", fieldName=" + fieldName + "]");
            }
            if (simpleType) {
                return gg8val;
            }
            builder.setField(fieldName, gg8val);
        }
        return builder.build();
    }

    @Nullable
    private static Date convert(@Nullable LocalDate src) {
        return src == null ? null : Date.valueOf(src);
    }

    @Nullable
    private static Time convert(@Nullable LocalTime src) {
        return src == null ? null : Time.valueOf(src);
    }

    @Nullable
    private static Timestamp convert(@Nullable LocalDateTime src) {
        return src == null ? null : Timestamp.valueOf(src);
    }

    @Nullable
    private static Timestamp convert(@Nullable Instant src) {
        return src == null ? null : Timestamp.from(src);
    }

    private static boolean isSimpleType(String gg8TypeName) {
        return Boolean.class.getName().equals(gg8TypeName) || Byte.class.getName().equals(gg8TypeName) || Short.class.getName().equals(gg8TypeName) || Integer.class.getName().equals(gg8TypeName) || Long.class.getName().equals(gg8TypeName) || Float.class.getName().equals(gg8TypeName) || Double.class.getName().equals(gg8TypeName) || BigDecimal.class.getName().equals(gg8TypeName) || String.class.getName().equals(gg8TypeName) || Date.class.getName().equals(gg8TypeName) || Time.class.getName().equals(gg8TypeName) || Timestamp.class.getName().equals(gg8TypeName) || UUID.class.getName().equals(gg8TypeName) || byte[].class.getName().equals(gg8TypeName);
    }
}

