/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Date;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.QueryHistory;

public class SqlQueryHistoryView {
    private final QueryHistory qry;

    public SqlQueryHistoryView(QueryHistory qry) {
        this.qry = qry;
    }

    @Order
    public String schemaName() {
        return this.qry.schema();
    }

    @Order(value=1)
    public String sql() {
        return this.qry.query();
    }

    @Order(value=2)
    public boolean local() {
        return this.qry.local();
    }

    @Order(value=3)
    public long executions() {
        return this.qry.executions();
    }

    @Order(value=4)
    public long failures() {
        return this.qry.failures();
    }

    @Order(value=5)
    public long durationMin() {
        return this.qry.minimumTime();
    }

    @Order(value=6)
    public long durationMax() {
        return this.qry.maximumTime();
    }

    @Order(value=7)
    public Date lastStartTime() {
        return new Date(this.qry.lastStartTime());
    }

    @Order(value=12)
    public long memoryMax() {
        return this.qry.maxMemory();
    }

    @Order(value=13)
    public long memoryMin() {
        return this.qry.minMemory();
    }

    @Order(value=14)
    public boolean distributedJoins() {
        return this.qry.distributedJoins();
    }

    @Order(value=15)
    public boolean enforceJoinOrder() {
        return this.qry.enforceJoinOrder();
    }

    @Order(value=16)
    public boolean lazy() {
        return this.qry.lazy();
    }

    @Order(value=9)
    public long diskAllocationMin() {
        return this.qry.minBytesAllocatedOnDisk();
    }

    @Order(value=8)
    public long diskAllocationMax() {
        return this.qry.maxBytesAllocatedOnDisk();
    }

    @Order(value=11)
    public long diskAllocationTotalMin() {
        return this.qry.minTotalBytesWrittenOnDisk();
    }

    @Order(value=10)
    public long diskAllocationTotalMax() {
        return this.qry.maxTotalBytesWrittenOnDisk();
    }
}

