/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.spi.IgniteSpiManagementMBean;

@MXBeanDescription(value="MBean provide access to TCP-based communication SPI.")
public interface TcpCommunicationSpiMBean
extends IgniteSpiManagementMBean {
    @MXBeanDescription(value="Grid node IP address.")
    public String getLocalAddress();

    @MXBeanDescription(value="Port number.")
    public int getLocalPort();

    @MXBeanDescription(value="Paired connections used.")
    public boolean isUsePairedConnections();

    @MXBeanDescription(value="Connections per node.")
    public int getConnectionsPerNode();

    @MXBeanDescription(value="Shared memory endpoint port number.")
    public int getSharedMemoryPort();

    @MXBeanDescription(value="Local port range.")
    public int getLocalPortRange();

    @MXBeanDescription(value="Maximum idle connection time.")
    public long getIdleConnectionTimeout();

    @MXBeanDescription(value="Flag that indicates whether direct or heap allocated buffer is used.")
    public boolean isDirectBuffer();

    @MXBeanDescription(value="Count of selectors used in TCP server.")
    public int getSelectorsCount();

    @MXBeanDescription(value="Sent messages count.")
    public int getSentMessagesCount();

    @MXBeanDescription(value="Sent bytes count.")
    public long getSentBytesCount();

    @MXBeanDescription(value="Received messages count.")
    public int getReceivedMessagesCount();

    @MXBeanDescription(value="Received bytes count.")
    public long getReceivedBytesCount();

    @MXBeanDescription(value="Received messages count grouped by message type.")
    public Map<String, Long> getReceivedMessagesByType();

    @MXBeanDescription(value="Received messages count grouped by sender node.")
    public Map<UUID, Long> getReceivedMessagesByNode();

    @MXBeanDescription(value="Sent messages count grouped by message type.")
    public Map<String, Long> getSentMessagesByType();

    @MXBeanDescription(value="Sent messages count grouped by receiver node.")
    public Map<UUID, Long> getSentMessagesByNode();

    @MXBeanDescription(value="Outbound messages queue size.")
    public int getOutboundMessagesQueueSize();

    @MXBeanDescription(value="Connect timeout.")
    public long getConnectTimeout();

    @MXBeanDescription(value="Maximum connect timeout.")
    public long getMaxConnectTimeout();

    @MXBeanDescription(value="Reconnect count on connection failure.")
    public int getReconnectCount();

    @MXBeanDescription(value="Selector thread busy-loop iterations.")
    public long getSelectorSpins();

    @MXBeanDescription(value="TCP_NODELAY socket option value.")
    public boolean isTcpNoDelay();

    @MXBeanDescription(value="Direct send buffer.")
    public boolean isDirectSendBuffer();

    @MXBeanDescription(value="Socket receive buffer.")
    public int getSocketReceiveBuffer();

    @MXBeanDescription(value="Socket send buffer.")
    public int getSocketSendBuffer();

    @MXBeanDescription(value="Message queue size limit.")
    public int getMessageQueueLimit();

    @MXBeanDescription(value="Socket write timeout.")
    public long getSocketWriteTimeout();

    @MXBeanDescription(value="Number of received messages after which acknowledgment is sent.")
    public int getAckSendThreshold();

    @MXBeanDescription(value="Accrued size of received messages after which an acknowledgment is sent.")
    public long getAckSendThresholdBytes();

    @MXBeanDescription(value="Number of milliseconds after which an acknowledgment is sent (if there are unacknowledged messages).")
    public long getAckSendThresholdMillis();

    @MXBeanDescription(value="Maximum number of unacknowledged messages.")
    public int getUnacknowledgedMessagesBufferSize();

    @MXBeanDescription(value="Slow client queue limit.")
    public int getSlowClientQueueLimit();

    @MXBeanDescription(value="Dumps SPI statistics to logs.")
    public void dumpStats();
}

