/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.checkpoint;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.commandline.meta.subcommands.VoidDto;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.checkpoint.VisorCheckpointJobResult;
import org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTaskResult;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCheckpointTask
extends VisorMultiNodeTask<VoidDto, VisorCheckpointTaskResult, VisorCheckpointJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VoidDto, VisorCheckpointJobResult> job(VoidDto arg) {
        return new CheckpointingForceJob(this.debug);
    }

    @Override
    protected VisorCheckpointTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        VisorCheckpointTaskResult res = new VisorCheckpointTaskResult();
        for (ComputeJobResult result : results) {
            VisorCheckpointJobResult nodeRes = (VisorCheckpointJobResult)result.getData();
            res.status().put(nodeRes.nodeId(), nodeRes);
        }
        return res;
    }

    private static void readFutureResult(GridFutureAdapter fut, VisorCheckpointJobResult res) {
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            res.error(e);
        }
    }

    private static class CheckpointingForceJob
    extends VisorJob<VoidDto, VisorCheckpointJobResult> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private GridFutureAdapter fut;
        private VisorCheckpointJobResult res;
        long startTime;

        public CheckpointingForceJob(boolean debug) {
            super(null, debug);
        }

        @Override
        protected VisorCheckpointJobResult run(@Nullable VoidDto arg) throws IgniteException {
            if (this.fut == null) {
                this.res = new VisorCheckpointJobResult();
                this.res.nodeId(this.ignite.localNode().id());
                this.startTime = U.currentTimeMillis();
                CheckpointProgress progress = this.ignite.context().cache().context().database().forceCheckpoint("force");
                if (progress == null) {
                    this.res.durationMillis(U.currentTimeMillis() - this.startTime);
                    return this.res;
                }
                this.fut = progress.futureFor(CheckpointState.FINISHED);
                if (this.fut.isDone()) {
                    VisorCheckpointTask.readFutureResult(this.fut, this.res);
                    return this.res;
                }
                this.jobCtx.holdcc();
                this.fut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                    @Override
                    public void apply(IgniteInternalFuture f) {
                        res.durationMillis(U.currentTimeMillis() - startTime);
                        if (f.isCancelled()) {
                            res.error(f.error());
                        }
                        jobCtx.callcc();
                    }
                });
                return null;
            }
            VisorCheckpointTask.readFutureResult(this.fut, this.res);
            return this.res;
        }
    }
}

