/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.IpcEndpointBindException;
import org.apache.ignite.internal.util.ipc.IpcServerEndpoint;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryClientEndpoint;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryInitResponse;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryNativeLoader;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryUtils;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class IpcSharedMemoryServerEndpoint
implements IpcServerEndpoint {
    public static final String OUT_OF_RESOURCES_MSG = "Failed to allocate shared memory segment";
    public static final int DFLT_IPC_PORT = 10500;
    public static final int DFLT_SPACE_SIZE = 262144;
    public static final String DFLT_TOKEN_DIR_PATH = "ipc/shmem";
    public static final String TOKEN_FILE_NAME = "gg-shmem-space-";
    private static final String LOCK_FILE_NAME = "lock.file";
    private static final long GC_FREQ = 10000L;
    private static final AtomicLong tokIdxGen = new AtomicLong();
    private int port = 10500;
    private String tokDirPath = "ipc/shmem";
    private int size = 262144;
    @GridToStringExclude
    private ServerSocket srvSock;
    private File tokDir;
    @LoggerResource
    private IgniteLogger log;
    private UUID locNodeId;
    private String igniteInstanceName;
    private final String workDir;
    private boolean omitOutOfResourcesWarn;
    private GridWorker gcWorker;
    private int pid;
    private volatile boolean closed;
    private final Collection<IpcSharedMemoryClientEndpoint> endpoints = new GridConcurrentHashSet<IpcSharedMemoryClientEndpoint>();

    public IpcSharedMemoryServerEndpoint(String workDir) {
        this.workDir = workDir;
    }

    public IpcSharedMemoryServerEndpoint(IgniteLogger log, UUID locNodeId, String igniteInstanceName, String workDir) {
        this.log = log;
        this.locNodeId = locNodeId;
        this.igniteInstanceName = igniteInstanceName;
        this.workDir = workDir;
    }

    public void omitOutOfResourcesWarning(boolean omitOutOfResourcesWarn) {
        this.omitOutOfResourcesWarn = omitOutOfResourcesWarn;
    }

    @Override
    public void start() throws IgniteCheckedException {
        IpcSharedMemoryNativeLoader.load(this.log);
        this.pid = IpcSharedMemoryUtils.pid();
        if (this.pid == -1) {
            throw new IpcEndpointBindException("Failed to get PID of the current process.");
        }
        if (this.size <= 0) {
            throw new IpcEndpointBindException("Space size should be positive: " + this.size);
        }
        String tokDirPath = this.tokDirPath;
        if (F.isEmpty(tokDirPath)) {
            throw new IpcEndpointBindException("Token directory path is empty.");
        }
        tokDirPath = tokDirPath + '/' + this.locNodeId.toString() + '-' + IpcSharedMemoryUtils.pid();
        this.tokDir = U.resolveWorkDirectory(this.workDir, tokDirPath, false);
        if (this.port <= 0 || this.port >= 65535) {
            throw new IpcEndpointBindException("Port value is illegal: " + this.port);
        }
        try {
            this.srvSock = new ServerSocket();
            this.srvSock.bind(new InetSocketAddress("127.0.0.1", this.port));
        }
        catch (IOException e) {
            U.closeQuiet(this.srvSock);
            throw new IpcEndpointBindException("Failed to bind shared memory IPC endpoint (is port already in use?): " + this.port, e);
        }
        this.gcWorker = new GcWorker(this.igniteInstanceName, "ipc-shmem-gc", this.log);
        new IgniteThread(this.gcWorker).start();
        if (this.log.isInfoEnabled()) {
            this.log.info("IPC shared memory server endpoint started [port=" + this.port + ", tokDir=" + this.tokDir.getAbsolutePath() + ']');
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public IpcEndpoint accept() throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @IgniteInstanceResource
    private void injectResources(Ignite ignite) {
        if (ignite != null) {
            this.igniteInstanceName = ignite.name();
            this.locNodeId = ignite.configuration().getNodeId();
        } else {
            this.igniteInstanceName = null;
            this.locNodeId = null;
        }
    }

    private void sendErrorResponse(ObjectOutput out, Exception err) {
        try {
            out.writeObject(new IpcSharedMemoryInitResponse(err));
        }
        catch (IOException e) {
            U.error(this.log, "Failed to send error response to client.", e);
        }
    }

    private IgnitePair<String> inOutToken(int pid, int size) {
        long idx;
        while (!tokIdxGen.compareAndSet(idx = tokIdxGen.get(), idx + 2L)) {
        }
        return new IgnitePair<String>(new File(this.tokDir, TOKEN_FILE_NAME + idx + "-" + pid + "-" + size).getAbsolutePath(), new File(this.tokDir, TOKEN_FILE_NAME + (idx + 1L) + "-" + pid + "-" + size).getAbsolutePath());
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getHost() {
        return null;
    }

    @Override
    public boolean isManagement() {
        return false;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getTokenDirectoryPath() {
        return this.tokDirPath;
    }

    public void setTokenDirectoryPath(String tokDirPath) {
        this.tokDirPath = tokDirPath;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void close() {
        this.closed = true;
        U.closeQuiet(this.srvSock);
        if (this.gcWorker != null) {
            U.cancel(this.gcWorker);
            boolean interrupted = Thread.interrupted();
            try {
                U.join(this.gcWorker);
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Interrupted when stopping GC worker.", e);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public String toString() {
        return S.toString(IpcSharedMemoryServerEndpoint.class, this);
    }

    public void setupConfiguration(Map<String, String> endpointCfg) throws IgniteCheckedException {
        for (Map.Entry<String, String> e : endpointCfg.entrySet()) {
            try {
                switch (e.getKey()) {
                    case "type": 
                    case "host": 
                    case "management": {
                        break;
                    }
                    case "port": {
                        this.setPort(Integer.parseInt(e.getValue()));
                        break;
                    }
                    case "size": {
                        this.setSize(Integer.parseInt(e.getValue()));
                        break;
                    }
                    case "tokenDirectoryPath": {
                        this.setTokenDirectoryPath(e.getValue());
                        break;
                    }
                    default: {
                        throw new IgniteCheckedException("Invalid property '" + e.getKey() + "' of " + this.getClass().getSimpleName());
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof IgniteCheckedException || t instanceof Error) {
                    throw t;
                }
                throw new IgniteCheckedException("Invalid value '" + e.getValue() + "' of the property '" + e.getKey() + "' in " + this.getClass().getSimpleName(), t);
            }
        }
    }

    private class GcWorker
    extends GridWorker {
        protected GcWorker(String igniteInstanceName, String name, IgniteLogger log) {
            super(igniteInstanceName, name, log);
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            if (this.log.isDebugEnabled()) {
                this.log.debug("GC worker started.");
            }
            File workTokDir = IpcSharedMemoryServerEndpoint.this.tokDir.getParentFile();
            assert (workTokDir != null);
            boolean lastRunNeeded = true;
            while (true) {
                try {
                    if (lastRunNeeded) {
                        Thread.sleep(10000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Starting GC iteration.");
                }
                this.cleanupResources(workTokDir);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Processing local spaces.");
                }
                for (IpcSharedMemoryClientEndpoint e : IpcSharedMemoryServerEndpoint.this.endpoints) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Processing endpoint: " + e);
                    }
                    if (e.checkOtherPartyAlive()) continue;
                    IpcSharedMemoryServerEndpoint.this.endpoints.remove(e);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Removed endpoint: " + e);
                }
                if (!this.isCancelled()) continue;
                if (!lastRunNeeded) break;
                lastRunNeeded = false;
                Thread.interrupted();
            }
            Thread.currentThread().interrupt();
        }

        /*
         * Exception decompiling
         */
        private void cleanupResources(File workTokDir) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTokenDirectory(File workTokDir) {
            for (File f : workTokDir.listFiles()) {
                File[] shmemToks;
                int pid;
                if (!f.isDirectory()) {
                    if (f.getName().equals(IpcSharedMemoryServerEndpoint.LOCK_FILE_NAME) || !this.log.isDebugEnabled()) continue;
                    this.log.debug("Unexpected file: " + f.getName());
                    continue;
                }
                if (f.equals(IpcSharedMemoryServerEndpoint.this.tokDir)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping own token directory: " + IpcSharedMemoryServerEndpoint.this.tokDir.getName());
                    continue;
                }
                String name = f.getName();
                try {
                    pid = Integer.parseInt(name.substring(name.lastIndexOf(45) + 1));
                }
                catch (NumberFormatException ignored) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to parse file name: " + name);
                    continue;
                }
                if (IpcSharedMemoryUtils.alive(pid)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping alive node: " + pid);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Possibly stale token folder: " + f);
                }
                if ((shmemToks = f.listFiles()) == null) {
                    return;
                }
                int rmvCnt = 0;
                try {
                    for (File f0 : shmemToks) {
                        int size;
                        int pid0;
                        String[] toks;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Processing token file: " + f0.getName());
                        }
                        if (f0.isDirectory() && this.log.isDebugEnabled()) {
                            this.log.debug("Unexpected directory: " + f0.getName());
                        }
                        if ((toks = f0.getName().split("-")).length != 6) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Unrecognized token file: " + f0.getName());
                            continue;
                        }
                        try {
                            pid0 = Integer.parseInt(toks[4]);
                            size = Integer.parseInt(toks[5]);
                        }
                        catch (NumberFormatException ignored) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Failed to parse file name: " + name);
                            continue;
                        }
                        if (IpcSharedMemoryUtils.alive(pid0)) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Skipping alive process: " + pid0);
                            continue;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Possibly stale token file: " + f0);
                        }
                        IpcSharedMemoryUtils.freeSystemResources(f0.getAbsolutePath(), size);
                        if (f0.delete()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Deleted file: " + f0.getName());
                            }
                            ++rmvCnt;
                            continue;
                        }
                        if (!f0.exists()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("File has been concurrently deleted: " + f0.getName());
                            }
                            ++rmvCnt;
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Failed to delete file: " + f0.getName());
                    }
                }
                finally {
                    if (rmvCnt == shmemToks.length) {
                        U.delete(f);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Deleted empty token directory: " + f.getName());
                        }
                    }
                }
            }
        }
    }
}

